/*
 * Decompiled with CFR 0.152.
 */
package JSim.nml.ode1;

import JSim.jruntime.RTContext;
import JSim.nml.ode1.ODE1Slave;
import JSim.nml.ode1.ODE1Solver;
import JSim.util.Xcept;

public class ODE1SolverKM
extends ODE1Slave {
    private double minStepSize = this.realVal("ode_KM_minstep");
    private double maxStepSize = this.realVal("ode_KM_maxstep");
    private double tol = this.realVal("ode_KM_tol");

    public ODE1SolverKM(ODE1Solver s) throws Xcept {
        super(s, "Kutta-Merson");
    }

    public void solve(RTContext ctxt, double x0, double xend, double[] y0, double[] yend) throws Xcept {
        int i;
        int n = y0.length;
        double x = x0;
        double[] ydot = new double[n];
        double[] f2 = new double[n];
        double[] f3 = new double[n];
        double[] f4 = new double[n];
        double[] f5 = new double[n];
        double[] k1 = new double[n];
        double[] k2 = new double[n];
        double[] k3 = new double[n];
        double[] k4 = new double[n];
        double[] k5 = new double[n];
        double[] a1 = new double[n];
        double[] a2 = new double[n];
        double[] r = new double[n];
        double rmax = 0.0;
        double stepSize = xend - x0;
        double h = stepSize / 5.0;
        for (i = 0; i < n; ++i) {
            yend[i] = y0[i];
        }
        while (x < xend) {
            boolean flg = true;
            boolean flg2 = false;
            this.callbacks().evaluate(ctxt, x, yend, ydot);
            for (i = 0; i < n; ++i) {
                k1[i] = ydot[i];
            }
            while (flg) {
                for (i = 0; i < n; ++i) {
                    f2[i] = yend[i] + h * k1[i] / 3.0;
                }
                this.callbacks().evaluate(ctxt, x + h / 3.0, f2, ydot);
                for (i = 0; i < n; ++i) {
                    k2[i] = ydot[i];
                    f3[i] = yend[i] + h * (k1[i] + k2[i]) / 6.0;
                }
                this.callbacks().evaluate(ctxt, x + h / 3.0, f3, ydot);
                for (i = 0; i < n; ++i) {
                    k3[i] = ydot[i];
                    f4[i] = yend[i] + h * (k1[i] + 3.0 * k3[i]) / 8.0;
                }
                this.callbacks().evaluate(ctxt, x + h / 2.0, f4, ydot);
                for (i = 0; i < n; ++i) {
                    k4[i] = ydot[i];
                    f5[i] = yend[i] + h * (k1[i] - 3.0 * k3[i] + 4.0 * k4[i]) / 2.0;
                }
                this.callbacks().evaluate(ctxt, x + h, f5, ydot);
                for (i = 0; i < n; ++i) {
                    k5[i] = ydot[i];
                }
                for (i = 0; i < n; ++i) {
                    a1[i] = f5[i];
                    a2[i] = yend[i] + h * (k1[i] + 4.0 * k4[i] + k5[i]) / 6.0;
                    r[i] = Math.abs(a1[i] - a2[i]) / (5.0 * h);
                }
                rmax = 0.0;
                for (i = 0; i < n; ++i) {
                    if (Double.isInfinite(r[i]) || Double.isNaN(r[i])) {
                        throw new Xcept("Solver Kutta-Merson failed");
                    }
                    if (!(r[i] > rmax)) continue;
                    rmax = r[i];
                }
                if (rmax > this.tol && !flg2) {
                    if (!((h *= 0.82 * Math.pow(this.tol / rmax, 0.2)) < this.minStepSize)) continue;
                    flg2 = true;
                    h = this.minStepSize;
                    continue;
                }
                flg = false;
                x += h;
                for (i = 0; i < n; ++i) {
                    yend[i] = a2[i];
                }
                h *= 0.85 * Math.pow(this.tol / rmax, 0.2);
                if (x + (h = Math.min(Math.max(this.minStepSize, h), this.maxStepSize)) > xend) {
                    h = xend - x;
                }
                flg2 = false;
            }
        }
        this.callbacks().evaluate(ctxt, x0, y0, ydot);
    }
}

