/*
 * Decompiled with CFR 0.152.
 */
package JSim.nml.ode1;

import JSim.jruntime.RTContext;
import JSim.nml.ode1.ODE1Callbacks;
import JSim.nml.ode1.ODE1Slave;
import JSim.nml.ode1.ODE1Solver;
import JSim.util.Xcept;

public class ODE1SolverRadau
extends ODE1Slave {
    private double rtol = this.realVal("ode_Radau_reltol");
    private double atol = this.realVal("ode_Radau_abstol");
    private int nmax = this.intVal("ode_Radau_nstep");
    private int nsmin;
    private int nsmax;
    private int nsini;
    private int snewton;
    private double uround = this.intVal("ode_Radau_round");
    private double safe = this.realVal("ode_Radau_safety");
    private double compjac;
    private double fac1;
    private double fac2;
    private double fac3;
    private double fac4;
    private double fac5;
    private double fac6;
    private double fac7;
    private double fac8;

    public ODE1SolverRadau(ODE1Solver s) throws Xcept {
        super(s, "Radau (stiff)");
        this.nsmin = this.intVal("ode_Radau_minord");
        this.nsmax = this.intVal("ode_Radau_maxord");
        this.nsini = this.intVal("ode_Radau_initord");
        this.snewton = this.intVal("ode_Radau_newton");
        this.compjac = this.realVal("ode_Radau_jacob");
        this.fac1 = this.realVal("ode_Radau_losize");
        this.fac2 = this.realVal("ode_Radau_hisize");
        this.fac3 = this.realVal("ode_Radau_loselect");
        this.fac4 = this.realVal("ode_Radau_hiselect");
        this.fac5 = this.realVal("ode_Radau_locontract");
        this.fac6 = this.realVal("ode_Radau_hicontract");
        this.fac7 = this.realVal("ode_Radau_hiorder");
        this.fac8 = this.realVal("ode_Radau_loorder");
    }

    public void solve(RTContext ctxt, double x0, double xend, double[] y0, double[] yend) throws Xcept {
        int neqn = y0.length;
        double[] ydot = new double[neqn];
        for (int i = 0; i < neqn; ++i) {
            if (Double.isInfinite(y0[i]) || Double.isNaN(y0[i])) {
                throw new Xcept("Solver Error: Radau, state variables are either Inf or NaN");
            }
            yend[i] = y0[i];
        }
        int idid = this.jradau(ctxt.threadInx, ctxt, neqn, x0, xend, yend, ydot, this.rtol, this.atol, this.nmax, this.nsmin, this.nsmax, this.nsini, this.snewton, this.uround, this.safe, this.compjac, this.fac1, this.fac2, this.fac3, this.fac4, this.fac5, this.fac6, this.fac7, this.fac8, this.callbacks());
        if (idid < 0) {
            throw new Xcept("Solver Error: Radau - " + ODE1SolverRadau.status(idid));
        }
        this.callbacks().evaluate(ctxt, x0, y0, ydot);
    }

    public native int jradau(int var1, RTContext var2, int var3, double var4, double var6, double[] var8, double[] var9, double var10, double var12, int var14, int var15, int var16, int var17, int var18, double var19, double var21, double var23, double var25, double var27, double var29, double var31, double var33, double var35, double var37, double var39, ODE1Callbacks var41);

    public static String status(int idid) {
        switch (idid) {
            case -1: {
                return "input is not consistent";
            }
            case -2: {
                return "larger internal nmax array needed";
            }
            case -3: {
                return "step size becomes too small";
            }
            case -4: {
                return "internal matrix is repeatedly singular";
            }
        }
        return "undocumented exit status=" + idid;
    }

    static {
        System.loadLibrary("odesolver");
    }
}

