/*
 * Decompiled with CFR 0.152.
 */
package JSim.nml.opt;

import JSim.data.GridData;
import JSim.data.OptimAlg;
import JSim.data.OptimArgs;
import JSim.data.OptimResults;
import JSim.data.RealNData;
import JSim.data.RegularGridData;
import JSim.jruntime.RTContext;
import JSim.nml.opt.OptimCallbacks;
import JSim.nml.opt.Optimizer;
import JSim.util.DiagInfo;
import JSim.util.Util;
import JSim.util.Xcept;

public class GridSearch
extends Optimizer {
    public static OptimAlg.Info algInfo() {
        OptimAlg.Info algInfo = new OptimAlg.Info();
        algInfo.name = "gridsearch";
        algInfo.boundsNeeded = true;
        algInfo.sensMatNeeded = false;
        algInfo.parsNeeded = new String[]{"stepTol", "maxIters", "npoints"};
        algInfo.optimClassName = GridSearch.class.getName();
        return algInfo;
    }

    public void optimize(RTContext ctxt, OptimResults res, OptimCallbacks cbs) throws Xcept {
        double mstep;
        double yval;
        OptimArgs args = res.args;
        int nx = args.nx();
        int np = args.npoints;
        if (np < 4) {
            throw new Xcept((DiagInfo)this, "#points set to " + np + ", minimum in 4");
        }
        double[] xmin = args.xmin;
        double[] xmax = args.xmax;
        if (Util.hasNaNs((double[])xmin) || Util.hasNaNs((double[])xmax)) {
            throw new Xcept((DiagInfo)this, "xmin & xmax required");
        }
        int ncalls = 0;
        int niter = 0;
        RealNData ylast = null;
        if (!Util.hasNaNs((double[])args.xstart) && (yval = cbs.calcError(ctxt, args.xstart, res)) < args.errTol) {
            this.term(res, "# calls");
            return;
        }
        do {
            Util.verbose((String)("GridSearch iter: min=" + Util.pretty((double[])xmin) + " max=" + Util.pretty((double[])xmax)));
            RealNData y = this.createY(args.xname, xmin, xmax, np);
            if (ylast != null) {
                this.loadLast(y, ylast);
            }
            int yct = y.nsamples();
            int fct = 0;
            for (int i = 0; i < yct; ++i) {
                if (!Double.isNaN(y.realVal(i))) continue;
                ++fct;
            }
            if (args.maxCalls > 0) {
                fct = Math.min(fct, args.maxCalls - ncalls);
            }
            int[] xinxs = new int[fct];
            double[][] xvals = new double[fct][nx];
            int j = 0;
            for (int i = 0; i < yct; ++i) {
                if (!Double.isNaN(y.realVal(i))) continue;
                xinxs[j] = i;
                xvals[j] = y.gridVals(i);
                if (++j == fct) break;
            }
            double[] yvals = new double[fct];
            int ct = cbs.calcErrors(ctxt, xvals, yvals, res);
            ncalls += ct;
            if (res.bestErr < args.errTol) {
                this.term(res, "mean sqr error");
                return;
            }
            if (args.maxCalls > 0 && ncalls >= args.maxCalls) {
                this.term(res, "# calls");
                return;
            }
            int yminx = 0;
            double ymin = 0.0;
            for (int i = 0; i < fct; ++i) {
                double yval2 = yvals[i];
                y.set(xinxs[i], yval2);
                if (i != 0 && !(yval2 < ymin)) continue;
                yminx = xinxs[i];
                ymin = yval2;
            }
            double[] nmin = new double[nx];
            double[] nmax = new double[nx];
            int[] gpos = y.gridPos(yminx);
            for (int i = 0; i < nx; ++i) {
                int minx = gpos[i] - 1;
                if (minx < 0) {
                    minx = 0;
                }
                nmin[i] = y.grid(i).realVal(minx);
                int maxx = gpos[i] + 1;
                if (maxx >= np) {
                    maxx = np - 1;
                }
                nmax[i] = y.grid(i).realVal(maxx);
            }
            xmin = nmin;
            xmax = nmax;
            ylast = y;
            if (args.maxIters <= 0 || ++niter < args.maxIters) continue;
            this.term(res, "# iterations");
            return;
        } while (!((mstep = this.distance(xmin, xmax)) < args.stepTol));
        this.term(res, "step size");
    }

    private RealNData createY(String[] xnames, double[] xmin, double[] xmax, int ct) throws Xcept {
        int nx = xnames.length;
        GridData[] grids = new GridData[nx];
        for (int i = 0; i < nx; ++i) {
            grids[i] = new RegularGridData(xnames[i], null, xmin[i], xmax[i], ct);
        }
        return new RealNData("y", null, grids);
    }

    private void loadLast(RealNData y, RealNData ylast) throws Xcept {
        double thresh = 0.0;
        int n = y.ndim();
        for (int i = 0; i < n; ++i) {
            RegularGridData x = (RegularGridData)y.grid(i);
            double d = x.delta();
            if (i != 0 && !(d < thresh)) continue;
            thresh = d;
        }
        thresh *= 1.0E-6;
        int yct = y.nsamples();
        for (int i = 0; i < yct; ++i) {
            int linx;
            double[] lvals;
            double[] gvals = y.gridVals(i);
            double d = this.distance(gvals, lvals = ylast.gridVals(linx = ylast.nearestInx(gvals)));
            if (d > thresh) continue;
            double v = ylast.realVal(linx);
            y.set(i, v);
        }
    }

    private double distance(double[] x1, double[] x2) {
        double tot = 0.0;
        for (int i = 0; i < x1.length; ++i) {
            double d = x1[i] - x2[i];
            tot += d * d;
        }
        return Math.sqrt(tot);
    }

    private void term(OptimResults res, String crit) {
        res.status = 1;
        res.termMsg = "Met " + crit + " stopping criterion";
    }

    public String diagInfo() {
        return "GridSearch Optimizer";
    }

    public boolean allowMP() {
        return true;
    }
}

