/*
 * Decompiled with CFR 0.152.
 */
package JSim.nml.opt;

import JSim.data.OptimAlg;
import JSim.data.OptimArgs;
import JSim.data.OptimResults;
import JSim.jruntime.RTContext;
import JSim.nml.opt.OptimCallbacks;
import JSim.nml.opt.Optimizer;
import JSim.util.DiagInfo;
import JSim.util.Util;
import JSim.util.Xcept;

public class Simplex
extends Optimizer {
    private OptimArgs args;
    private OptimCallbacks cbs;
    private OptimResults res;

    public static OptimAlg.Info algInfo() {
        OptimAlg.Info algInfo = new OptimAlg.Info();
        algInfo.name = "simplex";
        algInfo.boundsNeeded = true;
        algInfo.sensMatNeeded = false;
        algInfo.parsNeeded = new String[]{"stepTol", "xstep"};
        algInfo.optimClassName = Simplex.class.getName();
        return algInfo;
    }

    public void optimize(RTContext ctxt, OptimResults r, OptimCallbacks cbs) throws Xcept {
        this.res = r;
        this.args = this.res.args;
        this.cbs = cbs;
        if (Util.hasNaNs((double[])this.args.xmin) || Util.hasNaNs((double[])this.args.xmax)) {
            throw new Xcept((DiagInfo)this, "xmin & xmax required");
        }
        for (int i = 0; i < this.args.nx(); ++i) {
            if (!Double.isNaN(this.args.xstart[i])) continue;
            this.args.xstart[i] = (this.args.xmax[i] + this.args.xmin[i]) / 2.0;
        }
        int n = this.args.nx();
        int[] nfout = new int[2];
        double[] tlout = new double[2];
        int[] istat = new int[1];
        double[] p = new double[n * (n + 1)];
        double[] y = new double[n + 1];
        int[] fnums = new int[n + 1];
        double[] pbar = new double[n];
        double[] pstar = new double[n];
        double[] pdstar = new double[n];
        try {
            int threadInx = ctxt == null ? 0 : ctxt.threadInx;
            this.simplx(threadInx, ctxt, n, this.args.xstart, this.args.xmin, this.args.xmax, this.args.xistep, new double[]{this.args.stepTol}, this.args.maxCalls, new double[]{this.args.errTol}, this.res.bestX, nfout, tlout, istat, p, y, fnums, pbar, pstar, pdstar);
            this.res.status = istat[0];
            this.res.finalStep = tlout[1];
            switch (istat[0]) {
                case 4: {
                    this.res.status = 3;
                    if (Util.isBlank((String)this.res.termMsg)) {
                        this.res.termMsg = "Optimiation canceled by user";
                    }
                    break;
                }
                case 3: {
                    this.res.status = 1;
                    this.res.termMsg = "Met # calls stopping criterion";
                    break;
                }
                case 2: {
                    this.res.status = 1;
                    this.res.termMsg = "All vertices have same func value";
                    break;
                }
                case 1: {
                    this.res.status = 1;
                    this.res.termMsg = "Met step size stopping criterion";
                    break;
                }
                case 0: {
                    this.res.status = 1;
                    this.res.termMsg = "Met mean sqr error stopping criterion";
                    break;
                }
                case -1: {
                    this.res.status = 3;
                    this.res.termMsg = "Nonsensical parameters supplied";
                    break;
                }
                case -2: {
                    this.res.status = 2;
                    this.res.termMsg = "Error midway through optimization";
                    break;
                }
                case -3: {
                    this.res.status = 3;
                    this.res.termMsg = "Error during first func evaluation";
                    break;
                }
                case -4: {
                    this.res.status = 3;
                    this.res.termMsg = "Canceled during first func evaluation";
                    break;
                }
                default: {
                    this.res.status = 3;
                    this.res.termMsg = "Undocumented error code (" + istat[0] + ")";
                    break;
                }
            }
        }
        catch (Exception e) {
            if (e instanceof Xcept) {
                Xcept xe = (Xcept)((Object)e);
                this.res.termMsg = xe.cleanMessage();
                throw xe;
            }
            this.res.termMsg = e.getMessage();
            throw new Xcept((DiagInfo)this, this.res.termMsg);
        }
        if (this.res.status == 3) {
            throw new Xcept("Simplex optimizer: " + this.res.termMsg);
        }
    }

    private native void simplx(int var1, RTContext var2, int var3, double[] var4, double[] var5, double[] var6, double[] var7, double[] var8, int var9, double[] var10, double[] var11, int[] var12, double[] var13, int[] var14, double[] var15, double[] var16, int[] var17, double[] var18, double[] var19, double[] var20) throws Exception;

    public native void abort(int var1);

    public double fcn(RTContext ctxt, double[] x) {
        try {
            return this.cbs.calcError(ctxt, x, this.res);
        }
        catch (Exception e) {
            int threadInx = ctxt == null ? 0 : ctxt.threadInx;
            this.abort(threadInx);
            return Double.NaN;
        }
    }

    public String diagInfo() {
        return "Simplex Optimizer";
    }

    public boolean allowMP() {
        return false;
    }

    static {
        System.loadLibrary("opt");
    }
}

