/*
 * Decompiled with CFR 0.152.
 */
package JSim.nml.opt;

import JSim.data.OptimArgs;
import JSim.data.OptimReport;
import JSim.data.OptimResults;
import JSim.data.SensMatrix;
import JSim.jruntime.RTContext;
import JSim.nml.opt.OptimCallbacks;
import JSim.nml.opt.OptimFactory;
import JSim.nml.opt.Optimizer;
import JSim.util.Util;
import JSim.util.Xcept;

public class TestOptim {
    public static void main(String[] pargs) throws Exception {
        int px = 0;
        if (pargs[px].equals("-v")) {
            Util.verbose = true;
            ++px;
        }
        if (pargs.length - px < 3) {
            throw new Xcept("Usage: TestOpt [-v] alg npoints x1 [ x2 ... ]");
        }
        String alg = pargs[px++];
        int npts = Util.toInt((String)pargs[px++]);
        int nx = pargs.length - px;
        double[] xcent = new double[nx];
        for (int i = 0; i < nx; ++i) {
            xcent[i] = Util.toDouble((String)pargs[i + px]);
        }
        OptimArgs args = new OptimArgs(alg, nx);
        for (int i = 0; i < nx; ++i) {
            args.xstart[i] = 0.0;
            args.xmin[i] = -10 - i;
            args.xmax[i] = 11.0;
            args.xistep[i] = 0.01;
        }
        args.maxCalls = 5000;
        args.errTol = 0.001;
        args.saveLogs = true;
        args.stepTol = 0.001;
        args.npoints = npts;
        args.maxIters = 20;
        args.gradTol = 0.001;
        args.eps = 0.001;
        Cbs cbs = new Cbs(xcent);
        System.loadLibrary("opt");
        Optimizer.allocNativeThreads(2);
        OptimFactory factory = new OptimFactory();
        Optimizer opt = factory.createOptimizer(alg);
        OptimResults res = new OptimResults(args);
        opt.optimize(null, res, cbs);
        if (Util.verbose) {
            OptimReport rpt = new OptimReport(res, factory.algs());
            System.err.println(rpt.getReport());
        }
        System.out.println(Util.pretty((double[])res.bestX));
        System.out.println("#calls=" + res.nCalls);
        System.out.println("term=" + res.termMsg);
    }

    public static class Cbs
    implements OptimCallbacks {
        public double[] xcent;

        public Cbs(double[] xc) {
            this.xcent = xc;
        }

        public double calcError(RTContext ctxt, double[] x, OptimResults res) throws Xcept {
            double err = 0.0;
            for (int i = 0; i < x.length; ++i) {
                double d = x[i] - this.xcent[i];
                err += d * d;
            }
            res.addResult(err, x);
            return err;
        }

        public int calcErrors(RTContext ctxt, double[][] x, double[] err, OptimResults res) throws Xcept {
            for (int i = 0; i < err.length; ++i) {
                err[i] = this.calcError(ctxt, x[i], res);
                if (!(err[i] < res.args.errTol)) continue;
                return i + 1;
            }
            return err.length;
        }

        public SensMatrix calcSensMatrix(RTContext ctxt, double[] x, double[] dx, double[] errs, OptimResults res) throws Xcept {
            throw new Xcept("calcSensMat not implemented");
        }
    }
}

