/*
 * Decompiled with CFR 0.152.
 */
package JSim.nml.pde1;

public class InterpolationSpline {
    private double[] coef;

    public InterpolationSpline(double[] x, double[] y, double yp1, double ypn) {
        double qn;
        double un;
        int n = x.length;
        double[] u = new double[n - 1];
        double[] y2 = new double[n];
        if (yp1 > Double.MAX_VALUE) {
            u[0] = 0.0;
            y2[0] = 0.0;
        } else {
            y2[0] = -0.5;
            u[0] = 3.0 / (x[1] - x[0]) * ((y[1] - y[0]) / (x[1] - x[0]) - yp1);
        }
        for (int i = 1; i < n - 1; ++i) {
            double sig = (x[i] - x[i - 1]) / (x[i + 1] - x[i - 1]);
            double p = sig * y2[i - 1] + 2.0;
            y2[i] = (sig - 1.0) / p;
            u[i] = (y[i + 1] - y[i]) / (x[i + 1] - x[i]) - (y[i] - y[i - 1]) / (x[i] - x[i - 1]);
            u[i] = (6.0 * u[i] / (x[i + 1] - x[i - 1]) - sig * u[i - 1]) / p;
        }
        if (ypn > Double.MAX_VALUE) {
            un = 0.0;
            qn = 0.0;
        } else {
            qn = 0.5;
            un = 3.0 / (x[n - 1] - x[n - 2]) * (ypn - (y[n - 1] - y[n - 2]) / (x[n - 1] - x[n - 2]));
        }
        y2[n - 1] = (un - qn * u[n - 2]) / (qn * y2[n - 2] + 1.0);
        for (int k = n - 2; k > 0; --k) {
            y2[k] = y2[k] * y2[k + 1] + u[k];
        }
        this.coef = y2;
    }

    public double splint(double[] x, double[] y, double xfit) {
        int n = x.length;
        int klo = 0;
        int khi = n - 1;
        while (khi - klo > 1) {
            int k = khi + klo >> 1;
            if (x[k] > xfit) {
                khi = k;
                continue;
            }
            klo = k;
        }
        double h = x[khi] - x[klo];
        if (h == 0.0) {
            return Double.MIN_VALUE;
        }
        double a = (x[khi] - xfit) / h;
        double b = (xfit - x[klo]) / h;
        double yfit = a * y[klo] + b * y[khi] + ((a * a * a - a) * this.coef[klo] + (b * b * b - b) * this.coef[khi]) * (h * h) / 6.0;
        return yfit;
    }
}

