/*
 * Decompiled with CFR 0.152.
 */
package JSim.nml.pde1;

import JSim.jruntime.RTContext;
import JSim.util.Xcept;

public class MacCormack {
    private Callbacks callbacks;

    public MacCormack(Callbacks cb) {
        this.callbacks = cb;
    }

    public void solve(RTContext ctxt, boolean useFCT, double ti, double tf, double[] xgrid, double[][] ui, double[][] uf) throws Xcept {
        this.validate(ctxt, useFCT, ti, tf, xgrid, ui, uf);
        this.copyMatrix(ui, uf);
        double[][] coefX = new double[ui.length][ui[0].length];
        double[][] coefXX = new double[ui.length][ui[0].length];
        double[][] src = new double[ui.length][ui[0].length];
        this.getCoeffs(ctxt, ti, xgrid, ui, coefX, coefXX, src);
        double[][] us = new double[ui.length][ui[0].length];
        double tS = this.calcTimeStep(useFCT, xgrid, ui, coefX, coefXX);
        double tCurr = ti;
        int maxCt = 10000;
        int ct = 0;
        while (tCurr < tf && ct++ < maxCt) {
            if (tf - tCurr < tS) {
                tS = tf - tCurr;
                tCurr = tf;
                this.oneTimeStep(ctxt, useFCT, tCurr, tS, xgrid, uf, us, coefX, coefXX, src);
                break;
            }
            this.oneTimeStep(ctxt, useFCT, tCurr += tS, tS, xgrid, uf, us, coefX, coefXX, src);
        }
        if (ct >= maxCt) {
            throw new Xcept("Too many internal time steps in MacCormack solver");
        }
    }

    private double calcTimeStep(boolean useFCT, double[] xgrid, double[][] ui, double[][] coefX, double[][] coefXX) throws Xcept {
        double tS;
        double dum = tS = 1.0E100;
        double dx = 1.0;
        for (int i = 0; i < ui.length; ++i) {
            for (int j = 0; j < ui[0].length - 1; ++j) {
                dx = xgrid[j + 1] - xgrid[j];
                dum = 1.0 / (Math.abs(coefX[i][j] / dx) + Math.abs(2.0 * coefXX[i][j] / dx / dx));
                if (!(tS > dum)) continue;
                tS = dum;
            }
        }
        return useFCT ? tS / 2.0 : tS;
    }

    private void oneTimeStep(RTContext ctxt, boolean useFCT, double tCurr, double tS, double[] xgrid, double[][] uf, double[][] us, double[][] coefX, double[][] coefXX, double[][] src) throws Xcept {
        int i;
        int i2;
        double vel = 0.0;
        double diff = 0.0;
        double lFlx = 0.0;
        double rFlx = 0.0;
        double dx = xgrid[1] - xgrid[0];
        double lam = tS / dx;
        double[] f1L = new double[uf.length];
        double[] f2L = new double[uf.length];
        double[] f3L = new double[uf.length];
        double[] f1R = new double[uf.length];
        double[] f2R = new double[uf.length];
        double[] f3R = new double[uf.length];
        this.getCoeffs(ctxt, tCurr, xgrid, uf, coefX, coefXX, src);
        for (i2 = 0; i2 < us.length; ++i2) {
            for (int j = 1; j < us[0].length - 1; ++j) {
                vel = coefX[i2][j];
                diff = coefXX[i2][j];
                lFlx = vel * uf[i2][j] - diff * (uf[i2][j] - uf[i2][j - 1]) / dx;
                rFlx = vel * uf[i2][j + 1] - diff * (uf[i2][j + 1] - uf[i2][j]) / dx;
                us[i2][j] = uf[i2][j] - lam * (rFlx - lFlx) + tS * (src[i2][j] + src[i2][j + 1]) / 2.0;
            }
        }
        if (useFCT) {
            this.fluxCorrectedTransport(true, tS, dx, uf, us, coefX, coefXX, src);
        }
        this.getLeftBC(ctxt, tCurr, uf, coefX, coefXX, f1L, f2L, f3L);
        for (i2 = 0; i2 < us.length; ++i2) {
            us[i2][0] = f1L[i2] != 0.0 || f2L[i2] != 0.0 ? -(f2L[i2] * (4.0 * us[i2][1] - us[i2][2]) - 2.0 * f3L[i2] * dx) / (2.0 * f1L[i2] * dx - 3.0 * f2L[i2]) : us[i2][1];
        }
        this.getRightBC(ctxt, tCurr, uf, coefX, coefXX, f1R, f2R, f3R);
        int lj = us[0].length - 1;
        for (i = 0; i < us.length; ++i) {
            us[i][lj] = f1R[i] != 0.0 || f2R[i] != 0.0 ? (f2R[i] * (4.0 * us[i][lj - 1] - us[i][lj - 2]) + 2.0 * f3R[i] * dx) / (2.0 * f1R[i] * dx + 3.0 * f2R[i]) : us[i][lj - 1];
        }
        this.getCoeffs(ctxt, tCurr, xgrid, us, coefX, coefXX, src);
        for (i = 0; i < uf.length; ++i) {
            lFlx = vel * us[i][0] - diff * (us[i][1] - us[i][0]) / dx;
            int j = 1;
            while (j < uf[0].length - 1) {
                vel = coefX[i][j];
                diff = coefXX[i][j];
                lFlx = vel * us[i][j - 1] - diff * (us[i][j] - us[i][j - 1]) / dx;
                rFlx = vel * us[i][j] - diff * (us[i][j + 1] - us[i][j]) / dx;
                double[] dArray = uf[i];
                int n = j;
                dArray[n] = dArray[n] + (us[i][j] - lam * (rFlx - lFlx) + tS * (src[i][j - 1] + src[i][j]) / 2.0);
                double[] dArray2 = uf[i];
                int n2 = j++;
                dArray2[n2] = dArray2[n2] / 2.0;
            }
        }
        if (useFCT) {
            this.fluxCorrectedTransport(false, tS / 2.0, dx, us, uf, coefX, coefXX, src);
        }
        for (i = 0; i < uf.length; ++i) {
            uf[i][0] = f1L[i] != 0.0 || f2L[i] != 0.0 ? -(f2L[i] * (4.0 * uf[i][1] - uf[i][2]) - 2.0 * f3L[i] * dx) / (2.0 * f1L[i] * dx - 3.0 * f2L[i]) : uf[i][1];
        }
        lj = uf[0].length - 1;
        for (i = 0; i < uf.length; ++i) {
            uf[i][lj] = f1R[i] != 0.0 || f2R[i] != 0.0 ? (f2R[i] * (4.0 * uf[i][lj - 1] - uf[i][lj - 2]) + 2.0 * f3R[i] * dx) / (2.0 * f1R[i] * dx + 3.0 * f2R[i]) : uf[i][lj - 1];
        }
    }

    public void fluxCorrectedTransport(boolean isPred, double tS, double dx, double[][] org, double[][] trg, double[][] coefX, double[][] coefXX, double[][] src) throws Xcept {
        int nvar;
        int i;
        int i2;
        double lam = tS / dx;
        double eps = 0.0;
        double[][] nu = new double[org.length][org[0].length];
        double[][] mu = new double[org.length][org[0].length];
        for (int i3 = 0; i3 < nu.length; ++i3) {
            for (int j = 0; j < nu[0].length; ++j) {
                eps = Math.abs(coefX[i3][j] * lam);
                nu[i3][j] = 0.16666666666666666 + eps * eps / 3.0 - coefXX[i3][j] * lam / dx;
                if (nu[i3][j] < 0.0) {
                    nu[i3][j] = 0.0;
                }
                mu[i3][j] = 0.16666666666666666 - eps * eps / 6.0 - coefXX[i3][j] * lam / dx;
                if (!(mu[i3][j] < 0.0)) continue;
                mu[i3][j] = 0.0;
            }
        }
        double[][] trgnf = new double[trg.length][trg[0].length];
        int pm = isPred ? 1 : -1;
        for (i2 = 0; i2 < trgnf.length; ++i2) {
            trgnf[i2][0] = trg[i2][0] - tS * src[i2][0];
            for (int j = 1; j < trgnf[0].length - 1; ++j) {
                trgnf[i2][j] = trg[i2][j] - tS * (src[i2][j] + src[i2][j + pm]) / 2.0;
            }
            int lst = trgnf[i2].length - 1;
            trgnf[i2][lst] = trg[i2][lst] - tS * src[i2][lst];
        }
        for (i2 = 0; i2 < trg.length; ++i2) {
            int nvar2 = trg[i2].length;
            for (int j = 1; j < nvar2 - 1; ++j) {
                double[] dArray = trg[i2];
                int n = j;
                dArray[n] = dArray[n] + nu[i2][j] * (org[i2][j + 1] - 2.0 * org[i2][j] + org[i2][j - 1]);
            }
        }
        double[][] flx = new double[trg.length][trg[0].length];
        for (i = 0; i < flx.length; ++i) {
            nvar = flx[i].length;
            for (int j = 0; j < nvar - 1; ++j) {
                flx[i][j] = mu[i][j] * (trgnf[i][j + 1] - trgnf[i][j]);
            }
        }
        for (i = 0; i < flx.length; ++i) {
            nvar = trgnf[i].length;
            double s = this.sign(trgnf[i][1] - trgnf[i][0]);
            flx[i][0] = s * Math.max(0.0, Math.min(s * (trgnf[i][2] - trgnf[i][1]), Math.abs(flx[i][0])));
            for (int j = 1; j < nvar - 2; ++j) {
                s = this.sign(trgnf[i][j + 1] - trgnf[i][j]);
                flx[i][j] = s * Math.max(0.0, this.min(s * (trgnf[i][j + 2] - trgnf[i][j + 1]), Math.abs(flx[i][j]), s * (trgnf[i][j] - trgnf[i][j - 1])));
            }
            s = this.sign(trgnf[i][nvar - 1] - trgnf[i][nvar - 2]);
            flx[i][nvar - 2] = s * Math.max(0.0, Math.min(Math.abs(flx[i][nvar - 2]), s * (trgnf[i][nvar - 2] - trgnf[i][nvar - 3])));
        }
        for (i = 0; i < flx.length; ++i) {
            nvar = trg[i].length;
            for (int j = 1; j < nvar - 1; ++j) {
                double[] dArray = trg[i];
                int n = j;
                dArray[n] = dArray[n] - (flx[i][j] - flx[i][j - 1]);
            }
        }
    }

    public void getCoeffs(RTContext ctxt, double t, double[] xgrid, double[][] uC, double[][] coefX, double[][] coefXX, double[][] src) throws Xcept {
        double[] cX = new double[coefX.length];
        double[] cXX = new double[coefXX.length];
        double[] s = new double[src.length];
        double[] u = new double[uC.length];
        for (int j = 0; j < coefX[0].length; ++j) {
            int i;
            for (i = 0; i < u.length; ++i) {
                u[i] = uC[i][j];
            }
            this.callbacks.MacCormack_State(ctxt, t, xgrid[j], u, cX, cXX, s);
            for (i = 0; i < cX.length; ++i) {
                coefX[i][j] = cX[i];
                coefXX[i][j] = cXX[i];
                src[i][j] = s[i];
            }
        }
    }

    public void getLeftBC(RTContext ctxt, double t, double[][] uC, double[][] coefX, double[][] coefXX, double[] f1, double[] f2, double[] f3) throws Xcept {
        int i;
        double[] cX = new double[coefX.length];
        double[] cXX = new double[coefXX.length];
        double[] u = new double[uC.length];
        for (i = 0; i < u.length; ++i) {
            cX[i] = coefX[i][0];
            cXX[i] = coefXX[i][0];
        }
        this.callbacks.common_LHB(ctxt, t, u, f1, f2, f3);
        for (i = 0; i < u.length; ++i) {
            uC[i][0] = u[i];
        }
    }

    public void getRightBC(RTContext ctxt, double t, double[][] uC, double[][] coefX, double[][] coefXX, double[] f1, double[] f2, double[] f3) throws Xcept {
        int i;
        double[] cX = new double[coefX.length];
        double[] cXX = new double[coefXX.length];
        double[] u = new double[uC.length];
        for (i = 0; i < u.length; ++i) {
            cX[i] = coefX[i][coefX[0].length - 1];
            cXX[i] = coefXX[i][coefX[0].length - 1];
        }
        this.callbacks.common_RHB(ctxt, t, u, f1, f2, f3);
        for (i = 0; i < u.length; ++i) {
            uC[i][uC[i].length - 1] = u[i];
        }
    }

    public void copyMatrix(double[][] src, double[][] trg) {
        for (int i = 0; i < src.length; ++i) {
            for (int j = 0; j < src[0].length; ++j) {
                trg[i][j] = src[i][j];
            }
        }
    }

    public double sign(double x) {
        return x < 0.0 ? -1.0 : 1.0;
    }

    public double min(double a, double b, double c) {
        return Math.min(a, Math.min(b, c));
    }

    public void validate(RTContext ctxt, boolean useFCT, double ti, double tf, double[] xgrid, double[][] ui, double[][] uf) throws Xcept {
        String macStr = "in MacCormack solver";
        if (tf < ti) {
            throw new Xcept("Final time less then initial time in MacCormack solver");
        }
        for (int i = 0; i < ui.length; ++i) {
            if (Double.isNaN(ui[i][0])) {
                throw new Xcept("NaN detected at LHB " + macStr);
            }
            if (!Double.isNaN(ui[i][ui[i].length - 1])) continue;
            throw new Xcept("NaN detected at RHB " + macStr);
        }
    }

    public static interface Callbacks {
        public void MacCormack_State(RTContext var1, double var2, double var4, double[] var6, double[] var7, double[] var8, double[] var9) throws Xcept;

        public void common_LHB(RTContext var1, double var2, double[] var4, double[] var5, double[] var6, double[] var7) throws Xcept;

        public void common_RHB(RTContext var1, double var2, double[] var4, double[] var5, double[] var6, double[] var7) throws Xcept;
    }
}

