/*
 * Decompiled with CFR 0.152.
 */
package JSim.nml.pde1;

import JSim.data.NamedVal;
import JSim.jruntime.RTContext;
import JSim.nml.Solver;
import JSim.nml.pde1.PDE1Callbacks;
import JSim.nml.pde1.PDE1Slave;
import JSim.nml.pde1.PDE1SolverLSFEA1;
import JSim.nml.pde1.PDE1SolverLSFEA2;
import JSim.nml.pde1.PDE1SolverMacCormack;
import JSim.nml.pde1.PDE1SolverToms731;
import JSim.util.Xcept;

public class PDE1Solver
extends Solver {
    private int n;
    protected int which;
    private PDE1Slave slave;

    public PDE1Solver(PDE1Callbacks cb, int inx, NamedVal.Query nvals, int nn) throws Xcept {
        super(cb, inx, nvals);
        this.n = nn;
        int which = this.intVal("pde_which");
        this.slave = this.createSlave(which);
    }

    private PDE1Slave createSlave(int which) throws Xcept {
        PDE1Callbacks callbacks = (PDE1Callbacks)this.callbacks();
        if (which != 1 && !callbacks.usesPDESolver(which)) {
            which = 1;
        }
        if (which == 1 && !callbacks.usesPDESolver(which)) {
            which = 2;
        }
        switch (which) {
            case 0: {
                return new PDE1SolverLSFEA2(this);
            }
            case 2: {
                return new PDE1SolverToms731(this);
            }
            case 1: {
                return new PDE1SolverMacCormack(this);
            }
            case 3: {
                return new PDE1SolverLSFEA1(this);
            }
        }
        throw new Xcept("Unknown PDE solver slave");
    }

    public void solve(RTContext ctxt, double t0, double tfinal, double[] xgrid, double[][] u0, double[][] uf, double[][] ut0, double[][] utf, double[][] ux0, double[][] uxf, double[][] uxt0, double[][] uxtf, double[] v0, double[] vf, double[] vt0, double[] vtf) throws Xcept {
        this.slave.solve(ctxt, t0, tfinal, xgrid, u0, uf, ut0, utf, ux0, uxf, uxt0, uxtf, v0, vf, vt0, vtf);
    }

    public boolean isReentrant() {
        return this.slave.isReentrant();
    }

    public int npde() {
        return this.n;
    }

    public String solverName() {
        if (this.slave == null) {
            return "unspecified PDE solver";
        }
        return this.slave.name() + " PDE solver";
    }

    public static native void allocNativeThreads(int var0);
}

