/*
 * Decompiled with CFR 0.152.
 */
package JSim.plan;

import JSim.plan.Cache;
import JSim.plan.Calc;
import JSim.plan.DomainCalc;
import JSim.plan.ExprCalc;
import JSim.plan.FuncCalc;
import JSim.plan.FzeroProc;
import JSim.plan.IfCalc;
import JSim.plan.LoopCalc;
import JSim.plan.MultiCalc;
import JSim.plan.ODEProc;
import JSim.plan.PDEProc;
import JSim.plan.PlanIF;
import JSim.plan.Proc;
import JSim.plan.ProcCalc;
import JSim.plan.RelationCalc;
import JSim.plan.SetCalc;
import JSim.plan.TopProc;
import JSim.util.Lang;
import JSim.util.Xcept;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;

public abstract class PlanWriter {
    public PlanIF plan;
    public Lang lang;
    public PrintWriter out;
    public int indent;
    public Cache cache;

    public PlanWriter(PlanIF p, Lang l) {
        this.plan = p;
        this.lang = l;
        this.indent = 0;
    }

    protected abstract void write() throws Xcept;

    public void write(Writer o) throws Xcept {
        this.out = new PrintWriter(o);
        this.write();
        this.out.close();
    }

    public void write(OutputStream o) throws Xcept {
        this.write(new PrintWriter(o, true));
    }

    public String writeText() throws Xcept {
        StringWriter sout = new StringWriter();
        this.write(sout);
        return sout.toString();
    }

    public boolean allowMPRuns() {
        for (int i = 0; i < this.plan.funcs().size(); ++i) {
            if (this.plan.funcs().xfunc(i).isReentrant()) continue;
            return false;
        }
        return true;
    }

    public void println(String s) {
        if (s.length() > 0) {
            int ct;
            for (ct = this.lang.indent(this.indent); ct >= 8; ct -= 8) {
                this.out.print("\t");
            }
            for (int i = 0; i < ct; ++i) {
                this.out.print(" ");
            }
        }
        this.out.println(s);
    }

    public void writeProc(Proc proc) throws Xcept {
        this.cache = proc.cache;
        if (proc instanceof TopProc) {
            this.write((TopProc)proc);
        } else if (proc instanceof FzeroProc) {
            this.write((FzeroProc)proc);
        } else if (proc instanceof ODEProc) {
            this.write((ODEProc)proc);
        } else if (proc instanceof PDEProc) {
            this.write((PDEProc)proc);
        } else {
            throw new Xcept("Unsupported Proc class");
        }
    }

    public void writeCalc(Calc calc) throws Xcept {
        if (calc instanceof ExprCalc) {
            this.write((ExprCalc)calc);
        } else if (calc instanceof DomainCalc) {
            this.write((DomainCalc)calc);
        } else if (calc instanceof FuncCalc) {
            this.write((FuncCalc)calc);
        } else if (calc instanceof LoopCalc) {
            this.write((LoopCalc)calc);
        } else if (calc instanceof IfCalc) {
            this.write((IfCalc)calc);
        } else if (calc instanceof SetCalc) {
            this.write((SetCalc)calc);
        } else if (calc instanceof MultiCalc) {
            this.write((MultiCalc)calc);
        } else if (calc instanceof ProcCalc) {
            this.write((ProcCalc)calc);
        } else if (calc instanceof RelationCalc) {
            this.write((RelationCalc)calc);
        } else {
            throw new Xcept("Unsupported Calc class");
        }
    }

    public abstract void write(TopProc var1) throws Xcept;

    public abstract void write(FzeroProc var1) throws Xcept;

    public abstract void write(ODEProc var1) throws Xcept;

    public abstract void write(PDEProc var1) throws Xcept;

    public abstract void write(ExprCalc var1) throws Xcept;

    public abstract void write(DomainCalc var1) throws Xcept;

    public abstract void write(FuncCalc var1) throws Xcept;

    public abstract void write(LoopCalc var1) throws Xcept;

    public abstract void write(IfCalc var1) throws Xcept;

    public abstract void write(SetCalc var1) throws Xcept;

    public abstract void write(MultiCalc var1) throws Xcept;

    public abstract void write(ProcCalc var1) throws Xcept;

    public abstract void write(RelationCalc var1) throws Xcept;
}

