/*
 * Decompiled with CFR 0.152.
 */
package JSim.plan1;

import JSim.mml.Domain;
import JSim.mml.MathSys;
import JSim.mml.SubDom;
import JSim.mml.Var;
import JSim.plan1.DEBlockPhase;
import JSim.plan1.DEBlockTool;
import JSim.plan1.DETool;
import JSim.plan1.DomainTool;
import JSim.plan1.EventTool;
import JSim.plan1.Tool;
import JSim.plan1.ToolBox;
import JSim.plan1.ToolSet;
import JSim.util.Expr;
import JSim.util.Util;
import JSim.util.Xcept;

public class DEBlockBuilder {
    protected MathSys math;
    protected ToolBox box;
    protected ToolSet deUsed;

    public DEBlockBuilder(ToolBox b) throws Xcept {
        this.math = b.math;
        this.box = b;
        Util.verbose((String)"==== DEBlockBuilder assembling DE blocks");
        this.deUsed = new ToolSet(this.box);
        boolean working = true;
        while (working) {
            working = false;
            Tool.List detools = new Tool.List(16);
            for (int i = 0; i < this.box.size(); ++i) {
                if (!(this.box.tool(i) instanceof DETool) || this.deUsed.hasTool(i)) continue;
                detools.add(this.box.tool(i));
            }
            if (detools.size() == 0) continue;
            DEBlockTool[] blocks = new DEBlockTool[detools.size()];
            for (int i = 0; i < detools.size(); ++i) {
                DETool tool = (DETool)detools.tool(i);
                Util.verbose((String)("    posit " + tool));
                blocks[i] = new DEBlockTool(tool);
                this.expand(blocks[i]);
            }
            DEBlockTool nblock = blocks[0];
            for (int i = 1; i < detools.size(); ++i) {
                if (nblock.nState() >= blocks[i].nState()) continue;
                nblock = blocks[i];
            }
            Util.verbose((String)("   augmenting " + nblock));
            boolean augmenting = true;
            block4: while (augmenting) {
                augmenting = false;
                for (int i = 0; i < detools.size(); ++i) {
                    DETool tool = (DETool)detools.tool(i);
                    if (tool.t != nblock.t || tool.x != nblock.x || nblock.detools.contains(tool)) continue;
                    DEBlockTool wblock = new DEBlockTool(tool);
                    wblock.addDETool(nblock.detools);
                    this.expand(wblock);
                    double cost1 = this.cost(nblock) + this.cost(blocks[i]);
                    double cost2 = this.cost(wblock);
                    Util.verbose((String)("\tcosts " + blocks[i] + " old=" + this.cost(nblock) + " new=" + this.cost(blocks[i]) + " combined=" + cost2 + ": " + (cost1 <= cost2 ? "reject" : "accept")));
                    if (cost1 <= cost2) continue;
                    Util.verbose((String)("    combining " + nblock + " with " + blocks[i]));
                    nblock = wblock;
                    augmenting = true;
                    continue block4;
                }
            }
            this.deUsed.add(nblock.detools);
            nblock.borg();
            this.box.addTool(nblock);
            nblock.vreq.sub(nblock.vsol);
            nblock.setSolverOptions();
            working = true;
        }
    }

    private double cost(DEBlockTool b) {
        return this.cost(b.nState());
    }

    private double cost(DEBlockTool b1, DEBlockTool b2) {
        Expr.List v = b1.vstate.copy();
        v.addUniq((Expr.List)b2.vstate);
        return this.cost(v.size());
    }

    private double cost(int n) {
        return n * n * n;
    }

    private void expand(DEBlockTool wblock) throws Xcept {
        boolean working = true;
        while (working) {
            working = this.expand(wblock.ephase);
            if (wblock.x == null) continue;
            working = working || this.expand(wblock.lphase);
            working = working || this.expand(wblock.rphase);
        }
    }

    private boolean expand(DEBlockPhase phase) throws Xcept {
        boolean working = false;
        for (int i = 0; i < phase.muwant.size(); ++i) {
            Tool tool;
            Var v = (Var)((Object)phase.muwant.get(i));
            if (v.isDomain() || (tool = this.nonBlockTool(v, phase.sdom)) == null || !this.muCompatible(tool, phase) || tool.isInputTool() || tool == null) continue;
            if (tool instanceof DETool) {
                if (phase.block.vstate.contains((Object)v)) continue;
                phase.block.addDETool((DETool)tool);
            } else {
                if (phase.tools.contains(tool)) continue;
                phase.addAux(tool);
            }
            working = true;
        }
        return working;
    }

    protected Tool nonBlockTool(Var v, SubDom sdom) throws Xcept {
        int i;
        DEBlockPhase phase;
        Tool tool = this.box.tool(v, sdom);
        if (tool == null) {
            return tool;
        }
        if (!(tool instanceof DEBlockTool)) {
            if (!tool.sdcalc.isEntire() && tool.sdcalc.sameAs(sdom)) {
                return null;
            }
            return tool;
        }
        DEBlockTool block = (DEBlockTool)tool;
        if (block.vstate.contains((Object)v)) {
            int i2 = block.vstate.indexOf((Object)v);
            DETool detool = block.detool(i2);
            if (sdom.isEntire()) {
                return detool;
            }
            return detool.sdTool(sdom);
        }
        if (!sdom.isEntire() && (phase = block.phase(sdom)) != null) {
            for (i = 0; i < phase.tools.size(); ++i) {
                tool = phase.tools.tool(i);
                if (!tool.solves(v, sdom)) continue;
                return tool;
            }
        }
        phase = block.ephase;
        for (i = 0; i < phase.tools.size(); ++i) {
            tool = phase.tools.tool(i);
            if (!tool.solves(v, sdom)) continue;
            return tool;
        }
        return null;
    }

    public boolean muCompatible(Tool tool, DEBlockPhase phase) throws Xcept {
        return this.muCompatible(tool, phase, new ToolSet(this.box));
    }

    public boolean muCompatible(Tool tool, DEBlockPhase phase, ToolSet used) throws Xcept {
        Domain.List blockDoms;
        Util.verbose((String)("\tmuCompatible " + tool));
        DEBlockTool block = phase.block;
        if (tool == null) {
            return this.stat(tool, "tool is null");
        }
        if (used.hasTool(tool)) {
            return this.stat(tool, null);
        }
        if (!(tool.sdcalc.isEntire() || phase.sdom.isEntire() || tool.sdcalc.sameAs(phase.sdom))) {
            return this.stat(tool, "BC domain incompatible");
        }
        if (tool instanceof DomainTool) {
            DomainTool dtool = (DomainTool)tool;
            boolean ret = block.doms.contains((Object)dtool.v);
            return this.stat(tool, ret ? null : "domain");
        }
        if (tool instanceof EventTool) {
            return this.stat(tool, "event");
        }
        if (tool instanceof DETool) {
            DETool ptool = (DETool)tool;
            if (block.t != ptool.t) {
                return this.stat(tool, "DE.t");
            }
            if (block.x != ptool.x) {
                return this.stat(tool, "DE.x");
            }
            if (!block.doms.equalSet(ptool.vdoms)) {
                return this.stat(tool, "DE doms");
            }
            return this.stat(tool, null);
        }
        if (tool.isInputTool()) {
            return this.stat(tool, null);
        }
        Domain.List vsolDoms = tool.vsol.domainList();
        boolean match = vsolDoms.equalSet(blockDoms = block.vsol.domainList());
        if (!match) {
            return this.stat(tool, "vsol domain mismatch");
        }
        for (int i = 0; i < tool.vreq.size(); ++i) {
            Var v = (Var)((Object)tool.vreq.get(i));
            Tool vtool = this.nonBlockTool(v, phase.sdom);
            if (vtool == null) continue;
            used.add(tool);
            if (!this.muCompatible(vtool, phase, used)) continue;
            return this.stat(tool, null);
        }
        return this.stat(tool, "vreq");
    }

    private boolean stat(Tool tool, String msg) {
        Util.verbose((String)("\tmuCompatible(" + tool + ") err=" + msg + " tool.vreq=" + (Object)((Object)tool.vreq)));
        return msg == null;
    }
}

