/*
 * Decompiled with CFR 0.152.
 */
package JSim.plan1;

import JSim.aserver.ASModel;
import JSim.mml.Domain;
import JSim.mml.SubDom;
import JSim.mml.Var;
import JSim.plan.DEBlockToolIF;
import JSim.plan.MultiCalc;
import JSim.plan.ODEProc;
import JSim.plan.PDEProc;
import JSim.plan.Proc;
import JSim.plan.ProcCalc;
import JSim.plan1.DEBlockPhase;
import JSim.plan1.DEConTool;
import JSim.plan1.DETool;
import JSim.plan1.DomCtl;
import JSim.plan1.PlanSeq;
import JSim.plan1.SequenceXcept;
import JSim.plan1.Tool;
import JSim.plan1.ToolSet;
import JSim.util.CompareExpr;
import JSim.util.DiagInfo;
import JSim.util.Expr;
import JSim.util.Known;
import JSim.util.NamedExpr;
import JSim.util.TypedSet;
import JSim.util.Util;
import JSim.util.Xcept;

public class DEBlockTool
extends Tool
implements DEBlockToolIF {
    public Domain t;
    public Domain x;
    public Expr.List dedoms;
    public Tool.List detools;
    public Domain.List doms;
    public Var.List vstate;
    public DEBlockPhase ephase;
    public DEBlockPhase lphase;
    public DEBlockPhase rphase;
    private String[] pdeMessages;

    public DEBlockTool(DETool tool) throws Xcept {
        super(tool.box);
        this.sdsol = SubDom.entire();
        this.sdcalc = SubDom.entire();
        this.t = tool.t;
        this.x = tool.x;
        this.doms = tool.vdoms;
        this.detools = new Tool.List(1);
        this.vstate = new Var.List(1);
        this.doms = (Domain.List)((Object)tool.v.domainList().clone());
        this.ephase = new DEBlockPhase(this, SubDom.entire());
        if (this.x != null) {
            this.lphase = new DEBlockPhase(this, this.x.lhbc());
            this.rphase = new DEBlockPhase(this, this.x.rhbc());
        }
        this.pdeMessages = new String[ASModel.PDE_Solvers.length];
        for (int i = 0; i < this.pdeMessages.length; ++i) {
            this.pdeMessages[i] = "Planner failure";
        }
        this.addDETool(tool);
    }

    public void addDETool(Tool.List list) throws Xcept {
        for (int i = 0; i < list.size(); ++i) {
            this.addDETool((DETool)list.tool(i));
        }
    }

    public void addDETool(DETool tool) throws Xcept {
        if (this.detools.contains(tool)) {
            return;
        }
        Util.verbose((String)("\tadding DETool: " + tool));
        this.detools.add(tool);
        this.vstate.add((Object)tool.v);
        this.vsol.add((Object)tool.v);
        this.vsol.add((Object)tool.vt);
        if (this.x == null) {
            this.vsol.addUniq(tool.vsol);
        }
        this.ephase.add(tool.state());
        if (this.x != null) {
            this.vsol.add((Object)tool.vx);
            this.lphase.add(tool.lhbc(this.x));
            this.rphase.add(tool.rhbc(this.x));
        }
    }

    protected void setSolverOptions() throws Xcept {
        int i;
        DETool tool;
        int i2;
        if (this.x == null) {
            return;
        }
        String msg = null;
        boolean xcoef = false;
        try {
            for (i2 = 0; i2 < this.detools.size(); ++i2) {
                tool = (DETool)this.detools.tool(i2);
                tool.lsfea1OK();
                if (!tool.lsfeaXcoef()) continue;
                xcoef = true;
            }
            if (!xcoef) {
                throw new Xcept("No advection term in PDE block");
            }
            msg = null;
        }
        catch (Xcept e) {
            msg = e.getMessage();
        }
        this.pdeMessages[3] = msg;
        xcoef = false;
        try {
            for (i2 = 0; i2 < this.detools.size(); ++i2) {
                tool = (DETool)this.detools.tool(i2);
                tool.lsfea2OK(this.vstate);
                if (!tool.lsfeaXcoef()) continue;
                xcoef = true;
            }
            if (!xcoef) {
                throw new Xcept("No advection term in PDE block");
            }
            msg = null;
        }
        catch (Xcept e) {
            msg = e.getMessage();
        }
        this.pdeMessages[0] = msg;
        try {
            for (int i3 = 0; i3 < this.detools.size(); ++i3) {
                tool = (DETool)this.detools.tool(i3);
                tool.macCormackOK();
            }
            msg = null;
        }
        catch (Xcept e) {
            msg = e.getMessage();
        }
        this.pdeMessages[1] = msg;
        msg = null;
        try {
            for (int i4 = 0; i4 < this.detools.size(); ++i4) {
                tool = (DETool)this.detools.tool(i4);
                tool.toms731OK();
            }
            msg = null;
        }
        catch (Xcept e) {
            msg = e.getMessage();
        }
        this.pdeMessages[2] = msg;
        int sct = 0;
        for (i = 0; i < ASModel.PDE_Solvers.length; ++i) {
            String s = "\t    " + ASModel.PDE_Solvers[i] + " supported: " + this.usesPDESolver(i);
            if (this.usesPDESolver(i)) {
                ++sct;
            } else {
                s = s + " (" + this.getSolverMessage(i) + ")";
            }
            Util.verbose((String)s);
        }
        if (sct == 0) {
            throw new Xcept((DiagInfo)this, "PDE block not supported by any current PDE solver");
        }
        for (i = 0; i < this.detools.size(); ++i) {
            DETool tool2 = (DETool)this.detools.tool(i);
            tool2.vxxToolCreate();
        }
    }

    public DEBlockPhase phase(SubDom sdom) throws Xcept {
        if (sdom.isEntire()) {
            return this.ephase;
        }
        if (this.x == null) {
            return null;
        }
        if (sdom.isLHBC(this.x)) {
            return this.lphase;
        }
        if (sdom.isRHBC(this.x)) {
            return this.rphase;
        }
        return null;
    }

    public ToolSet auxTools() throws Xcept {
        ToolSet set = new ToolSet(this.box);
        set.add(this.ephase.tools);
        if (this.x != null) {
            set.add(this.lphase.tools);
            set.add(this.rphase.tools);
        }
        return set;
    }

    public String calcInfo(Var v) {
        try {
            Var v0 = v.zeroDeriv();
            if (!this.vstate.contains((Object)v0)) {
                return this.ephase.calcInfo(v0);
            }
            if (this.x == null) {
                return "ODE(" + (Object)((Object)this.t) + ")";
            }
            return "PDE(" + (Object)((Object)this.t) + "," + (Object)((Object)this.x) + ")";
        }
        catch (Xcept e) {
            return null;
        }
    }

    public String getSolverMessage(int i) {
        return this.pdeMessages[i];
    }

    public boolean usesPDESolver(int i) {
        return this.pdeMessages[i] == null;
    }

    public void posit(PlanSeq seq) throws Xcept {
        int i;
        Expr icknown = null;
        for (i = 0; i < this.vstate.size(); ++i) {
            TypedSet s = seq.known.getSet((NamedExpr)this.vstate.var(i));
            TypedSet sic = this.icSet(this.vstate.var(i), this.t);
            CompareExpr e = new CompareExpr(51, (Expr)sic, (Expr)s);
            icknown = icknown == null ? e : icknown.and((Expr)e);
        }
        seq.msg("icknown=" + icknown);
        icknown = icknown.simplify();
        seq.msg("  simplify=" + icknown);
        if (!icknown.isConst() || !icknown.constBoolVal()) {
            seq.msg("ICs not yet solved: " + this);
            return;
        }
        seq.msg("Posit state only " + (Object)((Object)this.vstate) + " icknown=" + icknown);
        for (i = 0; i < this.vstate.size(); ++i) {
            seq.known.setSet((NamedExpr)this.vstate.var(i), Expr.entire);
        }
    }

    public Domain.List freeDomains() {
        Domain.List list = new Domain.List(1);
        if (this.x != null) {
            list.add((Object)this.x);
        }
        return list;
    }

    public void sequencable(Known known) throws Xcept, SequenceXcept {
        for (int i = 0; i < this.vstate.size(); ++i) {
            Var v = this.vstate.var(i);
            TypedSet s = known.getSet((NamedExpr)v);
            TypedSet sic = this.icSet(v, this.t);
            CompareExpr e = new CompareExpr(51, (Expr)sic, (Expr)s);
            Expr es = e.simplify(known);
            if (es.isConst() && es.constBoolVal()) continue;
            throw new SequenceXcept(this, es, "IC for " + (Object)((Object)v) + " not satisfied");
        }
        Known known1 = new Known(known);
        for (int i = 0; i < this.vsol.size(); ++i) {
            Var v = this.vsol.var(i);
            known1.setSet((NamedExpr)v, Expr.entire);
            if (!this.vstate.contains((Object)v) || this.x == null) continue;
            known1.setSet((NamedExpr)v.deriv(this.x), Expr.entire);
        }
        this.ephase.sequencable(known1);
        if (this.x != null) {
            this.lphase.sequencable(known1);
            this.rphase.sequencable(known1);
        }
    }

    public Var.List cacheVars() throws Xcept {
        Tool tool;
        int i;
        Var.List list = new Var.List(this.nState());
        list.addUniq((Expr)this.t);
        if (this.x != null) {
            list.addUniq((Expr)this.x);
        }
        for (i = 0; i < this.nState(); ++i) {
            Var vx;
            Var v = this.vstate.var(i);
            list.addUniq((Expr)v);
            list.addUniq((Expr)v.deriv(this.t));
            if (this.x == null || (vx = v.deriv(this.x, false)) == null) continue;
            list.addUniq((Expr)vx);
            Var vxt = vx.deriv(this.t, false);
            if (vxt == null) continue;
            list.addUniq((Expr)vxt);
        }
        for (i = 0; i < this.ephase.tools.size(); ++i) {
            tool = this.ephase.tools.tool(i);
            list.addUniq(tool.vsol());
        }
        if (this.x != null) {
            for (i = 0; i < this.lphase.tools.size(); ++i) {
                tool = this.lphase.tools.tool(i);
                list.addUniq(tool.vsol());
            }
            for (i = 0; i < this.rphase.tools.size(); ++i) {
                tool = this.rphase.tools.tool(i);
                list.addUniq(tool.vsol());
            }
        }
        return list;
    }

    public void borg() throws Xcept {
        for (int i = 0; i < this.detools.size(); ++i) {
            this.detools.tool((int)i).borg.add(this);
        }
        this.ephase.borg();
        if (this.x != null) {
            this.lphase.borg();
            this.rphase.borg();
        }
    }

    public void addCalc(PlanSeq seq) throws Xcept {
        Proc proc = this.x == null ? this.newODEProc(seq) : this.newPDEProc(seq);
        ProcCalc c = new ProcCalc(proc);
        seq.mcalc.add(c);
    }

    private Proc newODEProc(PlanSeq seq) throws Xcept {
        int i;
        ToolSet tools = new ToolSet(seq.plan.box);
        for (i = 0; i < this.ephase.cons.size(); ++i) {
            DEConTool con = this.ephase.cons.con(i);
            if (con.tool == null) continue;
            tools.add(con.tool);
        }
        for (i = 0; i < this.ephase.tools.size(); ++i) {
            Tool tool = this.ephase.tools.tool(i);
            if (tool instanceof DEConTool) {
                Tool t1;
                if (this.ephase.cons.contains(tool) || (t1 = ((DEConTool)tool).tool) == null) continue;
                tool = t1;
            }
            tools.add(tool);
        }
        PlanSeq oseq = new PlanSeq(seq, seq.domctl, "ODE block", tools.toolList());
        oseq.buildDeep();
        MultiCalc calc = new MultiCalc(this.vsol.size());
        oseq.append(calc);
        return new ODEProc(this.inx, this, calc);
    }

    private Proc newPDEProc(PlanSeq seq) throws Xcept {
        DomCtl domctl = new DomCtl(seq.domctl);
        domctl.setLHBC(this.x);
        MultiCalc lcalc = this.newPDEPhase(seq, domctl, this.lphase);
        domctl.setLoop(this.x);
        MultiCalc ecalc = this.newPDEPhase(seq, domctl, this.ephase);
        domctl.setRHBC(this.x);
        MultiCalc rcalc = this.newPDEPhase(seq, domctl, this.rphase);
        return new PDEProc(this.inx, this, lcalc, ecalc, rcalc);
    }

    private MultiCalc newPDEPhase(PlanSeq seq, DomCtl domctl, DEBlockPhase phase) throws Xcept {
        MultiCalc calc = new MultiCalc(this.vsol.size());
        ToolSet tools = new ToolSet(seq.plan.box);
        for (int i = 0; i < phase.tools.size(); ++i) {
            Tool tool = phase.tools.tool(i);
            if (tool instanceof DEConTool) continue;
            tools.add(tool);
        }
        PlanSeq seq1 = new PlanSeq(seq, domctl, "PDE " + phase.sdom + " phase", tools.toolList());
        seq1.buildDeep();
        seq1.append(calc);
        return calc;
    }

    public String toString() {
        String de = this.x == null ? "ODE" : "PDE";
        return de + " Block " + (Object)((Object)this.vstate);
    }

    public int nState() {
        return this.vstate.size();
    }

    public DETool detool(int i) {
        return (DETool)this.detools.tool(i);
    }

    public Var.List vstate() {
        return this.vstate;
    }

    public Var.List muVars() throws Xcept {
        return this.cacheVars();
    }

    public Domain t() {
        return this.t;
    }

    public Domain x() {
        return this.x;
    }

    public Var v(int i) {
        return this.detool((int)i).v;
    }

    public Var vt(int i) {
        return this.detool((int)i).vt;
    }

    public Var vx(int i) {
        return this.detool((int)i).vx;
    }

    public Expr coefD(int i) throws Xcept {
        return this.detool(i).coefD();
    }

    public Expr coefB(int i) throws Xcept {
        return this.detool(i).coefB();
    }

    public Expr coefS(int i) throws Xcept {
        return this.detool(i).coefS();
    }

    public Expr coefF1(int i, boolean left) throws Xcept {
        return this.detool(i).coefF1(left);
    }

    public Expr coefF2(int i, boolean left) throws Xcept {
        return this.detool(i).coefF2(left);
    }

    public Expr coefF3(int i, boolean left) throws Xcept {
        return this.detool(i).coefF3(left);
    }

    public Expr toms731_C(int i) throws Xcept {
        return this.detool(i).toms731_C();
    }

    public Expr toms731_Q(int i) throws Xcept {
        return this.detool(i).toms731_Q();
    }

    public Expr toms731_R(int i) throws Xcept {
        return this.detool(i).toms731_R();
    }

    public Expr toms731_BETA(int i, boolean left) throws Xcept {
        return this.detool(i).toms731_BETA(left);
    }

    public Expr toms731_GAMMA(int i, boolean left) throws Xcept {
        return this.detool(i).toms731_GAMMA(left);
    }
}

