/*
 * Decompiled with CFR 0.152.
 */
package JSim.plan1;

import JSim.mml.Domain;
import JSim.util.DiagInfo;
import JSim.util.Expr;
import JSim.util.Known;
import JSim.util.TypedSet;
import JSim.util.Xcept;
import java.util.ArrayList;

public class DomCtl
implements DiagInfo {
    public static final int FREE = 0;
    public static final int LHBC = 1;
    public static final int LOOP = 2;
    public static final int RHBC = 3;
    public static final String[] statStr = new String[]{"FREE", "LHBC", "LOOP", "RHBC"};
    private Domain.List domains;
    private int[] stat;

    public DomCtl(Domain.List ds) {
        this.domains = ds;
        this.stat = new int[this.domains.size()];
        for (int i = 0; i < this.domains.size(); ++i) {
            this.stat[i] = 0;
        }
    }

    public DomCtl(DomCtl domctl) {
        this.domains = domctl.domains;
        this.stat = new int[this.domains.size()];
        for (int i = 0; i < this.domains.size(); ++i) {
            this.stat[i] = domctl.stat[i];
        }
    }

    public void setFree(Domain x) throws Xcept {
        this.stat[this.domInx((Domain)x)] = 0;
    }

    public void setLHBC(Domain x) throws Xcept {
        this.stat[this.domInx((Domain)x)] = 1;
    }

    public void setRHBC(Domain x) throws Xcept {
        this.stat[this.domInx((Domain)x)] = 3;
    }

    public void setLoop(Domain x) throws Xcept {
        this.stat[this.domInx((Domain)x)] = 2;
    }

    public Domain domain(int i) {
        return (Domain)((Object)this.domains.get(i));
    }

    public int size() {
        return this.stat.length;
    }

    private int domInx(Domain x) throws Xcept {
        int i = this.domains.indexOf((Object)x);
        if (i < 0) {
            throw new Xcept((DiagInfo)this, (DiagInfo)x, "Domain not in DomCtl");
        }
        return i;
    }

    private int stat(Domain x) throws Xcept {
        return this.stat[this.domInx(x)];
    }

    public boolean isFree(Domain x) throws Xcept {
        return this.stat(x) == 0;
    }

    public boolean isLHBC(Domain x) throws Xcept {
        return this.stat(x) == 1;
    }

    public boolean isRHBC(Domain x) throws Xcept {
        return this.stat(x) == 3;
    }

    public boolean isLoop(Domain x) throws Xcept {
        return this.stat(x) == 2;
    }

    public boolean sameStat(DomCtl dctl, Domain x) throws Xcept {
        return this.stat(x) == dctl.stat(x);
    }

    public boolean calculable(Known known) throws Xcept {
        for (int i = 0; i < this.size(); ++i) {
            Domain x = this.domain(i);
            if (this.isFree(x)) continue;
            Expr calc = x.calculable(known).simplify(known);
            if (!calc.isConst()) {
                return false;
            }
            if (calc.constBoolVal()) continue;
            return false;
        }
        return true;
    }

    public boolean sameAs(DomCtl dctl) {
        if (this.stat.length != dctl.stat.length) {
            return false;
        }
        for (int i = 0; i < this.stat.length; ++i) {
            if (this.stat[i] == dctl.stat[i]) continue;
            return false;
        }
        return true;
    }

    public boolean refines(DomCtl dctl) {
        int ct = 0;
        if (this.stat.length != dctl.stat.length) {
            return false;
        }
        for (int i = 0; i < this.stat.length; ++i) {
            if (this.stat[i] == dctl.stat[i]) continue;
            if (dctl.stat[i] != 0) {
                return false;
            }
            ++ct;
        }
        return ct > 0;
    }

    public boolean subsetOf(DomCtl dctl) {
        if (this.stat.length != dctl.stat.length) {
            return false;
        }
        for (int i = 0; i < this.stat.length; ++i) {
            if (this.stat[i] == dctl.stat[i]) continue;
            if (dctl.stat[i] != 2) {
                return false;
            }
            if (this.stat[i] != 0) continue;
            return false;
        }
        return true;
    }

    public boolean freeAs(DomCtl dctl) {
        if (this.stat.length != dctl.stat.length) {
            return false;
        }
        for (int i = 0; i < this.stat.length; ++i) {
            if (this.stat[i] == dctl.stat[i] || this.stat[i] == 0) continue;
            return false;
        }
        return true;
    }

    public boolean freerThan(DomCtl dctl) {
        if (this.stat.length != dctl.stat.length) {
            return false;
        }
        boolean freer = false;
        for (int i = 0; i < this.stat.length; ++i) {
            if (this.stat[i] == dctl.stat[i]) continue;
            if (this.stat[i] == 0) {
                freer = true;
                continue;
            }
            return false;
        }
        return freer;
    }

    public TypedSet getSet(Domain x) throws Xcept {
        switch (this.stat(x)) {
            case 0: {
                return Expr.empty;
            }
            case 1: {
                return x.lhbSet();
            }
            case 3: {
                return x.rhbSet();
            }
            case 2: {
                return Expr.entire;
            }
        }
        throw new Xcept((DiagInfo)this, (DiagInfo)x, "Unknown DomCtl stat");
    }

    public String toString() {
        String s = "";
        for (int i = 0; i < this.stat.length; ++i) {
            if (i != 0) {
                s = s + " ";
            }
            s = s + this.domains.get(i) + "=" + statStr[this.stat[i]];
        }
        return s;
    }

    public String diagInfo() {
        return "DomCtl " + this.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class List
    extends ArrayList<DomCtl> {
        public List(int n) {
            super(n);
        }

        public DomCtl domctl(int i) {
            return (DomCtl)this.get(i);
        }

        public boolean hasSame(DomCtl d) {
            for (int i = 0; i < this.size(); ++i) {
                if (!this.domctl(i).sameAs(d)) continue;
                return true;
            }
            return false;
        }

        public void addUniq(DomCtl d) {
            int i;
            if (this.hasSame(d)) {
                return;
            }
            for (i = 0; i < this.size() && !this.domctl(i).refines(d); ++i) {
            }
            this.add(i, d);
        }
    }
}

