/*
 * Decompiled with CFR 0.152.
 */
package JSim.plan1;

import JSim.mml.Domain;
import JSim.mml.Event;
import JSim.mml.SubDom;
import JSim.mml.Var;
import JSim.plan.ExprCalc;
import JSim.plan.IfCalc;
import JSim.plan.MultiCalc;
import JSim.plan1.PlanSeq;
import JSim.plan1.SequenceXcept;
import JSim.plan1.Tool;
import JSim.plan1.ToolBox;
import JSim.util.CompareExpr;
import JSim.util.DiagInfo;
import JSim.util.Expr;
import JSim.util.Known;
import JSim.util.NamedExpr;
import JSim.util.TypedSet;
import JSim.util.Xcept;

public class EventTool
extends Tool {
    public Domain t;
    public Tool[] bctools;
    public Event.List events;

    public EventTool(ToolBox b, Event.List ee) throws Xcept {
        super(b);
        int i;
        this.events = ee;
        this.t = this.event(0).t();
        for (i = 1; i < this.events.size(); ++i) {
            if (this.t == this.event(i).t()) continue;
            throw new Xcept((DiagInfo)this.event(0), (DiagInfo)this.event(i), "Events with common variable have different trigger domains");
        }
        for (i = 0; i < this.events.size(); ++i) {
            this.vsol.addUniq(this.event(i).vstate());
        }
        this.bctools = new Tool[this.vsol.size()];
        this.sdsol = this.sdcalc = SubDom.entire();
    }

    public void setBC(int i, Tool tool) throws Xcept {
        this.bctools[i] = tool;
        tool.borg.add(this);
    }

    public String toString() {
        String s = " events: ";
        for (int i = 0; i < this.events.size(); ++i) {
            s = s + " " + this.events.event(i);
        }
        return s;
    }

    public String calcInfo(Var v) {
        return "event";
    }

    public Event event(int i) {
        return this.events.event(i);
    }

    public boolean hasAllBCs() {
        for (int i = 0; i < this.bctools.length; ++i) {
            if (this.bctools[i] != null) continue;
            return false;
        }
        return true;
    }

    public void validate() throws Xcept {
        int i;
        if (!this.hasAllBCs()) {
            throw new Xcept((DiagInfo)this, "not all BCs set");
        }
        for (i = 0; i < this.events.size(); ++i) {
            Event e = this.event(i);
            for (int j = 0; j < e.nactions(); ++j) {
                this.validateDomains(e.vexpr(j));
            }
        }
        for (i = 0; i < this.bctools.length; ++i) {
            this.bctools[i].unborg(this);
        }
    }

    public void posit(PlanSeq seq) throws Xcept {
        int i;
        Expr icknown = null;
        for (i = 0; i < this.vsol.size(); ++i) {
            Var v = this.vsol.var(i);
            TypedSet s = seq.known.getSet((NamedExpr)v);
            TypedSet sic = this.icSet(v, this.t);
            CompareExpr e = new CompareExpr(51, (Expr)sic, (Expr)s);
            icknown = icknown == null ? e : icknown.and((Expr)e);
        }
        seq.msg("icknown=" + icknown);
        icknown = icknown.simplify();
        seq.msg("  simplify=" + icknown);
        if (!icknown.isConst() || !icknown.constBoolVal()) {
            seq.msg("ICs not yet solved: " + this);
            return;
        }
        seq.msg("Posit state vars " + (Object)((Object)this.vsol) + " icknown=" + icknown);
        for (i = 0; i < this.vsol.size(); ++i) {
            seq.known.setSet((NamedExpr)this.vsol.var(i), Expr.entire);
        }
    }

    public void addCalc(PlanSeq seq) throws Xcept {
        int i;
        for (i = 0; i < this.events.size(); ++i) {
            Event event = this.event(i);
            MultiCalc acts = new MultiCalc(event.nactions());
            for (int j = 0; j < event.nactions(); ++j) {
                acts.add(new ExprCalc(event.v(j), event.vexpr(j)));
            }
            IfCalc ifc = new IfCalc(event.trigger(), acts, null);
            seq.mcalc.add(ifc);
        }
        for (i = 0; i < this.vsol.size(); ++i) {
            Var v = this.vsol.var(i);
            ExprCalc c = new ExprCalc(v, (Expr)v);
            c.recalc = true;
            seq.mcalc.add(c);
        }
    }

    public void sequencable(Known known) throws Xcept, SequenceXcept {
        for (int i = 0; i < this.events.size(); ++i) {
            Event e = this.event(i);
            this.calculable(known, e.trigger());
            for (int j = 0; j < e.nactions(); ++j) {
                this.calculable(known, e.vexpr(j));
            }
        }
    }
}

