/*
 * Decompiled with CFR 0.152.
 */
package JSim.plan1;

import JSim.mml.Domain;
import JSim.mml.Eqn;
import JSim.mml.SubDom;
import JSim.mml.Var;
import JSim.plan.FzeroProc;
import JSim.plan.FzeroToolIF;
import JSim.plan.ProcCalc;
import JSim.plan1.Bound;
import JSim.plan1.PlanSeq;
import JSim.plan1.SequenceXcept;
import JSim.plan1.Tool;
import JSim.plan1.ToolBox;
import JSim.util.CompareExpr;
import JSim.util.Context;
import JSim.util.DiagInfo;
import JSim.util.Expr;
import JSim.util.IfExpr;
import JSim.util.Known;
import JSim.util.NamedExpr;
import JSim.util.NamedQueryExpr;
import JSim.util.Util;
import JSim.util.Xcept;

public class FzeroTool
extends Tool
implements FzeroToolIF {
    public Expr.List exprs = new Expr.List(1);
    public Bound.List bounds = new Bound.List(1);
    public boolean isLinear;
    public Expr[] linmat;
    public Expr[] lincons;
    public Expr[] vmin;
    public Expr[] vmax;
    public Expr[] vapprox;

    public FzeroTool(ToolBox b, SubDom sd) throws Xcept {
        super(b);
        this.sdsol = sd;
        this.vreq = new Var.List(1);
        this.sdcalc = sd;
    }

    public FzeroTool(ToolBox b, SubDom sd, Var v, Eqn eqn) throws Xcept {
        this(b, sd);
        this.add(v);
        this.add(eqn);
        this.vreqSet();
    }

    public Tool iccopy(Domain t) throws Xcept {
        boolean hasT = false;
        for (int i = 0; i < this.vsol.size(); ++i) {
            if (!this.vsol.var(i).hasDomain(t)) continue;
            hasT = true;
        }
        if (!hasT) {
            return null;
        }
        FzeroTool ntool = new FzeroTool(this.box, t.lhbc());
        ntool.add(this.vsol);
        ntool.vreq = this.vreq;
        ntool.exprs = this.exprs;
        ntool.isLinear = this.isLinear;
        ntool.bounds = this.bounds;
        ntool.linmat = this.linmat;
        ntool.lincons = this.lincons;
        ntool.vmin = this.vmin;
        ntool.vmax = this.vmax;
        ntool.vapprox = this.vapprox;
        return ntool;
    }

    public void add(Var v) throws Xcept {
        this.vsol.addUniq((Expr)v);
    }

    public void add(Var.List vlist) throws Xcept {
        this.vsol.addUniq(vlist);
    }

    public void add(Eqn eqn) throws Xcept {
        Expr e = eqn.lhs.sub(eqn.rhs);
        this.exprs.add((Object)e);
    }

    public void add(Bound b) throws Xcept {
        this.bounds.add(b);
    }

    public void vreqSet() throws Xcept {
        int i;
        if (this.vsol.size() != this.exprs.size()) {
            throw new Xcept((DiagInfo)this, "FzeroTool: # vars != # eqns");
        }
        for (i = 0; i < this.exprs.size(); ++i) {
            Expr e = this.exprs.expr(i);
            this.vreq.addUniq(new Var.List(e));
        }
        for (i = 0; i < this.vsol.size(); ++i) {
            int j = this.vreq.indexOf((Object)this.vsol.comp(i));
            if (j < 0) continue;
            this.vreq.remove(j);
        }
    }

    public int nexprs() {
        return this.exprs.size();
    }

    public boolean isLinear() {
        return this.isLinear;
    }

    public SubDom sdsol() {
        return this.sdsol;
    }

    public Expr.List exprs() {
        return this.exprs;
    }

    public Expr linmat(int i) {
        return this.linmat[i];
    }

    public Expr lincons(int i) {
        return this.lincons[i];
    }

    public Expr vmin(int i) {
        return this.vmin == null ? null : this.vmin[i];
    }

    public Expr vmax(int i) {
        return this.vmax == null ? null : this.vmax[i];
    }

    public Expr vapprox(int i) {
        return this.vapprox == null ? null : this.vapprox[i];
    }

    public String calcInfo(Var v) {
        return "implicit";
    }

    public void validate() throws Xcept {
        int i;
        Expr.List oexprs = this.exprs;
        this.exprs = new Expr.List(oexprs.size());
        for (i = 0; i < oexprs.size(); ++i) {
            Expr e = oexprs.expr(i);
            e = this.box.simplify(e);
            this.exprs.add((Object)e);
        }
        for (i = 0; i < this.exprs.size(); ++i) {
            this.validateDomains(this.exprs.expr(i));
        }
        this.checkLinear();
        if (!this.isLinear) {
            this.setBounds();
        }
    }

    public void setBounds() throws Xcept {
        Util.verbose((String)("\tsetBounds() for " + this + "\n\t\t" + this.bounds));
        int n = this.nexprs();
        this.vmin = new Expr[n];
        this.vmax = new Expr[n];
        this.vapprox = new Expr[n];
        for (int i = 0; i < this.bounds.size(); ++i) {
            Bound b = this.bounds.bound(i);
            int inx = this.vsol.indexOf((Object)b.v);
            if (inx < 0) {
                throw new Xcept((DiagInfo)this, "Bounds variable index error");
            }
            Expr[] varr = null;
            switch (b.op()) {
                case 52: 
                case 53: {
                    varr = this.vmin;
                    break;
                }
                case 50: 
                case 51: {
                    varr = this.vmax;
                    break;
                }
                case 54: {
                    varr = this.vapprox;
                    if (varr[inx] != null) {
                        throw new Xcept((DiagInfo)this.vsol.var(i), "Multiple approximations not allowed");
                    }
                    b.tool.borg.add(this);
                }
            }
            if (varr[inx] == null) {
                varr[inx] = b.expr;
                continue;
            }
            CompareExpr condx = new CompareExpr(b.op(), varr[inx], b.expr);
            varr[inx] = new IfExpr((Expr)condx, varr[inx], b.expr);
        }
    }

    public void checkLinear() throws Xcept {
        int i;
        this.isLinear = true;
        int n = this.exprs.size();
        this.linmat = new Expr[n * n];
        this.lincons = new Expr[n];
        Var.List vleft = new Var.List(1);
        int k = 0;
        for (i = 0; i < n; ++i) {
            Expr e1 = this.exprs.expr(i);
            for (int j = 0; j < n; ++j) {
                Var v = this.vsol.var(j);
                Expr e2 = e1.linearFactor((NamedQueryExpr)v, true).simplify();
                e1 = e1.linearFactor((NamedQueryExpr)v, false).simplify();
                this.linmat[k++] = e2;
                e2.addNamedExpr((Expr.List)vleft);
            }
            this.lincons[i] = e1;
            e1.addNamedExpr((Expr.List)vleft);
        }
        for (i = 0; i < n; ++i) {
            Var v = this.vsol.var(i);
            if (!vleft.contains((Object)v)) continue;
            this.isLinear = false;
            break;
        }
    }

    public void sequencable(Known k) throws Xcept, SequenceXcept {
        int i;
        Known known = new Known(k);
        for (i = 0; i < this.vsol.size(); ++i) {
            known.setSet((NamedExpr)this.vsol.var(i), Expr.entire);
        }
        this.satisfied(known, this.sdcalc.expr, "SubDom");
        for (i = 0; i < this.exprs.size(); ++i) {
            this.calculable(known, this.exprs.expr(i));
        }
    }

    public void addCalc(PlanSeq seq) throws Xcept {
        FzeroProc proc = new FzeroProc(this.inx, this);
        ProcCalc c = new ProcCalc(proc);
        seq.mcalc.add(c);
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean showSD) {
        String s = this.vsol.toString(this.box.math.ctxt);
        if (showSD && !this.sdsol.isEntire()) {
            s = s + "[" + this.sdsol + "]";
        }
        s = s + " via " + this.exprs.toString((Context)this.box.math.ctxt);
        if (showSD && !this.sdcalc.isEntire()) {
            s = s + "[" + this.sdcalc + "]";
        }
        s = s + " = 0";
        return s;
    }
}

