/*
 * Decompiled with CFR 0.152.
 */
package JSim.plan1;

import JSim.mml.Domain;
import JSim.mml.SubDom;
import JSim.mml.Var;
import JSim.plan1.DomCtl;
import JSim.plan1.PlanSeq;
import JSim.plan1.RelationTool;
import JSim.plan1.SequenceXcept;
import JSim.plan1.ToolBox;
import JSim.util.CrossSet;
import JSim.util.DiagInfo;
import JSim.util.Expr;
import JSim.util.Known;
import JSim.util.TypedSet;
import JSim.util.Xcept;
import java.util.ArrayList;

public abstract class Tool
implements DiagInfo {
    protected ToolBox box;
    protected int inx;
    protected List borg;
    public SubDom sdsol;
    protected SubDom sdcalc;
    public Var.List vsol;
    protected Var.List vreq;

    public Tool(ToolBox b) {
        this.box = b;
        this.vsol = new Var.List(1);
        this.vreq = new Var.List(1);
        this.borg = new List(1);
    }

    public String diagInfo() {
        return this.toString();
    }

    public boolean isRelation() {
        return false;
    }

    public Var.List vreq() {
        return this.vreq;
    }

    public Var.List vsol() {
        return this.vsol;
    }

    public String varDesc() {
        return this.getClass().getName() + " solves " + this.vsol.toString() + " using " + this.vreq.toString();
    }

    public boolean isInputTool() {
        return false;
    }

    public String toString(boolean showSD) {
        return this.toString();
    }

    public String calcInfo(Var v) {
        return null;
    }

    public Domain.List freeDomains() {
        return new Domain.List(1);
    }

    protected void posit(PlanSeq seq) throws Xcept {
    }

    public void validate() throws Xcept {
    }

    public void unborg(Tool tool) throws Xcept {
        int i = this.borg.indexOf(tool);
        if (i < 0) {
            throw new Xcept((DiagInfo)this, (DiagInfo)tool, "Unborg() failed - programmer error");
        }
        this.borg.remove(i);
    }

    public void validateDomains(Expr expr) throws Xcept {
        Domain.List soldom = new Domain.List(1);
        for (int i = 0; i < this.vsol.size(); ++i) {
            Var v = (Var)this.vsol.comp(i);
            v.addDomains(soldom);
        }
        Domain.List reqdom = new Domain.List(1);
        expr.addDomains((Expr.List)reqdom);
        for (int i = 0; i < reqdom.size(); ++i) {
            Domain x = (Domain)reqdom.comp(i);
            if (x == this.sdcalc.bcDomain() || soldom.contains((Object)x)) continue;
            throw new Xcept((DiagInfo)this, "Solved variable(s) lack required domain " + x.name());
        }
    }

    public boolean solves(Var v, SubDom sd) throws Xcept {
        if (!sd.sameAs(this.sdsol)) {
            return false;
        }
        for (int i = 0; i < this.vsol.size(); ++i) {
            Var vv = (Var)this.vsol.comp(i);
            if (v != vv) continue;
            return true;
        }
        return false;
    }

    public Tool sdTool(SubDom sd) throws Xcept {
        return this;
    }

    public void addCalc(PlanSeq seq) throws Xcept {
        throw new Xcept((DiagInfo)this, "addCalc() not implemented for this tool");
    }

    public Tool iccopy(Domain t) throws Xcept {
        throw new Xcept((DiagInfo)this, "iccopy not implemented for this tool");
    }

    public DomCtl domctl() throws Xcept {
        DomCtl dret = new DomCtl(this.box.domains);
        Domain.List doms = this.vsol.domainList();
        if (this instanceof RelationTool) {
            ((RelationTool)this).expr.addDomains((Expr.List)doms);
        }
        doms.sub(this.freeDomains());
        for (int i = 0; i < this.box.domains.size(); ++i) {
            Domain x = this.box.domains.domain(i);
            if (!doms.contains((Object)x)) continue;
            dret.setLoop(x);
        }
        if (this.sdcalc.isLHBC()) {
            Domain x = this.sdcalc.bcDomain();
            dret.setLHBC(x);
        }
        if (this.sdcalc.isRHBC()) {
            Domain x = this.sdcalc.bcDomain();
            dret.setRHBC(x);
        }
        return dret;
    }

    public abstract void sequencable(Known var1) throws Xcept, SequenceXcept;

    public void satisfied(Known known, Expr expr, String msg) throws Xcept, SequenceXcept {
        Expr e = expr.simplify(known);
        if (e.isConst() && e.constBoolVal()) {
            return;
        }
        throw new SequenceXcept(this, expr, msg + " not satisfied");
    }

    public void calculable(Known known, Expr expr) throws Xcept, SequenceXcept {
        Expr e = expr.calculable(known).simplify(known);
        if (e.isConst() && e.constBoolVal()) {
            return;
        }
        throw new SequenceXcept(this, expr, "not calculable");
    }

    public TypedSet icSet(Var v, Domain t) throws Xcept {
        int n = v.ndim();
        TypedSet[] sarr = new TypedSet[n];
        for (int i = 0; i < n; ++i) {
            Domain z = v.domain(i);
            sarr[i] = z == t ? t.lhbSet() : Expr.entire;
        }
        if (n == 1) {
            return sarr[0];
        }
        return new CrossSet(sarr);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class List
    extends ArrayList<Tool> {
        public List(int n) {
            super(n);
        }

        public List(List list) {
            this(list.size());
            for (int i = 0; i < list.size(); ++i) {
                this.add(list.tool(i));
            }
        }

        public Tool tool(int i) {
            return (Tool)this.get(i);
        }

        @Override
        public String toString() {
            String s = "";
            for (int i = 0; i < this.size(); ++i) {
                if (i > 0) {
                    s = s + "; ";
                }
                s = s + this.tool(i).toString();
            }
            return s;
        }
    }
}

