/*
 * Decompiled with CFR 0.152.
 */
package JSim.plan2;

import JSim.mml.Domain;
import JSim.mml.Var;
import JSim.plan2.AbortXcept;
import JSim.plan2.DomainSet;
import JSim.plan2.ExprTool;
import JSim.plan2.ImplicitTool;
import JSim.plan2.TEqn;
import JSim.plan2.TExpr;
import JSim.plan2.TModel;
import JSim.plan2.Tool;
import JSim.plan2.VarUsage;
import JSim.plan2.VarUsages;
import JSim.util.Expr;
import JSim.util.Xcept;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.LinkedHashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DECon {
    private VarUsages vus;
    private VarUsages vreqs;
    private Tool tool;
    private TEqn eqn;
    private boolean isState;
    private ArrayList<Var> v0s;
    private Hashtable<Var, Expr> factorMap;

    public DECon(VarUsages vus, Tool tool) throws Xcept {
        this.tool = tool;
        this.common(vus);
    }

    public DECon(VarUsages vus, TEqn eqn) throws Xcept {
        this.eqn = eqn;
        this.common(vus);
        this.odeStateEqnToTool();
    }

    public void common(VarUsages vus) throws Xcept {
        this.vus = vus;
        this.isState = this.isState(vus);
        LinkedHashSet<Var> v0Set = new LinkedHashSet<Var>();
        for (int i = 0; i < vus.size(); ++i) {
            v0Set.add(vus.get(i).v().zeroDeriv());
        }
        this.v0s = new ArrayList(v0Set);
        if (this.isState() && this.isEqn()) {
            this.v0s = this.stateEqnV0s();
        }
        VarUsages vsrc = this.tool == null ? this.eqn.usages() : this.tool.vreqs;
        this.vreqs = new VarUsages(this.model());
        for (int i = 0; i < vsrc.size(); ++i) {
            VarUsage vu = vsrc.get(i);
            if (this.v0s.contains((Object)vu.v().zeroDeriv()) && (this.isState ? vu.isCurr() : vu.isBoundary())) continue;
            this.vreqs.add(vu);
        }
    }

    private ArrayList<Var> stateEqnV0s() throws Xcept {
        Var v0 = null;
        for (int i = 0; i < this.v0s.size(); ++i) {
            Var v = this.v0s.get(i);
            if (!this.isStateEqnFor(v)) continue;
            if (v0 == null) {
                v0 = v;
                continue;
            }
            throw new AbortXcept("Ambiguous state eqn: " + this);
        }
        if (v0 == null) {
            throw new AbortXcept("State eqn missing some derivs: " + this);
        }
        ArrayList<Var> v0list = new ArrayList<Var>();
        v0list.add(v0);
        return v0list;
    }

    boolean isStateEqnFor(Var v0) throws Xcept {
        if (!this.isState) {
            return false;
        }
        DomainSet derivDoms = this.derivDoms(v0);
        DomainSet txs = this.model().pureChildDerivDoms.get((Object)v0);
        return txs.equals(derivDoms);
    }

    private void odeStateEqnToTool() throws Xcept {
        if (!this.isEqn()) {
            return;
        }
        if (!this.isState) {
            return;
        }
        if (this.v0s.size() != 1) {
            return;
        }
        Var v = this.v0s.get(0);
        DomainSet derivDoms = this.derivDoms(v);
        if (derivDoms.size() != 1) {
            return;
        }
        Domain t = derivDoms.first();
        Var vtmax = this.vus.vtmax(v, t);
        this.log("Creating ODE tool for " + (Object)((Object)vtmax) + " from " + this.eqn);
        TExpr vexpr = this.eqn.expr().solveFor(vtmax);
        VarUsage vu = new VarUsage(this.model(), vtmax);
        this.tool = vexpr != null ? new ExprTool(vu, vexpr) : new ImplicitTool(vu, this.eqn.expr());
        this.eqn = null;
    }

    private boolean isState(VarUsages vus) throws Xcept {
        int nvint = 0;
        int nvxint = 0;
        int nvbc = 0;
        for (int i = 0; i < vus.size(); ++i) {
            VarUsage vu = vus.get(i);
            if (vu.isBoundary()) {
                ++nvbc;
                continue;
            }
            ++nvint;
            if (vu.v().derivOrder() <= 0) continue;
            ++nvxint;
        }
        if (nvxint > 0) {
            return true;
        }
        if (nvbc > 0 && nvint == 0) {
            return false;
        }
        throw new Xcept("Unprocessable ODE/PDE constraint: " + this);
    }

    private void createFactorMap() throws Xcept {
        throw new Xcept("DECon.createFactorMap not implemented");
    }

    private Expr getBCFactor(Var v) throws Xcept {
        if (this.factorMap == null) {
            this.createFactorMap();
        }
        return this.factorMap.get((Object)v);
    }

    protected boolean isIC(Var v0, Domain t) throws Xcept {
        if (this.tool == null) {
            return false;
        }
        VarUsages vus = this.tool.vsols;
        for (int i = 0; i < vus.size(); ++i) {
            VarUsage vu = vus.get(i);
            Var v = vu.v();
            if (!vu.isMin(t) || v.zeroDeriv() != v0 || v.isDeriv() && this.model().pureDerivDom(v) != t) continue;
            return true;
        }
        return false;
    }

    protected DomainSet derivDoms(Var v) throws Xcept {
        DomainSet derivDoms = new DomainSet();
        for (int i = 0; i < this.vus.size(); ++i) {
            VarUsage vu = this.vus.get(i);
            Var vx = vu.v();
            if (v != vx.zeroDeriv()) continue;
            derivDoms.addAll(this.model().derivDoms.get((Object)vx));
        }
        return derivDoms;
    }

    public TModel model() {
        if (this.tool != null) {
            return this.tool.model;
        }
        return this.eqn.model;
    }

    public VarUsages vus() {
        return this.vus;
    }

    public VarUsages vreqs() {
        return this.vreqs;
    }

    public ArrayList<Var> v0s() {
        return this.v0s;
    }

    public String toString() {
        if (this.isTool()) {
            return this.tool.toString();
        }
        return this.eqn.toString();
    }

    public boolean isState() {
        return this.isState;
    }

    public boolean isBC() {
        return !this.isState;
    }

    public boolean isEqn() {
        return this.eqn != null;
    }

    public boolean isTool() {
        return this.tool != null;
    }

    public Tool tool() {
        return this.tool;
    }

    public TEqn eqn() {
        return this.eqn;
    }

    public boolean isLHBC(Var v0) throws Xcept {
        return this.isBC(v0, 2);
    }

    public boolean isRHBC(Var v0) throws Xcept {
        return this.isBC(v0, 3);
    }

    public boolean isBC(Var v0, int stat) throws Xcept {
        for (int i = 0; i < this.vus.size(); ++i) {
            VarUsage vu = this.vus.get(i);
            if (vu.v().zeroDeriv() != v0 || vu.stat() != stat) continue;
            return true;
        }
        return false;
    }

    public void log(String msg) {
        this.model().log(msg);
    }
}

