/*
 * Decompiled with CFR 0.152.
 */
package JSim.plan2;

import JSim.mml.Domain;
import JSim.mml.Var;
import JSim.plan2.AbortXcept;
import JSim.plan2.DECon;
import JSim.plan2.DomainSet;
import JSim.plan2.PDEFactors;
import JSim.plan2.TModel;
import JSim.plan2.TSubDom;
import JSim.plan2.Tool;
import JSim.plan2.ToolBox;
import JSim.plan2.VarUsage;
import JSim.plan2.VarUsages;
import JSim.util.Util;
import JSim.util.Xcept;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.LinkedHashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DETool
extends Tool {
    public Var v;
    public DomainSet txs;
    public DomainSet tcandidates;
    public Domain t;
    public DomainSet xs;
    public Var vtmax;
    public int torder;
    private DECon state;
    private ArrayList<DECon> bcList;
    protected Hashtable<TSubDom, DECon> bcMap;
    private boolean[] hasICs;
    private boolean isComplete;
    private PDEFactors factors;

    public DETool(TModel model, Var v) throws Xcept {
        super(model);
        this.v = v;
        this.torder = -1;
        this.txs = new DomainSet(model.pureChildDerivDoms.get((Object)v));
        this.tcandidates = new DomainSet(model.pureChildDerivDoms.get((Object)v));
        this.bcMap = new Hashtable();
        this.bcList = new ArrayList();
        this.icTools = new LinkedHashSet();
    }

    public void addCon(DECon con) throws Xcept {
        if (con.isState()) {
            if (this.state != null) {
                throw new AbortXcept("Duplicate state eqn for " + (Object)((Object)this.v) + ": " + this.state + " and " + con);
            }
            this.state = con;
        } else {
            this.bcList.add(con);
            this.updateTBC(con);
        }
        this.vreqs.add(con.vreqs());
        this.update();
    }

    private void updateTBC(DECon bc) throws Xcept {
        VarUsages vus = bc.vus();
        for (int i = 0; i < vus.size(); ++i) {
            VarUsage vu = vus.get(i);
            if (this.v != vu.v().zeroDeriv()) continue;
            TSubDom sd = this.model.subdom(vu);
            if (bc.isTool() && sd.isLH()) continue;
            this.tcandidates.remove((Object)sd.domain());
        }
    }

    private void update() throws Xcept {
        VarUsage vu;
        int j;
        VarUsages vus;
        int i;
        if (this.tcandidates.size() == 0) {
            throw new AbortXcept("Can't find time domain for DE: " + (Object)((Object)this.v));
        }
        if (this.tcandidates.size() == 1) {
            this.t = this.tcandidates.first();
        }
        if (this.t != null && this.xs == null) {
            this.xs = new DomainSet(this.txs);
            this.xs.remove((Object)this.t);
        }
        if (this.t != null && this.state != null && this.vtmax == null) {
            this.vtmax = this.state.vus().vtmax(this.v, this.t);
            if (this.vtmax == null || this.vtmax.derivOrder() < 1) {
                throw new Xcept("Calculated vtmax=" + (Object)((Object)this.vtmax) + " for " + (Object)((Object)this.v) + ":" + (Object)((Object)this.t) + " in " + this.state);
            }
            this.torder = this.vtmax.derivOrder();
            this.hasICs = new boolean[this.torder];
        }
        this.bcMap = new Hashtable();
        int sdct = 0;
        for (i = 0; i < this.bcList.size(); ++i) {
            DECon bc = this.bcList.get(i);
            vus = bc.vus();
            for (j = 0; j < vus.size(); ++j) {
                DECon bcold;
                TSubDom sd;
                Domain x;
                vu = vus.get(j);
                if (vu.v().zeroDeriv() != this.v || this.tcandidates.contains((Object)(x = (sd = this.model.subdom(vu)).domain())) || (bcold = this.bcMap.get(sd)) == bc) continue;
                if (bcold != null) {
                    throw new AbortXcept("PDE BC " + (Object)((Object)this.v) + "(" + sd + ") overspecified by " + bc + " and " + this.bcMap.get(sd));
                }
                this.bcMap.put(sd, bc);
                ++sdct;
            }
        }
        if (this.hasICs != null) {
            for (i = 0; i < this.bcList.size(); ++i) {
                Tool tool = this.bcList.get(i).tool();
                if (tool == null) continue;
                vus = tool.vsols;
                for (j = 0; j < vus.size(); ++j) {
                    vu = vus.get(j);
                    Var vt = vu.v();
                    if (vt.zeroDeriv() != this.v || !vu.isMin(this.t) || vt.isDeriv() && this.model.pureDerivDom(vt) != this.t) continue;
                    int tinx = vt.derivOrder();
                    if (tinx >= this.hasICs.length) {
                        throw new Xcept("IC t-order for " + tool + " mismatches state eqn " + this.state);
                    }
                    this.icTools.add(tool);
                    this.hasICs[tinx] = true;
                }
            }
        }
        this.isComplete = this.areICsComplete() && this.areBCsComplete();
        this.vsols = new VarUsages(this.model);
        this.vsolsUpdate(1, null);
        if (this.areICsComplete()) {
            this.vsolsUpdate(3, this.t);
        }
        ArrayList<TSubDom> sds = new ArrayList<TSubDom>(this.bcMap.keySet());
        for (int i2 = 0; i2 < sds.size(); ++i2) {
            TSubDom sd = sds.get(i2);
            Domain x = sd.domain();
            if (this.tcandidates.contains((Object)x)) continue;
            if (sd.isLH()) {
                this.vsols.add(this.v, 2, x);
            }
            if (!sd.isRH()) continue;
            this.vsols.add(this.v, 3, x);
        }
        if (!this.isComplete) {
            return;
        }
        this.vreqs = new VarUsages(this.model);
        this.vreqs.add(this.state.vreqs());
        for (Domain x : this.xs) {
            if (x == this.t) continue;
            DECon lcon = this.bcMap.get(this.model.lhbcs.get((Object)x));
            this.vreqs.add(lcon.vreqs());
            DECon rcon = this.bcMap.get(this.model.rhbcs.get((Object)x));
            this.vreqs.add(rcon.vreqs());
        }
        Var vic = this.v;
        for (int i3 = 0; i3 < this.torder; ++i3) {
            this.vreqs.add(new VarUsage(this.model, vic, 2, this.t));
            vic = vic.deriv(this.t);
        }
        if (!this.isPDE()) {
            this.vreqs.add(this.vtmax);
        }
    }

    private void vsolsUpdate(int stat, Domain x) throws Xcept {
        Var vs = this.v;
        int ct = Math.max(1, this.torder);
        for (int i = 0; i < ct; ++i) {
            VarUsage vsu = new VarUsage(this.model, vs, stat, x);
            if (this.vreqs.contains(vsu)) {
                throw new AbortXcept(this.toString() + " requires self-solved variable " + vsu);
            }
            this.vsols.add(vsu);
            if (i >= ct - 1) continue;
            vs = vs.deriv(this.t);
        }
    }

    private boolean areICsComplete() {
        if (this.hasICs == null) {
            return false;
        }
        for (int i = 0; i < this.hasICs.length; ++i) {
            if (this.hasICs[i]) continue;
            return false;
        }
        return true;
    }

    private boolean areBCsComplete() {
        if (this.xs == null) {
            return false;
        }
        for (Domain x : this.xs) {
            if (this.bcMap.get(this.model.lhbcs.get((Object)x)) == null && this.needsBC(x, true)) {
                return false;
            }
            if (this.bcMap.get(this.model.rhbcs.get((Object)x)) != null || !this.needsBC(x, false)) continue;
            return false;
        }
        return true;
    }

    public boolean needsBC(Domain x, boolean onLeft) {
        return true;
    }

    protected String incompleteMessage() {
        String msg = this.deString() + " " + (Object)((Object)this.v) + ":";
        if (!this.areICsComplete()) {
            msg = msg + " IC(s) incomplete.";
        }
        if (!this.areBCsComplete()) {
            msg = msg + " BCs incomplete.";
        }
        return msg;
    }

    protected void positFirstSpatialDerivs(ToolBox box) throws Xcept {
        if (!this.isPDE()) {
            return;
        }
        VarUsages vus = this.vreqs;
        this.vreqs = new VarUsages(this.model);
        for (int i = 0; i < vus.size(); ++i) {
            VarUsage vu = vus.get(i);
            if (box.isPDEFirstSpatialDeriv(vu)) continue;
            this.vreqs.add(vu);
        }
    }

    @Override
    protected void setSeqLoops() throws Xcept {
        this.seqLoops = this.model.domSets.get((Object)this.v).minus(this.xs);
        this.checkConSeqLoops(this.state);
        for (Domain x : this.xs) {
            TSubDom sd = this.model.lhbcs.get((Object)x);
            this.checkConSeqLoops(this.bcMap.get(sd));
            sd = this.model.rhbcs.get((Object)x);
            this.checkConSeqLoops(this.bcMap.get(sd));
        }
    }

    private void checkConSeqLoops(DECon con) throws Xcept {
        if (con == null) {
            return;
        }
        DomainSet vreqsdoms = con.vreqs().seqLoops();
        DomainSet xdoms = vreqsdoms.minus(this.model.domSets.get((Object)this.v));
        if (xdoms.size() == 0) {
            return;
        }
        this.logger().error("Can't calculate " + this.conString(con) + " due to unspecified domain(s) " + xdoms + ": " + con);
    }

    protected void createFactors() throws Xcept {
        this.factors = PDEFactors.create(this);
    }

    public Var v() {
        return this.v;
    }

    @Override
    public Domain t() {
        return this.t;
    }

    @Override
    protected boolean needsICs() {
        return true;
    }

    @Override
    protected boolean isComplete() {
        return this.isComplete;
    }

    protected LinkedHashSet<Tool> icTools() {
        return this.icTools;
    }

    protected DECon state() {
        return this.state;
    }

    @Override
    public String nodeString() {
        return this.v.toString();
    }

    public boolean isPDE() {
        return this.txs.size() > 1;
    }

    public String deString() {
        return this.isPDE() ? "PDE" : "ODE";
    }

    protected String conString(DECon con) throws Xcept {
        String s;
        if (con.isState()) {
            return this.deString();
        }
        String string = s = con.isLHBC(this.v) ? "LHBC" : "";
        if (con.isRHBC(this.v)) {
            s = Util.isBlank((String)s) ? "RHBC" : "LHBC/RHBC";
        }
        return s;
    }

    public String toString() {
        String s = "";
        s = s + this.deString();
        if (this.xs != null && this.xs.size() > 0) {
            s = s + "-" + this.xs.size() + "D";
        }
        if (this.torder > 1) {
            s = s + "(t^" + this.torder + ")";
        }
        s = s + " " + (Object)((Object)this.v) + ": ";
        if (this.state != null) {
            return s + this.state;
        }
        return s + this.bcList;
    }

    public DECon bc(TSubDom sd) {
        return this.bcMap.get(sd);
    }

    @Override
    public String toolType() {
        return this.deString();
    }

    public PDEFactors factors() {
        return this.factors;
    }
}

