/*
 * Decompiled with CFR 0.152.
 */
package JSim.plan2;

import JSim.mml.Domain;
import JSim.mml.Var;
import JSim.plan2.DETool;
import JSim.plan2.DomainTool;
import JSim.plan2.ExprTool;
import JSim.plan2.ImplicitTool;
import JSim.plan2.Logger;
import JSim.plan2.PDE1Factors;
import JSim.plan2.StateTool;
import JSim.plan2.TExpr;
import JSim.plan2.TModel;
import JSim.plan2.Tool;
import JSim.plan2.ToolBox;
import JSim.plan2.VarUsage;
import JSim.plan2.VarUsages;
import JSim.util.Expr;
import JSim.util.Xcept;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DerivBuilder {
    private ToolBox box;

    public DerivBuilder(ToolBox box) {
        this.box = box;
    }

    protected void makePDEFactorTools(DETool tool) throws Xcept {
        if (!(tool.factors() instanceof PDE1Factors)) {
            return;
        }
        PDE1Factors factors = (PDE1Factors)tool.factors();
        if (factors.solverMsg(2) != null) {
            return;
        }
        Expr coefD = factors.coefD();
        Domain x = tool.xs.first();
        this.log("  checking PDE(" + (Object)((Object)tool.v) + ") D=" + coefD + " for differentiability ...");
        String msg = this.makeDerivTools(coefD, x);
        if (msg != null) {
            this.log("  D=" + coefD + " is not differentiable: " + msg);
            factors.setCoefDx(null);
        } else {
            Expr coefDx = coefD.takeDeriv((Expr)x);
            this.log("  setting Dx=" + coefDx);
            TExpr tcoefDx = new TExpr(this.model(), coefDx);
            VarUsages vus = tcoefDx.usages();
            if (vus.size() > 0) {
                this.log("  adding DETool vreq: " + vus);
                tool.vreqs.add(vus);
                tool.state().vreqs().add(vus);
            }
            factors.setCoefDx(coefDx);
        }
    }

    protected String makeDerivTools(Expr expr, Domain x) throws Xcept {
        LinkedHashSet<Tool> toolset;
        LinkedHashSet<Var> vset;
        TExpr texpr = new TExpr(this.model(), expr);
        VarUsages vus = texpr.usages();
        String msg = this.addDerivTools(vus, x, vset = new LinkedHashSet<Var>(), toolset = new LinkedHashSet<Tool>());
        if (msg != null) {
            return msg;
        }
        Iterator vs = vset.iterator();
        while (vs.hasNext()) {
            Var vx = ((Var)((Object)vs.next())).deriv(x);
            this.log("  adding variable " + (Object)((Object)vx));
        }
        for (Tool tool : toolset) {
            Tool xtool = tool.derivTool(x);
            if (xtool == null) {
                throw new Xcept("Error creating PDEFactor deriv:" + (Object)((Object)x) + " for " + tool);
            }
            this.box.addTool(xtool);
        }
        return null;
    }

    private String addDerivTools(VarUsages vus, Domain x, LinkedHashSet<Var> vset, LinkedHashSet<Tool> toolset) throws Xcept {
        for (int i = 0; i < vus.size(); ++i) {
            boolean ok;
            VarUsage vu = vus.get(i);
            if (!vu.isCurr()) {
                return "Non-current VarUsage " + vu;
            }
            Var v = vu.v();
            if (vset.contains((Object)v) || !v.hasDomain(x)) continue;
            Tool vtool = this.box.mainTools.get((Object)v);
            if (vtool == null) {
                return "No tool for var " + (Object)((Object)v);
            }
            if (vtool instanceof StateTool || vtool instanceof DomainTool) continue;
            boolean bl = ok = vtool instanceof ExprTool || vtool instanceof ImplicitTool;
            if (!ok) {
                return "Can't differentiate " + vtool;
            }
            vset.add(v);
            toolset.add(vtool);
            this.addDerivTools(vtool.vreqs, x, vset, toolset);
        }
        return null;
    }

    public TModel model() {
        return this.box.model;
    }

    public void log(String msg) {
        this.logger().log(msg);
    }

    public Logger logger() {
        return this.box.logger();
    }

    public ArrayList<Tool> tools() {
        return this.box.tools;
    }
}

