/*
 * Decompiled with CFR 0.152.
 */
package JSim.plan2;

import JSim.data.JSReadable;
import JSim.project.PApplication;
import JSim.project.PModel;
import JSim.project.Project;
import JSim.util.UtilIO;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Hashtable;

public class Harvest {
    public File destDir;
    public PrintWriter inxwrt;
    public int ninxs;
    public Hashtable<Integer, String> mmlIDs;
    public PApplication pappl;
    public static String INDEX = "harvest.inx";

    public Harvest(File destDir) throws Exception {
        this.destDir = destDir;
        if (!destDir.exists()) {
            destDir.mkdir();
        }
        if (!destDir.isDirectory()) {
            throw new Exception("Can't create dest dir " + destDir);
        }
        File finx = new File(destDir, INDEX);
        this.inxwrt = new PrintWriter((Writer)new FileWriter(finx), true);
        this.ninxs = 0;
        this.mmlIDs = new Hashtable();
        this.pappl = new PApplication(new String[0]);
    }

    public void harvest(File f) throws Exception {
        String name = f.getName();
        if (name.startsWith(".")) {
            return;
        }
        if (!f.canRead()) {
            System.out.println("Unreadable: " + f);
            return;
        }
        if (f.isDirectory()) {
            this.harvestDir(f);
        } else if (name.endsWith(".mod")) {
            this.harvestMod(f);
        } else if (name.endsWith(".proj")) {
            this.harvestProj(f);
        }
    }

    public void harvestDir(File dir) throws Exception {
        File f = new File(dir, INDEX);
        if (f.exists()) {
            System.out.println("Ignoring harvest dest " + dir);
            return;
        }
        System.out.println("Searching " + dir + " ...");
        File[] fs = dir.listFiles();
        for (int i = 0; i < fs.length; ++i) {
            this.harvest(fs[i]);
        }
    }

    public void harvestMod(File f) throws Exception {
        String mml = UtilIO.readText((File)f);
        this.processMML(f, null, mml);
    }

    public void harvestProj(File f) throws Exception {
        Project proj = new Project("proj", this.pappl);
        JSReadable r = new JSReadable(f);
        try {
            proj.importXML(r);
            for (int i = 0; i < proj.nChild(); ++i) {
                if (!(proj.child(i) instanceof PModel)) continue;
                PModel pmodel = (PModel)proj.child(i);
                String mml = pmodel.modelSource.stringVal();
                this.processMML(f, pmodel.name(), mml);
            }
        }
        catch (Exception e) {
            System.out.println("Ignoring read error " + f);
        }
    }

    public void processMML(File f, String pmodel, String mml) throws Exception {
        Integer hmml;
        String oid;
        String id = f.getPath();
        if (pmodel != null) {
            id = id + "#" + pmodel;
        }
        if ((oid = this.mmlIDs.get(hmml = new Integer((mml = mml.trim() + "\n").hashCode()))) != null) {
            System.out.println("Ignoring " + id + " matches " + oid);
            return;
        }
        this.mmlIDs.put(hmml, id);
        int inx = 1000 + ++this.ninxs;
        String fname = "" + inx + ".mod";
        this.inxwrt.println("" + fname + "\t" + hmml + "\t" + id);
        File fout = new File(this.destDir, fname);
        UtilIO.writeText((File)fout, (String)mml);
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 2) {
            throw new Exception("Usage: harvest destDir [ srcDir ... ]");
        }
        Harvest h = new Harvest(new File(args[0]));
        for (int i = 1; i < args.length; ++i) {
            h.harvest(new File(args[i]));
        }
    }
}

