/*
 * Decompiled with CFR 0.152.
 */
package JSim.plan2;

import JSim.mml.Domain;
import JSim.mml.Var;
import JSim.mml.VarFuncCall;
import JSim.plan2.DomainSet;
import JSim.plan2.ImplicitTool;
import JSim.plan2.SeqItem;
import JSim.plan2.TExpr;
import JSim.plan2.TModel;
import JSim.plan2.TRelation;
import JSim.plan2.TSubDom;
import JSim.plan2.VarUsage;
import JSim.plan2.VarUsages;
import JSim.util.Expr;
import JSim.util.RealBExpr;
import JSim.util.RealConst;
import JSim.util.Xcept;

public class ImplicitBound
implements SeqItem {
    protected TRelation relation;
    protected VarUsage vu;
    protected int type;
    protected TExpr expr;
    private DomainSet seqLoops;
    private ImplicitTool tool;
    private VarUsages vreqs;
    public static final int MIN = -1;
    public static final int APPROX = 0;
    public static final int MAX = 1;

    public ImplicitBound(TRelation r, VarUsage vu, int type, TExpr expr) {
        this.relation = r;
        this.vu = vu;
        this.type = type;
        this.expr = expr;
        this.seqLoops = r.seqLoops();
    }

    public ImplicitBound restrict(TSubDom sd) throws Xcept {
        if (sd.isEntire()) {
            return this;
        }
        ImplicitBound bound = new ImplicitBound(this.relation, new VarUsage(sd, this.vu.v()), this.type, this.expr.restrict(sd));
        bound.seqLoops.remove((Object)sd.domain());
        return bound;
    }

    public static ImplicitBound create(TRelation r, VarUsages vus) throws Xcept {
        TExpr lhs = r.lhs();
        TExpr rhs = r.rhs();
        VuFactor vuf = ImplicitBound.vuFactor(lhs);
        TExpr expr = rhs;
        int typ = ImplicitBound.boundType(r.op());
        if (!ImplicitBound.isBound(vuf, vus)) {
            vuf = ImplicitBound.vuFactor(rhs);
            expr = lhs;
            typ *= -1;
        }
        if (!ImplicitBound.isBound(vuf, vus)) {
            return null;
        }
        if (vuf.k != null) {
            expr = expr.div((Expr)vuf.k);
        }
        ImplicitBound bound = new ImplicitBound(r, vuf.vu, typ, expr);
        VarUsage vub = vus.firstForVar(vuf.vu.v());
        TSubDom subdom = vub.model().subdom(vub);
        return bound.restrict(subdom);
    }

    private static boolean isBound(VuFactor vuf, VarUsages vus) throws Xcept {
        if (vuf == null) {
            return false;
        }
        VarUsage vu = vuf.vu;
        if (vus.contains(vu)) {
            return true;
        }
        if (!vu.isCurr()) {
            return false;
        }
        return vus.hasVar(vu.v());
    }

    private static VuFactor vuFactor(TExpr texpr) throws Xcept {
        Expr expr = texpr.expr();
        if (expr instanceof Var || expr instanceof VarFuncCall) {
            VarUsage vu = texpr.soleVU();
            if (vu == null || !vu.isSolvable()) {
                return null;
            }
            return new VuFactor(vu, null);
        }
        if (!(expr instanceof RealBExpr)) {
            return null;
        }
        RealBExpr bexpr = (RealBExpr)expr;
        if (bexpr.op() != 37) {
            return null;
        }
        if (!(bexpr.arg(1) instanceof RealConst)) {
            return null;
        }
        TExpr vexpr = new TExpr(texpr.model(), bexpr.arg(0));
        VarUsage vu = (vexpr = vexpr.restrict(texpr.subdom())).soleVU();
        if (vu == null || !vu.isSolvable()) {
            return null;
        }
        return new VuFactor(vu, (RealConst)bexpr.arg(1));
    }

    private static int boundType(int op) throws Xcept {
        boolean which = false;
        switch (op) {
            case 50: 
            case 51: {
                return 1;
            }
            case 52: 
            case 53: {
                return -1;
            }
            case 54: {
                return 0;
            }
        }
        throw new Xcept("Unknown relation op=" + op);
    }

    protected boolean setTool(ImplicitTool tool) throws Xcept {
        this.vreqs = new VarUsages(this.model());
        for (int i = 0; i < this.relation.vreqs().size(); ++i) {
            VarUsage vreq = this.relation.vreqs().get(i);
            if (((Object)((Object)vreq.v())).equals((Object)this.vu.v())) continue;
            if (tool.vsols.contains(vreq)) {
                return false;
            }
            this.vreqs.add(vreq);
        }
        this.tool = tool;
        return true;
    }

    public TModel model() {
        return this.relation.model;
    }

    public TRelation relation() {
        return this.relation;
    }

    public ImplicitTool tool() {
        return this.tool;
    }

    public Domain t() {
        return this.relation.t();
    }

    public VarUsages vreqs() {
        return this.vreqs;
    }

    public DomainSet seqLoops() {
        return this.seqLoops;
    }

    public String nodeString() {
        return this.toString();
    }

    public String toString() {
        String sop = "?";
        switch (this.type) {
            case -1: {
                sop = ">=";
                break;
            }
            case 0: {
                sop = "~=";
                break;
            }
            case 1: {
                sop = "<=";
            }
        }
        return "bound " + this.vu + " " + sop + " " + this.expr;
    }

    public TExpr expr() {
        return this.expr;
    }

    public static final class VuFactor {
        public VarUsage vu;
        public RealConst k;

        public VuFactor(VarUsage vu, RealConst k) {
            this.vu = vu;
            this.k = k;
        }

        public String toString() {
            return "" + this.vu + "," + this.k;
        }
    }
}

