/*
 * Decompiled with CFR 0.152.
 */
package JSim.plan2;

import JSim.plan2.ImplicitTool;
import JSim.plan2.TEqn;
import JSim.plan2.TExpr;
import JSim.plan2.TModel;
import JSim.plan2.TSubDom;
import JSim.plan2.ToolBox;
import JSim.plan2.VarUsage;
import JSim.plan2.VarUsages;
import JSim.util.Util;
import JSim.util.Xcept;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.LinkedHashSet;

public class ImplicitPool {
    private ToolBox box;
    private TModel model;
    private int maxBlock;
    private double maxSearch;
    private VarUsage[] gvus;
    private Hashtable<VarUsage, Integer> gvumap;
    private PoolEqn[] peqns;
    private int pm;
    private int pn;
    private PoolEqn[] pblock;
    private int[] pblockVuxs;

    public ImplicitPool(ToolBox box) {
        this.box = box;
        this.model = box.model;
        this.maxBlock = box.plan.maxImplicitBlock();
        this.maxSearch = box.plan.maxImplicitSearch();
    }

    public ImplicitTool makeTool(TSubDom sd) throws Xcept {
        int i;
        ArrayList<PoolEqn> plist = new ArrayList<PoolEqn>();
        LinkedHashSet<VarUsage> vuset = new LinkedHashSet<VarUsage>();
        for (i = 0; i < this.model.eqns.size(); ++i) {
            TEqn eqn = this.model.eqns.get(i);
            if (this.box.isUsed(eqn, sd)) continue;
            VarUsages vus = eqn.usages();
            if (!sd.isEntire()) {
                vus = vus.restrict(sd);
            }
            if ((vus = this.box.unknown(vus, this.maxBlock + 1)).size() > this.maxBlock) continue;
            if (vus.size() < 2) {
                throw new Xcept("ImplicitPool not cleaned: " + eqn);
            }
            if (!vus.areSolvable()) continue;
            PoolEqn peqn = new PoolEqn(eqn, vus);
            for (int j = 0; j < vus.size(); ++j) {
                vuset.add(vus.get(j));
            }
            plist.add(peqn);
        }
        Collections.sort(plist);
        this.peqns = plist.toArray(new PoolEqn[0]);
        this.gvus = vuset.toArray(new VarUsage[0]);
        this.gvumap = new Hashtable();
        for (i = 0; i < this.gvus.length; ++i) {
            this.gvumap.put(this.gvus[i], new Integer(i));
        }
        for (i = 0; i < this.peqns.length; ++i) {
            this.peqns[i].loadVuxs();
        }
        ImplicitTool tool = null;
        long t = System.currentTimeMillis();
        for (int m = 2; m <= this.maxBlock; ++m) {
            this.createBlock(m);
            if (this.pblock == null) continue;
            double ct = ImplicitPool.pascal(this.pn, this.pm);
            String msg = "  implicit block (" + this.pn + " " + this.pm + ")=" + ct;
            if (ct > this.maxSearch) {
                msg = msg + " exceeds maxSearch=" + this.maxSearch;
            }
            this.log(msg);
            if (ct > this.maxSearch) {
                return null;
            }
            tool = this.buildBlockLoop(0, 0);
            if (tool != null) break;
        }
        t = System.currentTimeMillis() - t;
        return tool;
    }

    public void createBlock(int m) throws Xcept {
        int n;
        this.pblock = null;
        for (n = 0; n < this.peqns.length && this.peqns[n].nvus <= m; ++n) {
        }
        if (n < m) {
            return;
        }
        this.pblock = new PoolEqn[m];
        this.pblockVuxs = new int[m + 1];
        this.pn = n;
        this.pm = m;
    }

    private ImplicitTool buildBlockLoop(int mx, int nlo) throws Xcept {
        int nhi = this.pn - this.pm + mx + 1;
        for (int nx = nlo; nx < nhi; ++nx) {
            this.pblock[mx] = this.peqns[nx];
            if (mx < this.pm - 1) {
                ImplicitTool tool = this.buildBlockLoop(mx + 1, nx + 1);
                if (tool == null) continue;
                return tool;
            }
            if (!this.testBlock()) continue;
            return this.makeTool();
        }
        return null;
    }

    private boolean testBlock() {
        int ct = 0;
        for (int i = 0; i < this.pblock.length; ++i) {
            PoolEqn peqn = this.pblock[i];
            for (int j = 0; j < peqn.nvus; ++j) {
                int k = peqn.vuxs[j];
                boolean add = true;
                for (int l = 0; l < ct; ++l) {
                    if (this.pblockVuxs[l] != k) continue;
                    add = false;
                    break;
                }
                if (!add) continue;
                this.pblockVuxs[ct++] = k;
                if (ct <= this.pm) continue;
                return false;
            }
        }
        return true;
    }

    private ImplicitTool makeTool() throws Xcept {
        VarUsages vus = new VarUsages(this.model);
        ArrayList<TExpr> exprs = new ArrayList<TExpr>();
        for (int i = 0; i < this.pblock.length; ++i) {
            PoolEqn peqn = this.pblock[i];
            vus.add(peqn.vus);
            exprs.add(peqn.eqn.expr());
        }
        ImplicitTool tool = new ImplicitTool(vus, exprs);
        for (int i = 0; i < this.pblock.length; ++i) {
            tool.eqns.add(this.pblock[i].eqn);
        }
        return tool;
    }

    public void log(String s) {
        this.box.log(s);
    }

    private static double pascal(int n, int m) {
        if (m > n) {
            m = n;
        }
        double s = 1.0;
        for (int i = 0; i < m; ++i) {
            s = s * (double)(n - i) / (double)(i + 1);
        }
        return s;
    }

    public static void main(String[] args) throws Exception {
        int n = Util.toInt((String)args[0]);
        for (int m = 0; m <= n; ++m) {
            double s = ImplicitPool.pascal(n, m);
            System.out.print("  " + s);
        }
        System.out.println();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class PoolEqn
    implements Comparable<PoolEqn> {
        public TEqn eqn;
        public VarUsages vus;
        public int nvus;
        public int[] vuxs;

        public PoolEqn(TEqn eqn, VarUsages vus) {
            this.eqn = eqn;
            this.vus = vus;
            this.nvus = vus.size();
        }

        public void loadVuxs() throws Xcept {
            this.vuxs = new int[this.nvus];
            for (int i = 0; i < this.nvus; ++i) {
                VarUsage vu = this.vus.get(i);
                Integer inx = (Integer)ImplicitPool.this.gvumap.get(vu);
                if (inx == null) {
                    throw new Xcept("ImplicitPool: gvumap missing " + vu);
                }
                this.vuxs[i] = inx;
            }
        }

        @Override
        public int compareTo(PoolEqn peqn) {
            return this.nvus - peqn.nvus;
        }
    }
}

