/*
 * Decompiled with CFR 0.152.
 */
package JSim.plan2;

import JSim.mml.Domain;
import JSim.plan2.ExprTool;
import JSim.plan2.ImplicitBound;
import JSim.plan2.TExpr;
import JSim.plan2.Tool;
import JSim.plan2.VarUsage;
import JSim.plan2.VarUsages;
import JSim.util.Xcept;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImplicitTool
extends Tool {
    public ArrayList<TExpr> exprs;
    private ArrayList<ImplicitBound> bounds;
    private TExpr[][] linmat;
    private VarUsages vnonlin;

    public ImplicitTool(VarUsages vus, ArrayList<TExpr> exprs) throws Xcept {
        super(vus.model());
        this.exprs = exprs;
        this.vsols.add(vus);
        for (int i = 0; i < exprs.size(); ++i) {
            this.vreqs.add(exprs.get(i).usages());
        }
        this.vreqs = this.vreqs.minus(this.vsols);
        if (vus.size() != exprs.size()) {
            throw new Xcept("ImplicitTool: internal size mismatch");
        }
        this.bounds = new ArrayList();
        this.buildLinear();
    }

    public ImplicitTool(VarUsage vu, TExpr expr) throws Xcept {
        this(new VarUsages(vu), expr.arrayList());
    }

    @Override
    protected Tool derivTool(Domain x) throws Xcept {
        VarUsages vuxs = new VarUsages(this.model);
        for (int i = 0; i < this.vsols.size(); ++i) {
            VarUsage vux = this.vsols.get(i).deriv(x);
            if (vux == null) {
                return null;
            }
            vuxs.add(vux);
        }
        ArrayList<TExpr> xexprs = new ArrayList<TExpr>();
        for (int i = 0; i < this.exprs.size(); ++i) {
            xexprs.add(this.exprs.get(i).deriv(x));
        }
        if (xexprs.size() == 1) {
            VarUsage vux = vuxs.get(0);
            TExpr xexpr = xexprs.get(0).solveFor(vux.v());
            if (xexpr != null) {
                return new ExprTool(vux, xexpr);
            }
        }
        return new ImplicitTool(vuxs, xexprs);
    }

    public void buildLinear() throws Xcept {
        int j;
        int i;
        int n = this.vsols.size();
        this.linmat = new TExpr[n][n + 1];
        VarUsages vrems = new VarUsages(this.model);
        for (i = 0; i < n; ++i) {
            TExpr e1 = this.exprs.get(i).zeroExpr();
            for (j = 0; j < n; ++j) {
                VarUsage vu = this.vsols.get(j);
                TExpr e2 = e1.linearFactor(vu, true);
                e1 = e1.linearFactor(vu, false);
                this.linmat[i][j] = e2;
                vrems.add(e2.usages());
            }
            this.linmat[i][n] = e1;
            vrems.add(e1.usages());
        }
        this.vnonlin = this.vsols.xsect(vrems);
        if (this.vnonlin.size() > 0) {
            this.log("  Implicit tool non-linear in " + this.vnonlin);
            return;
        }
        this.log("  Implicit tool " + this.vsols + " is linear");
        for (i = 0; i < n; ++i) {
            String s = "";
            for (j = 0; j <= n; ++j) {
                s = s + "\t" + this.linmat[i][j];
            }
            this.log(s);
        }
    }

    protected void addBound(ImplicitBound bound) {
        this.bounds.add(bound);
    }

    public ArrayList<TExpr> exprs() {
        return this.exprs;
    }

    public String toString() {
        String s = this.exprs.toString();
        if (this.bounds.size() > 0) {
            s = s + " with " + this.bounds.size() + " bounds";
        }
        return s;
    }

    @Override
    public String toolType() {
        return "implicit";
    }

    public boolean isLinear() {
        return this.vnonlin != null && this.vnonlin.size() == 0;
    }

    public TExpr linmat(int i, int j) {
        return this.linmat[i][j];
    }

    public ImplicitBound getBound(VarUsage vu, int type) {
        for (int i = 0; i < this.bounds.size(); ++i) {
            ImplicitBound b = this.bounds.get(i);
            if (!b.vu.equals(vu) || b.type != type) continue;
            return b;
        }
        return null;
    }
}

