/*
 * Decompiled with CFR 0.152.
 */
package JSim.plan2;

import JSim.plan2.AbortXcept;
import JSim.plan2.SeqGraph;
import JSim.util.StringList;
import JSim.util.Xcept;
import java.util.ArrayList;

public class Logger {
    public StringList msgs = new StringList();
    public StringList alerts = new StringList();
    public StringList errors = new StringList();
    protected ArrayList<SeqGraph> graphs;
    private int nwarnings;
    public static final int DEBUG = 0;
    public static final int WARN = 1;
    public static final int ERROR = 2;
    private boolean silent;
    private int timeout;
    private long maxTime;
    private String vtags;

    public void setTimeout(int secs) {
        this.timeout = secs;
        this.maxTime = System.currentTimeMillis() + (long)secs * 1000L;
    }

    protected void checkTimeout() throws Xcept {
        if (this.maxTime == 0L || System.currentTimeMillis() < this.maxTime) {
            return;
        }
        throw new Xcept("Compiler timed out at " + this.timeout + " sec");
    }

    protected void setSilent(boolean b) {
        this.silent = b;
    }

    protected void setSaveGraphs(boolean b) {
        this.graphs = b ? new ArrayList() : null;
    }

    public void setVerbose(String vtags) {
        this.vtags = vtags;
    }

    public boolean isVerbose() {
        return this.vtags != null && this.vtags.length() == 0;
    }

    public boolean isVerbose(String s) {
        if (this.isVerbose()) {
            return true;
        }
        return this.vtags != null && this.vtags.indexOf(s) >= 0;
    }

    public void log(String msg) {
        this.log(0, msg);
    }

    public void warn(String msg) {
        this.log(1, msg);
    }

    public void error(String msg) {
        this.log(2, msg);
    }

    public void log(String tag, String msg) {
        if (this.silent) {
            return;
        }
        if (!this.isVerbose(tag)) {
            return;
        }
        System.out.println(msg);
    }

    public void log(Exception e) {
        String msg = e.getMessage();
        if (!(e instanceof AbortXcept)) {
            msg = " (internal?) " + msg;
            if (!this.silent) {
                e.printStackTrace();
            }
        }
        this.error(msg);
    }

    public void log(int code, String msg) {
        switch (code) {
            case 2: {
                this.errors.add((Object)msg);
                msg = "ERROR: " + msg;
                break;
            }
            case 1: {
                ++this.nwarnings;
                msg = "WARNING: " + msg;
            }
        }
        this.msgs.add((Object)msg);
        if (code != 0) {
            this.alerts.add((Object)msg);
        }
        if (!this.silent && (this.isVerbose() || code != 0)) {
            System.out.println(msg);
        }
    }

    protected void saveGraph(String name, SeqGraph graph) throws Xcept {
        if (this.graphs == null) {
            return;
        }
        this.log("Saving graph " + name);
        graph = new SeqGraph(graph);
        graph.setName(name);
        this.graphs.add(graph);
    }

    public int nwarnings() {
        return this.nwarnings;
    }

    public int nerrors() {
        return this.errors.size();
    }
}

