/*
 * Decompiled with CFR 0.152.
 */
package JSim.plan2;

import JSim.mml.Domain;
import JSim.mml.Var;
import JSim.plan2.AbortXcept;
import JSim.plan2.DETool;
import JSim.plan2.DomainSet;
import JSim.plan2.ImplicitBound;
import JSim.plan2.ImplicitTool;
import JSim.plan2.Logger;
import JSim.plan2.MainGraph;
import JSim.plan2.MuBlock;
import JSim.plan2.ODEBlock;
import JSim.plan2.PDEBlock;
import JSim.plan2.Plan;
import JSim.plan2.QueryTool;
import JSim.plan2.ReuseTool;
import JSim.plan2.SeqBlock;
import JSim.plan2.SeqEdge;
import JSim.plan2.SeqGraph;
import JSim.plan2.SeqGraphCirc;
import JSim.plan2.SeqIO;
import JSim.plan2.SeqItem;
import JSim.plan2.SeqNode;
import JSim.plan2.SeqPath;
import JSim.plan2.SeqPhase;
import JSim.plan2.SeqUntangler;
import JSim.plan2.SeqUntangler2;
import JSim.plan2.SeqUntangler3;
import JSim.plan2.StateTool;
import JSim.plan2.TEvent;
import JSim.plan2.TModel;
import JSim.plan2.TRelation;
import JSim.plan2.Tool;
import JSim.plan2.ToolBox;
import JSim.plan2.VarUsage;
import JSim.plan2.VarUsages;
import JSim.util.Xcept;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MainBlock
extends SeqBlock {
    public ToolBox box;
    public Plan plan;
    public TModel model;
    protected ArrayList<Tool> tools;
    protected ArrayList<TEvent> events;
    protected ArrayList<TRelation> relations;
    protected Hashtable<VarUsage, Tool> vuTools;
    protected ArrayList<ImplicitBound> implicitBounds;
    protected LinkedHashSet<SeqItem> retryItems;
    private MainGraph igraph;
    private Hashtable<SeqNode, SeqItem> nodeItems;
    private SeqGraphCirc cgraph;
    private SeqGraph ugraph;
    private SeqGraph wgraph;
    private LinkedHashSet<SeqPhase> wphases;
    private Hashtable<SeqPhase, LinkedHashSet<SeqNode>> phaseDeTNodes;
    private ArrayList<MuBlock> deblocks;

    public MainBlock(ToolBox box) throws Xcept {
        super(box.plan.model());
        this.box = box;
        this.plan = box.plan;
        this.model = this.plan.model();
        this.tools = new ArrayList<Tool>(box.seqTools());
        this.events = this.model.events;
        this.relations = this.model.relations;
    }

    protected void build() throws Xcept {
        int i;
        this.log("\nSequencing phase starting ...");
        for (i = 0; i < this.tools.size(); ++i) {
            this.tools.get(i).setSeqLoops();
        }
        if (this.logger().nerrors() > 0) {
            return;
        }
        this.logItems();
        this.log("Creating vuTools map ...");
        this.buildVuTools();
        this.buildImplicitBounds();
        this.checkEventToolCompatibility();
        this.retryItems = new LinkedHashSet();
        while (!this.createGraph()) {
        }
        this.mergeImplicitBounds();
        this.removeImplicitBoundNodes(this.ugraph);
        this.log("Building mainline block ...");
        this.deblocks = new ArrayList();
        this.wgraph = new SeqGraph(this.ugraph);
        this.log("Mainline block graph:");
        this.wphases = new LinkedHashSet();
        this.phaseDeTNodes = new Hashtable();
        this.buildPhaseBlock(this, this.wgraph.mainPhase());
        for (i = 0; i < this.deblocks.size(); ++i) {
            MuBlock block = this.deblocks.get(i);
            block.build();
        }
        if (this.logger().isVerbose("b")) {
            this.dump(System.out);
        }
    }

    private void buildVuTools() throws Xcept {
        this.vuTools = new Hashtable();
        for (int i = 0; i < this.tools.size(); ++i) {
            this.updateVuTools(this.tools.get(i));
        }
        this.log("Adding reuse & query tools ...");
        while (this.buildReuseTools()) {
        }
        this.buildQueryTools();
    }

    private boolean buildReuseTools() throws Xcept {
        boolean working = false;
        ArrayList<VarUsage> vus = new ArrayList<VarUsage>(this.model.vus);
        for (int i = 0; i < vus.size(); ++i) {
            VarUsage vmu = vus.get(i);
            if (this.vuTools.get(vmu) != null || this.isUnsolvedPDEDeriv(vmu) || vmu.stat() != 2) continue;
            VarUsage vu = new VarUsage(this.model, vmu.v());
            Tool vtool = this.vuTools.get(vu);
            if (vtool == null) {
                throw new Xcept("MainBlock: No tool for " + vu);
            }
            Domain x = vmu.domain();
            if (!vtool.seqLoops().contains((Object)x) || vtool instanceof DETool) continue;
            ReuseTool rtool = new ReuseTool(vtool, x);
            this.tools.add(rtool);
            this.log("  adding reuse tool: " + rtool + " " + rtool.vsols + "<<" + rtool.vreqs);
            this.updateVuTools(rtool);
            working = true;
        }
        return working;
    }

    private void buildQueryTools() throws Xcept {
        for (VarUsage vu : this.model.vus) {
            VarUsage vu0;
            Tool tool;
            if (this.vuTools.get(vu) != null || this.isUnsolvedPDEDeriv(vu)) continue;
            if (vu.isCurr()) {
                throw new Xcept("MainBlock: No tool for " + vu);
            }
            if (vu.isBoundary() && !vu.isSolvable() && (tool = this.vuTools.get(vu0 = new VarUsage(this.model, vu.v(), vu.stat(), vu.domain()))) != null) {
                System.err.println("ignoring query tool for " + vu);
                this.vuTools.put(vu, tool);
                continue;
            }
            QueryTool qtool = this.makeQueryTool(vu);
            this.log("  adding query tool: " + qtool + "<<" + qtool.vreqs());
            this.tools.add(qtool);
            this.updateVuTools(qtool);
        }
    }

    private QueryTool makeQueryTool(VarUsage vu) throws Xcept {
        DETool detool;
        Domain t;
        Var v = vu.v();
        if (this.box.mainTools.get((Object)v) instanceof DETool && vu.qstat(t = (detool = (DETool)this.box.mainTools.get((Object)v)).t()) == 2) {
            VarUsage vreq = new VarUsage(this.model, v, 2, t);
            return new QueryTool(vu, vreq);
        }
        return new QueryTool(vu);
    }

    private void updateVuTools(Tool tool) throws Xcept {
        for (int j = 0; j < tool.vsols.size(); ++j) {
            VarUsage vu = tool.vsols.get(j);
            this.vuTools.put(vu, tool);
        }
    }

    private boolean isUnsolvedPDEDeriv(VarUsage vu) throws Xcept {
        Var v = vu.v();
        if (!v.isDeriv()) {
            return false;
        }
        VarUsage v0u = new VarUsage(this.model, v.zeroDeriv());
        Tool tool = this.vuTools.get(v0u);
        if (!(tool instanceof DETool)) {
            return false;
        }
        DETool detool = (DETool)tool;
        return detool.xs.size() > 0;
    }

    private void checkEventToolCompatibility() throws Xcept {
        for (int i = 0; i < this.events.size(); ++i) {
            TEvent event = this.events.get(i);
            for (int j = 0; j < event.vacts.size(); ++j) {
                Tool tool;
                VarUsage vu = event.vacts.get(j);
                if (!vu.isCurr() || (tool = this.vuTools.get(vu)) == null || tool instanceof StateTool || tool instanceof DETool) continue;
                throw new AbortXcept("" + vu + ": Events incompatible with " + tool);
            }
        }
    }

    private void buildImplicitBounds() throws Xcept {
        int i;
        VarUsages implicitVus = new VarUsages(this.model);
        ArrayList<VarUsage> vus = new ArrayList<VarUsage>(this.model.vus);
        for (i = 0; i < vus.size(); ++i) {
            VarUsage vu = vus.get(i);
            if (!(this.vuTools.get(vu) instanceof ImplicitTool)) continue;
            implicitVus.add(vu);
        }
        this.implicitBounds = new ArrayList();
        for (i = 0; i < this.relations.size(); ++i) {
            Tool tool;
            TRelation r = this.relations.get(i);
            ImplicitBound bound = ImplicitBound.create(r, implicitVus);
            if (bound == null || !(tool = this.vuTools.get(bound.vu)).seqLoops().equals(r.seqLoops()) || !bound.setTool((ImplicitTool)tool)) continue;
            this.implicitBounds.add(bound);
            this.logger().log("i", "Implicit Bound: " + bound + " from " + r);
        }
    }

    private void mergeImplicitBounds() throws Xcept {
        for (int i = 0; i < this.implicitBounds.size(); ++i) {
            ImplicitBound b = this.implicitBounds.get(i);
            if (this.retryItems.contains(b)) continue;
            b.tool().addBound(b);
        }
    }

    private void removeImplicitBoundNodes(SeqGraph graph) throws Xcept {
        for (int i = 0; i < this.implicitBounds.size(); ++i) {
            ImplicitBound b = this.implicitBounds.get(i);
            if (this.retryItems.contains(b)) continue;
            String bname = b.nodeString();
            SeqNode bnode = graph.getNode(bname);
            graph.remove(bnode);
        }
    }

    private boolean createGraph() throws Xcept {
        this.log("Creating MainGraph ...");
        this.igraph = new MainGraph(this);
        this.nodeItems = this.igraph.nodeItems();
        int u = this.plan.untanglerVersion();
        switch (u) {
            case 1: {
                return this.untangle(this.igraph);
            }
            case 2: {
                return this.untangle2(this.igraph);
            }
            case 3: {
                return this.untangle3(this.igraph);
            }
        }
        throw new Xcept("Illegal untangler version");
    }

    private boolean untangle(MainGraph graph) throws Xcept {
        this.log("Searching for circular dependencies ...");
        this.cgraph = new SeqGraphCirc(graph);
        this.cgraph.removeFeedFwdNodes();
        this.cgraph.minimize();
        SeqPath cpath = this.cgraph.anyCircPath();
        if (cpath != null) {
            return !this.circPathRetry(this.cgraph, cpath);
        }
        this.log("Untangling ...");
        SeqUntangler u = new SeqUntangler(graph, this.logger());
        this.ugraph = u;
        u.setMaxPulls(this.plan.seqMaxPulls());
        u.untangle();
        cpath = u.circPath();
        if (cpath != null) {
            return !this.circPathRetry(u, cpath);
        }
        this.logger().log("p", "Untangling completed with " + u.npulls() + " pulls");
        return true;
    }

    private boolean untangle2(SeqGraph graph) throws Xcept {
        SeqUntangler2 u2 = new SeqUntangler2(graph, this.logger());
        this.ugraph = u2;
        u2.setMaxPulls(this.plan.seqMaxPulls());
        u2.untangle();
        SeqPath cpath = u2.getCircPath();
        if (cpath != null) {
            return !this.circPathRetry(u2, cpath);
        }
        this.logger().log("p", "Untangling completed with " + u2.npulls() + " pulls");
        return true;
    }

    private boolean untangle3(SeqGraph graph) throws Xcept {
        SeqUntangler3 u3 = new SeqUntangler3(graph, this.plan);
        this.ugraph = u3;
        u3.setMaxPulls(this.plan.seqMaxPulls());
        u3.untangle();
        SeqPath cpath = u3.getCircPath();
        if (cpath != null) {
            return !this.circPathRetry(u3, cpath);
        }
        this.logger().log("p", "Untangling completed with " + u3.npulls() + " pulls");
        return true;
    }

    private boolean circPathRetry(SeqGraph graph, SeqPath cpath) throws Xcept {
        boolean retry = false;
        Iterator<SeqNode> cnodes = cpath.getNodes();
        while (cnodes.hasNext()) {
            SeqNode cnode = cnodes.next();
            SeqItem item = this.nodeItems.get(cnode);
            if (this.retryItems.contains(item)) continue;
            if (item instanceof QueryTool) {
                QueryTool qtool = (QueryTool)item;
                if (!qtool.hasXexpr()) continue;
                this.retryItems.add(item);
                this.logger().warn("Positing delay: " + item);
                retry = true;
                continue;
            }
            if (item instanceof ImplicitBound) {
                this.logger().warn("Implicit bound ignored: " + item);
                this.retryItems.add(item);
                retry = true;
                continue;
            }
            if (!(item instanceof TEvent)) continue;
            this.logger().warn("Strict sequencing disabled for: " + item);
            this.retryItems.add(item);
            retry = true;
        }
        if (retry) {
            this.logger().saveGraph("circretry", this.ugraph);
            return true;
        }
        this.logCircPath(graph, cpath);
        throw new AbortXcept("Circular variable dependency: " + cpath);
    }

    private void logCircPath(SeqGraph graph, SeqPath path) throws Xcept {
        this.log("Circular path: " + path);
        for (int i = 0; i < path.nedges(); ++i) {
            SeqNode node = path.edge(i).dest();
            SeqPhase phase = graph.getPhase(node);
            SeqItem item = this.nodeItems.get(node);
            this.log("\t" + node.name() + "\t@" + phase + "\t" + item);
        }
    }

    private void buildPhaseBlock(SeqBlock block, SeqPhase phase) throws Xcept {
        this.log("building block for phase " + phase);
        this.storeDeTNodes(phase, phase.x());
        while (true) {
            int lsize = block.size();
            this.buildBlockNodes(block, phase);
            if (block.size() > lsize) continue;
            for (int i = 0; i < phase.subphases.size(); ++i) {
                SeqPhase xphase = phase.subphases.get(i);
                if (this.wphases.contains(xphase)) continue;
                SeqEdge edge = this.entryEdge(xphase, xphase);
                this.log("  subphase " + xphase + " entryEdge=" + edge);
                if (edge != null) continue;
                Domain x = this.model.domain(xphase.x());
                SeqBlock.Loop xblock = new SeqBlock.Loop(block, x);
                block.add(xblock);
                this.buildPhaseBlock(xblock, xphase);
            }
            if (block.size() == lsize) break;
        }
        LinkedHashSet<SeqNode> deTNodes = this.phaseDeTNodes.get(phase);
        this.addDeTNodes(block, deTNodes);
        ArrayList<SeqNode> wnodes = this.wgraph.getPhaseNodeArray(phase);
        if (wnodes.size() > 0) {
            throw new Xcept("Phase " + phase + " block incomplete, missing " + wnodes);
        }
        for (int i = 0; i < phase.subphases.size(); ++i) {
            SeqPhase sphase = phase.subphases.get(i);
            if (this.wphases.contains(sphase)) continue;
            throw new Xcept("Phase " + phase + " block incomplete, missing phase " + sphase);
        }
        this.wphases.add(phase);
    }

    private void storeDeTNodes(SeqPhase phase, String x) throws Xcept {
        if (x == null) {
            return;
        }
        LinkedHashSet<SeqNode> deTs = new LinkedHashSet<SeqNode>();
        ArrayList<SeqNode> nodes = this.wgraph.getPhaseNodeArray(phase);
        for (int i = 0; i < nodes.size(); ++i) {
            SeqNode node = nodes.get(i);
            if (node.deT() == null || !node.deT().equals(x) || !(this.nodeItems.get(node) instanceof DETool)) continue;
            deTs.add(node);
            this.wgraph.remove(node);
        }
        LinkedHashSet<SeqNode> pdeTs = this.phaseDeTNodes.get(phase);
        if (pdeTs == null) {
            this.phaseDeTNodes.put(phase, deTs);
        } else {
            pdeTs.addAll(deTs);
        }
        for (int i = 0; i < phase.subphases.size(); ++i) {
            this.storeDeTNodes(phase.subphases.get(i), x);
        }
    }

    private void buildBlockNodes(SeqBlock block, SeqPhase phase) throws Xcept {
        ArrayList<SeqNode> nodes = this.wgraph.getPhaseNodeArray(phase);
        for (int i = 0; i < nodes.size(); ++i) {
            SeqNode node = nodes.get(i);
            if (this.wgraph.nedgesTo(node) > 0) continue;
            SeqItem item = this.nodeItems.get(node);
            block.add(item);
            this.wgraph.remove(node);
        }
    }

    private SeqEdge entryEdge(SeqPhase tphase, SeqPhase phase) {
        Iterator<SeqNode> nodes = this.wgraph.getPhaseNodes(phase);
        while (nodes.hasNext()) {
            SeqNode node = nodes.next();
            Iterator<SeqEdge> edges = this.wgraph.getEdgesTo(node);
            while (edges.hasNext()) {
                SeqEdge edge = edges.next();
                SeqNode src = edge.src();
                SeqPhase sphase = this.wgraph.getPhase(src);
                if (tphase.contains(sphase)) continue;
                return edge;
            }
        }
        for (int i = 0; i < phase.subphases.size(); ++i) {
            SeqEdge edge = this.entryEdge(tphase, phase.subphases.get(i));
            if (edge == null) continue;
            return edge;
        }
        return null;
    }

    private void addDeTNodes(SeqBlock block, LinkedHashSet<SeqNode> deTNodes) throws Xcept {
        if (deTNodes == null || deTNodes.size() == 0) {
            return;
        }
        Iterator nodes = deTNodes.iterator();
        ArrayList<MuBlock> dblocks = new ArrayList<MuBlock>();
        while (nodes.hasNext()) {
            SeqNode node = (SeqNode)nodes.next();
            SeqItem item = this.nodeItems.get(node);
            if (item instanceof DETool) {
                DETool detool = (DETool)item;
                MuBlock mblock = this.matchingMuBlock(block, detool, dblocks);
                mblock.addDE(detool);
                continue;
            }
            block.add(item);
        }
        for (int i = 0; i < dblocks.size(); ++i) {
            MuBlock dblock = (MuBlock)dblocks.get(i);
            block.add(dblock);
            this.deblocks.add(dblock);
        }
    }

    private MuBlock matchingMuBlock(SeqBlock parent, DETool tool, ArrayList<MuBlock> dblocks) throws Xcept {
        for (int i = 0; i < dblocks.size(); ++i) {
            MuBlock deblock = dblocks.get(i);
            if (!deblock.matches(tool)) continue;
            return deblock;
        }
        MuBlock deblock = tool.xs.size() == 0 ? new ODEBlock(parent, tool, this.vuTools) : new PDEBlock(parent, tool, this.vuTools);
        dblocks.add(deblock);
        return deblock;
    }

    @Override
    public String title() {
        return "main";
    }

    public Hashtable<VarUsage, Tool> vuTools() {
        return this.vuTools;
    }

    public Logger logger() {
        return this.plan.logger;
    }

    public void log(String msg) {
        this.logger().log(msg);
    }

    private void logItems() throws Xcept {
        int i;
        this.log("Tools to sequence:");
        for (i = 0; i < this.tools.size(); ++i) {
            this.log(this.tools.get(i));
        }
        this.log("Events to seqence:");
        for (i = 0; i < this.events.size(); ++i) {
            this.log(this.events.get(i));
        }
        this.log("Relations to sequence:");
        for (i = 0; i < this.relations.size(); ++i) {
            this.log(this.relations.get(i));
        }
    }

    private void log(SeqItem seq) throws Xcept {
        String sloops;
        DomainSet loops = seq.seqLoops();
        VarUsages vups = new VarUsages(this.model);
        if (seq instanceof Tool) {
            vups = ((Tool)seq).vsols;
        }
        if (seq instanceof TEvent) {
            vups = ((TEvent)seq).vacts;
        }
        if ((sloops = loops.atString()).length() > 0) {
            sloops = sloops + " ";
        }
        this.log("  " + sloops + seq + " :: " + vups + "<<" + seq.vreqs());
    }

    private void dump(SeqGraph graph) throws Xcept {
        SeqIO.write(graph, System.out);
    }

    public Hashtable<SeqNode, SeqItem> nodeItems() {
        return this.nodeItems;
    }

    public SeqGraph untangledGraph() {
        return this.ugraph;
    }
}

