/*
 * Decompiled with CFR 0.152.
 */
package JSim.plan2;

import JSim.mml.Domain;
import JSim.mml.Var;
import JSim.plan2.AbortXcept;
import JSim.plan2.DomainSet;
import JSim.plan2.DomainTool;
import JSim.plan2.ImplicitBound;
import JSim.plan2.MainBlock;
import JSim.plan2.QueryTool;
import JSim.plan2.SeqEdge;
import JSim.plan2.SeqGraph;
import JSim.plan2.SeqItem;
import JSim.plan2.SeqNode;
import JSim.plan2.SeqPhase;
import JSim.plan2.TEvent;
import JSim.plan2.TModel;
import JSim.plan2.TRelation;
import JSim.plan2.Tool;
import JSim.plan2.VarUsage;
import JSim.util.Xcept;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.LinkedHashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MainGraph
extends SeqGraph
implements Comparator<Domain> {
    private MainBlock main;
    private int[] ndeT;
    private ArrayList<Domain> loopOrder;
    private Hashtable<SeqItem, SeqNode> itemNodes;
    private Hashtable<SeqNode, SeqItem> nodeItems;
    private Hashtable<DomainSet, SeqPhase> domsetPhases;
    private Hashtable<Domain, SeqNode> domainNodes;

    public MainGraph(MainBlock main) throws Xcept {
        VarUsage vu;
        int j;
        int i;
        this.main = main;
        this.loadLoopOrder();
        this.itemNodes = new Hashtable();
        this.nodeItems = new Hashtable();
        this.domsetPhases = new Hashtable();
        this.domsetPhases.put(new DomainSet(), this.mainPhase());
        this.domainNodes = new Hashtable();
        for (i = 0; i < this.tools().size(); ++i) {
            this.makeNode(this.tools().get(i));
        }
        for (i = 0; i < this.events().size(); ++i) {
            this.makeNode(this.events().get(i));
        }
        for (i = 0; i < this.tools().size(); ++i) {
            Tool tool = this.tools().get(i);
            SeqNode tnode = this.itemNodes.get(tool);
            for (j = 0; j < tool.vreqs.size(); ++j) {
                vu = tool.vreqs.get(j);
                this.addEdges(vu, tnode);
            }
            this.addDomainEdges(tool, tnode);
        }
        for (i = 0; i < this.events().size(); ++i) {
            TEvent event = this.events().get(i);
            SeqNode enode = this.itemNodes.get(event);
            for (j = 0; j < event.vacts.size(); ++j) {
                VarUsage vact = event.vacts.get(j);
                Tool tool = this.vuTool(vact);
                SeqNode tnode = this.itemNodes.get(tool);
                SeqEdge edge = new SeqEdge(tnode, enode);
                this.add(edge);
            }
            for (j = 0; j < event.vreqs.size(); ++j) {
                vu = event.vreqs.get(j);
                if (event.vacts.contains(vu)) continue;
                this.addEdges(vu, enode);
            }
        }
        for (i = 0; i < this.implicitBounds().size(); ++i) {
            ImplicitBound bound = this.implicitBounds().get(i);
            if (this.retryItems().contains(bound)) continue;
            SeqNode bnode = this.makeNode(bound);
            SeqNode tnode = this.itemNodes.get(bound.tool());
            this.add(new SeqEdge(bnode, tnode));
            for (int j2 = 0; j2 < bound.vreqs().size(); ++j2) {
                VarUsage vu2 = bound.vreqs().get(j2);
                this.addEdges(vu2, bnode);
            }
        }
        for (i = 0; i < this.relations().size(); ++i) {
            TRelation r = this.relations().get(i);
            SeqNode rnode = this.makeNode(r);
            for (int j3 = 0; j3 < r.vreqs().size(); ++j3) {
                VarUsage vu3 = r.vreqs().get(j3);
                this.addEdges(vu3, rnode);
            }
        }
    }

    private SeqNode makeNode(SeqItem item) throws Xcept {
        String name = item.nodeString();
        if (name == null) {
            throw new Xcept("Missing nodeName for SeqItem " + item);
        }
        SeqNode node = new SeqNode(name);
        if (item instanceof DomainTool) {
            Domain x = ((DomainTool)item).x();
            this.domainNodes.put(x, node);
        }
        DomainSet seqLoops = item.seqLoops();
        if (item instanceof QueryTool && this.retryItems().contains(item)) {
            seqLoops = ((QueryTool)item).delaySeqLoops();
        }
        node.setLoops(seqLoops.stringSet());
        SeqPhase phase = this.loadPhase(seqLoops);
        Domain t = item.t();
        if (t != null && item instanceof Tool) {
            node.setDeT(t.toString());
        }
        this.log("  addNode " + node + " seqLoops=" + seqLoops + " phase=" + phase + " deT=" + node.deT());
        this.add(node, phase);
        this.nodeItems.put(node, item);
        this.itemNodes.put(item, node);
        return node;
    }

    private void addEdges(VarUsage vu, SeqNode dest) throws Xcept {
        Tool tool = this.vuTool(vu);
        if (tool == null) {
            throw new AbortXcept("Can't sequence " + this.nodeItems.get(dest) + " due to unsolved variable " + vu);
        }
        LinkedHashSet<TEvent> events = this.vuEvents(vu);
        if (events != null) {
            events.removeAll(this.retryItems());
        }
        if (events == null || events.size() == 0) {
            SeqNode tnode = this.itemNodes.get(tool);
            this.add(new SeqEdge(tnode, dest));
        } else {
            for (TEvent event : events) {
                SeqNode enode = this.itemNodes.get(event);
                this.add(new SeqEdge(enode, dest));
            }
        }
    }

    private void addDomainEdges(Tool tool, SeqNode tnode) throws Xcept {
        DomainSet xset = new DomainSet();
        for (int i = 0; i < tool.vsols.size(); ++i) {
            Var v = tool.vsols.get(i).v();
            if (v.isDomain()) continue;
            xset.addAll(this.model().domSets.get((Object)v));
        }
        for (Domain x : xset) {
            if (tool.vreqs.hasVar(x)) continue;
            SeqNode xnode = this.domainNodes.get((Object)x);
            SeqEdge edge = new SeqEdge(xnode, tnode);
            this.add(edge);
        }
    }

    private SeqPhase loadPhase(DomainSet xset) throws Xcept {
        SeqPhase phase = this.domsetPhases.get(xset);
        if (phase != null) {
            return phase;
        }
        Domain xlast = null;
        for (Domain x : xset) {
            if (xlast != null && this.loopOrder.indexOf((Object)x) <= this.loopOrder.indexOf((Object)xlast)) continue;
            xlast = x;
        }
        if (xlast == null) {
            throw new Xcept("MainGraph.loadPhase(): mainPhase not found");
        }
        DomainSet xred = new DomainSet(xset);
        xred.remove((Object)xlast);
        phase = this.loadPhase(xred);
        phase = new SeqPhase(phase, xlast.toString());
        this.domsetPhases.put(xset, phase);
        return phase;
    }

    private void loadLoopOrder() throws Xcept {
        Domain t;
        int i;
        this.ndeT = new int[this.model().ndomains()];
        for (i = 0; i < this.tools().size(); ++i) {
            t = this.tools().get(i).t();
            if (t == null) continue;
            int n = t.domInx();
            this.ndeT[n] = this.ndeT[n] + 1;
        }
        for (i = 0; i < this.events().size(); ++i) {
            t = this.events().get(i).t();
            int n = t.domInx();
            this.ndeT[n] = this.ndeT[n] + 1;
        }
        this.loopOrder = new ArrayList<Domain>(this.model().doms);
        Collections.sort(this.loopOrder, this);
        this.log("loopOrder=" + this.loopOrder);
    }

    @Override
    public int compare(Domain x, Domain y) {
        return this.ndeT[y.domInx()] - this.ndeT[x.domInx()];
    }

    public TModel model() {
        return this.main.model;
    }

    public ArrayList<Tool> tools() {
        return this.main.tools;
    }

    public ArrayList<TEvent> events() {
        return this.main.events;
    }

    public ArrayList<TRelation> relations() {
        return this.main.relations;
    }

    public ArrayList<ImplicitBound> implicitBounds() {
        return this.main.implicitBounds;
    }

    public LinkedHashSet<SeqItem> retryItems() {
        return this.main.retryItems;
    }

    public Tool vuTool(VarUsage vu) {
        return this.main.vuTools().get(vu);
    }

    public LinkedHashSet<TEvent> vuEvents(VarUsage vu) {
        return this.model().vuEvents.get(vu);
    }

    public void log(String msg) {
        this.main.log(msg);
    }

    public Hashtable<SeqNode, SeqItem> nodeItems() {
        return this.nodeItems;
    }
}

