/*
 * Decompiled with CFR 0.152.
 */
package JSim.plan2;

import JSim.mml.Var;
import JSim.plan2.DETool;
import JSim.plan2.DomainSet;
import JSim.plan2.DomainTool;
import JSim.plan2.ExprTool;
import JSim.plan2.ExternTool;
import JSim.plan2.ImplicitTool;
import JSim.plan2.ProcTool;
import JSim.plan2.QueryTool;
import JSim.plan2.ReuseTool;
import JSim.plan2.SeqBlock;
import JSim.plan2.StateTool;
import JSim.plan2.Tool;
import JSim.plan2.ToolBox;
import JSim.plan2.VarUsage;
import JSim.plan2.VarUsages;
import JSim.util.Xcept;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedHashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MuBlock
extends SeqBlock {
    protected String title;
    protected Hashtable<VarUsage, Tool> vuTools;
    protected ArrayList<DETool> detools;
    protected ArrayList<Var> vstate;
    protected DomainSet muDoms;
    protected VarUsages vmus;
    protected VarUsages vsols;
    private Hashtable<Tool, Boolean> muToolMap;
    private HashSet<Tool> muToolSet;
    private VarUsages muSolved;
    private VarUsages orderSolved;

    public MuBlock(SeqBlock parent, Hashtable<VarUsage, Tool> vuTools) throws Xcept {
        super(parent);
        this.vuTools = vuTools;
        this.title = "untitled block";
        this.detools = new ArrayList();
        this.vstate = new ArrayList();
        this.muDoms = new DomainSet();
        this.vmus = new VarUsages(this.model());
        this.vsols = new VarUsages(this.model());
    }

    protected void addDE(DETool detool) throws Xcept {
        this.detools.add(detool);
        for (int i = 0; i < detool.vsols.size(); ++i) {
            VarUsage vu = detool.vsols.get(i);
            if (!vu.isCurr()) continue;
            this.vstate.add(vu.v());
        }
    }

    protected void build() throws Xcept {
        this.log("Building " + this + " ...");
        this.buildMus();
        this.buildOrder();
    }

    protected void buildMus() throws Xcept {
        this.muToolMap = new Hashtable();
        this.muToolSet = new LinkedHashSet<Tool>();
        this.vmus.add(this.muDoms);
        this.vmus.add(this.vstate);
        for (int i = 0; i < this.vsols.size(); ++i) {
            this.buildMu(this.vsols.get(i));
        }
    }

    protected void buildMu(VarUsage vu) throws Xcept {
        if (this.vmus.contains(vu)) {
            return;
        }
        Tool tool = this.vuTools.get(vu);
        if (!this.buildMu(tool)) {
            return;
        }
        this.log("  adding muVar " + vu);
        this.vmus.add(vu);
        for (int i = 0; i < tool.vreqs().size(); ++i) {
            this.buildMu(tool.vreqs().get(i));
        }
    }

    private boolean buildMu(Tool tool) throws Xcept {
        boolean ret;
        Boolean b = this.muToolMap.get(tool);
        if (b != null) {
            return b;
        }
        if (!tool.seqLoops().containsAny(this.muDoms)) {
            ret = false;
        } else if (tool instanceof DETool) {
            ret = false;
        } else if (!this.specDoms.containsAll(tool.seqLoops())) {
            ret = false;
        } else if (this.box().isInput(tool)) {
            ret = true;
        } else if (tool instanceof ExprTool) {
            ret = this.buildMu(tool.vreqs());
        } else if (tool instanceof ImplicitTool) {
            ret = this.buildMu(tool.vreqs());
        } else if (tool instanceof QueryTool) {
            ret = this.buildMu(tool.vreqs());
        } else if (tool instanceof DomainTool) {
            ret = false;
        } else if (tool instanceof StateTool) {
            ret = false;
        } else if (tool instanceof ExternTool) {
            ret = true;
        } else if (tool instanceof ProcTool) {
            ret = false;
        } else if (tool instanceof ReuseTool) {
            ret = false;
        } else {
            throw new Xcept("MuBlock: unrecognized tool " + tool);
        }
        b = ret ? Boolean.TRUE : Boolean.FALSE;
        this.muToolMap.put(tool, b);
        if (ret) {
            this.log("  adding muTool " + tool);
            this.muToolSet.add(tool);
        }
        return ret;
    }

    private boolean buildMu(VarUsages vus) throws Xcept {
        for (int i = 0; i < vus.size(); ++i) {
            VarUsage vu = vus.get(i);
            if (this.vmus.contains(vu)) {
                return true;
            }
            Tool tool = this.vuTools.get(vu);
            if (!this.buildMu(tool)) continue;
            return true;
        }
        return false;
    }

    protected void buildOrder() throws Xcept {
        this.muSolved = new VarUsages(this.model());
        for (Tool tool : this.muToolSet) {
            this.muSolved.add(tool.vsols);
        }
        this.orderSolved = new VarUsages(this.model());
        while (this.buildOrderPass()) {
        }
        if (this.size() != this.muToolSet.size()) {
            throw new Xcept("MuBlock: internal sequencing error");
        }
    }

    private boolean buildOrderPass() throws Xcept {
        boolean working = false;
        for (Tool tool : this.muToolSet) {
            if (this.items().contains(tool) || !this.isReady(tool)) continue;
            this.add(tool);
            this.orderSolved.add(tool.vsols);
            working = true;
        }
        return working;
    }

    private boolean isReady(Tool tool) throws Xcept {
        for (int i = 0; i < tool.vreqs.size(); ++i) {
            VarUsage vu = tool.vreqs.get(i);
            if (!this.muSolved.contains(vu) || this.orderSolved.contains(vu)) continue;
            return false;
        }
        return true;
    }

    @Override
    public String title() {
        return this.title;
    }

    public boolean matches(DETool tool) {
        return false;
    }

    public ToolBox box() {
        return this.model().plan.box();
    }

    public ArrayList<Var> vstate() {
        return this.vstate;
    }

    public DomainSet muDoms() {
        return this.muDoms;
    }

    public VarUsages vmus() {
        return this.vmus;
    }

    public ArrayList<DETool> detools() {
        return this.detools;
    }

    public void log(String msg) {
        this.model().log(msg);
    }
}

