/*
 * Decompiled with CFR 0.152.
 */
package JSim.plan2;

import JSim.mml.Domain;
import JSim.mml.Var;
import JSim.plan2.AbortXcept;
import JSim.plan2.DECon;
import JSim.plan2.DETool;
import JSim.plan2.ExprTool;
import JSim.plan2.PDEFactors;
import JSim.plan2.TEqn;
import JSim.plan2.TModel;
import JSim.plan2.Tool;
import JSim.plan2.VarUsage;
import JSim.plan2.VarUsages;
import JSim.util.CompareExpr;
import JSim.util.Expr;
import JSim.util.IfExpr;
import JSim.util.NamedQueryExpr;
import JSim.util.Xcept;
import java.util.LinkedHashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PDE1Factors
extends PDEFactors {
    private Domain x;
    private Var v;
    private Var vt;
    private Var vx;
    private Var vxx;
    private DECon lhbc;
    private DECon rhbc;
    private Expr coefD;
    private Expr coefDx;
    private Expr coefP;
    private Expr coefB;
    private Expr coefS;
    private Expr[] coefF1;
    private Expr[] coefF2;
    private Expr[] coefF3;
    private Expr toms731_C;
    private Expr toms731_Q;
    private Expr toms731_R;
    private Expr[] toms731_Beta;
    private Expr[] toms731_Gamma;
    private String factorMsg;
    private String[] solverMsgs;

    public PDE1Factors(DETool detool) throws Xcept {
        super(detool);
        if (detool.xs.size() != 1) {
            throw new Xcept("Wrong PDE dimension for PDE1Factors");
        }
        this.x = detool.xs.first();
        this.v = detool.v;
        this.vt = this.v.deriv(this.t);
        this.vx = this.v.deriv(this.x);
        this.vxx = this.vx.deriv(this.x);
        this.lhbc = detool.bc(this.model().lhbcs.get((Object)this.x));
        this.rhbc = detool.bc(this.model().rhbcs.get((Object)this.x));
        this.coefF1 = new Expr[2];
        this.coefF2 = new Expr[2];
        this.coefF3 = new Expr[2];
        this.toms731_Beta = new Expr[2];
        this.toms731_Gamma = new Expr[2];
        this.factorMsg = this.factorState();
        if (this.factorMsg != null) {
            return;
        }
        this.factorAdvection();
        this.log("PDE(" + (Object)((Object)this.v) + ") factors: " + " D=" + this.coefD + " P=" + this.coefP + " B=" + this.coefB + " S=" + this.coefS);
        this.factorMsg = this.factorBC(true);
        if (this.factorMsg != null) {
            return;
        }
        this.factorMsg = this.factorBC(false);
        if (this.factorMsg != null) {
            return;
        }
        this.solverMsgs = new String[3];
        this.solverMsgs[0] = this.lsfeaMsg();
        this.solverMsgs[1] = this.macCormackMsg();
        this.solverMsgs[2] = this.toms731Msg();
    }

    private String factorState() throws Xcept {
        Expr e0 = this.zeroExpr(this.detool.state());
        Expr coefVT = e0.linearFactor((NamedQueryExpr)this.vt, true).simplify();
        e0 = e0.linearFactor((NamedQueryExpr)this.vt, false).mult((Expr)Expr.negone).simplify();
        this.coefD = e0.linearFactor((NamedQueryExpr)this.vxx, true).div(coefVT);
        this.coefD = this.coefD.simplify();
        this.coefP = e0.linearFactor((NamedQueryExpr)this.vxx, false).div(coefVT).simplify();
        VarUsages vus = new VarUsages(this.model(), new Expr[]{this.coefD, this.coefP});
        if (vus.hasVar(this.vt) || vus.hasVar(this.vxx)) {
            return "PDE " + this.detool.state() + " could not be factored to ideal form: " + (Object)((Object)this.vt) + " = D*" + (Object)((Object)this.vxx) + " + P";
        }
        if (this.containsDerivs(this.coefD)) {
            return "Diffusion term (" + this.coefD + ") may not contain derivatives";
        }
        if (this.realVal(this.coefD) < 0.0) {
            return "PDE has negative diffusion term: " + this.coefD;
        }
        return null;
    }

    private void factorAdvection() throws Xcept {
        this.coefB = this.coefP.linearFactor((NamedQueryExpr)this.vx, true).mult((Expr)Expr.negone).simplify();
        this.coefS = this.coefP.linearFactor((NamedQueryExpr)this.vx, false).simplify();
        Expr.List list = new Expr.List(1);
        VarUsages vus = new VarUsages(this.model(), new Expr[]{this.coefD, this.coefB, this.coefS});
        if (vus.hasVar(this.vx)) {
            this.coefS = null;
            this.coefB = null;
        } else if (this.containsDerivs(this.coefB) || this.containsDerivs(this.coefS)) {
            this.coefS = null;
            this.coefB = null;
        }
    }

    private String factorBC(boolean left) throws Xcept {
        DECon con = left ? this.lhbc : this.rhbc;
        Expr[] fs = new Expr[3];
        Expr bcz = this.zeroExpr(con);
        fs[0] = bcz.linearFactor((NamedQueryExpr)this.v, true).simplify();
        Expr rem = bcz.linearFactor((NamedQueryExpr)this.v, false).simplify();
        fs[1] = rem.linearFactor((NamedQueryExpr)this.vx, true).simplify();
        Expr f3 = rem.linearFactor((NamedQueryExpr)this.vx, false).mult((Expr)Expr.negone);
        fs[2] = f3.simplify();
        VarUsages vus = new VarUsages(this.model(), fs);
        if (vus.hasVar(this.vt) || vus.hasVar(this.vx) || vus.hasVar(this.vxx) || this.containsDerivs(fs)) {
            throw new AbortXcept("PDE BC " + con + " cannot be factored to ideal form: " + "f1*" + (Object)((Object)this.v) + " + f2*" + (Object)((Object)this.vx) + " = f3");
        }
        this.coefF1[this.bcinx((boolean)left)] = fs[0];
        this.coefF2[this.bcinx((boolean)left)] = fs[1];
        this.coefF3[this.bcinx((boolean)left)] = fs[2];
        this.log("  " + (left ? "LHBC" : "RHBC") + " F1=" + this.coefF1(left) + " F2=" + this.coefF2(left) + " F3=" + this.coefF3(left));
        return null;
    }

    public String lsfeaMsg() throws Xcept {
        if (this.coefB == null) {
            return "PDE state eqn not factorable";
        }
        if (this.hasXDependence(this.coefB)) {
            return "Advection term " + this.coefB + " has spatial dependency";
        }
        if (this.hasXDependence(this.coefD)) {
            return "Diffusion term " + this.coefD + " has spatial dependency";
        }
        if (this.realVal(this.coefD) < 0.0) {
            return "Negative diffusion term: " + this.coefD;
        }
        double Bval = this.realVal(this.coefB);
        if (Bval == 0.0 && (this.realValNonZero(this.coefF1(true)) || this.realValNonZero(this.coefF1(false)) || this.realValNonZero(this.coefF3(true)) || this.realValNonZero(this.coefF3(false)))) {
            return "Zero advection requires zero f1, f3, g1 and g3";
        }
        if (Bval > 0.0 && this.realVal(this.coefF1(true)) == 0.0) {
            return "Positive advection requires non-zero f1";
        }
        if (Bval < 0.0 && this.realVal(this.coefF1(false)) == 0.0) {
            return "Negative advection requires non-zero g1";
        }
        if (this.realValNonZero(this.coefF1(true)) && this.realValNonZero(this.coefF1(false))) {
            return "At least one of f1,g1 must be zero";
        }
        if (this.realVal(this.coefF2(true)) == 0.0 && this.realVal(this.coefF2(false)) == 0.0) {
            return "At least one of f2,g2 must be non-zero";
        }
        return null;
    }

    @Override
    protected void setBlockVars(LinkedHashSet<Var> vblock) throws Xcept {
        if (this.solverMsgs == null) {
            return;
        }
        String s = this.solverMsgs[0];
        if (s == null) {
            s = this.lsfeaBCMsg(vblock, true);
        }
        if (s == null) {
            s = this.lsfeaBCMsg(vblock, false);
        }
        this.solverMsgs[0] = s;
    }

    private String lsfeaBCMsg(LinkedHashSet<Var> vblock, boolean left) throws Xcept {
        VarUsages vus = new VarUsages(this.model(), new Expr[]{this.coefF1(left), this.coefF2(left), this.coefF3(left)});
        for (int i = 0; i < vus.size(); ++i) {
            VarUsage vu = vus.get(i);
            if (!vblock.contains((Object)vu.v())) continue;
            return "BC " + this.bc(left) + " depends on PDE block variable " + vu;
        }
        return null;
    }

    private String macCormackMsg() throws Xcept {
        if (this.coefB == null || this.coefS == null) {
            return "PDE state equation not factorable";
        }
        VarUsages vus = new VarUsages(this.model(), new Expr[]{this.coefD, this.coefB, this.coefS});
        if (vus.hasVar(this.vx)) {
            return "Unsupported " + (Object)((Object)this.vx) + " in PDE state eqn";
        }
        if (this.realVal(this.coefD) < 0.0) {
            return "Negative diffusion term: " + this.coefD;
        }
        return null;
    }

    private String toms731Msg() throws Xcept {
        if (this.coefD == null) {
            return "PDE state eqn not factorable";
        }
        if (this.realVal(this.coefD) < 0.0) {
            return "Negative diffusion term: " + this.coefD;
        }
        return null;
    }

    protected void setCoefDx(Expr coefDx) throws Xcept {
        this.coefDx = coefDx;
        if (coefDx == null) {
            this.solverMsgs[2] = "Diffusion term not symbolically differentiable";
        }
        if (this.solverMsg(2) == null) {
            this.factorToms731();
            this.log("  Tom731  C=" + this.toms731_C + " Q=" + this.toms731_Q + " R=" + this.toms731_R);
            this.log("  Toms731 LHBC:  Beta=" + this.toms731_Beta(true) + " Gamma=" + this.toms731_Beta(true));
            this.log("  Toms731 RHBC:  Beta=" + this.toms731_Beta(false) + " Gamma=" + this.toms731_Beta(false));
        }
    }

    private void factorToms731() throws Xcept {
        this.toms731_C = Expr.one;
        this.toms731_Q = this.coefDx.mult((Expr)this.vx).sub(this.coefP).simplify();
        this.toms731_R = this.coefD.mult((Expr)this.vx).simplify();
        this.toms731_Beta = new Expr[2];
        this.toms731_Gamma = new Expr[2];
        this.factorToms731BC(true);
        this.factorToms731BC(false);
    }

    private void factorToms731BC(boolean left) throws Xcept {
        Expr f1 = this.coefF1(left);
        Expr f2 = this.coefF2(left);
        IfExpr beta = new IfExpr(f2.eq((Expr)Expr.zero), (Expr)Expr.zero, (Expr)Expr.one);
        this.toms731_Beta[this.bcinx((boolean)left)] = beta.simplify();
        DECon con = left ? this.lhbc : this.rhbc;
        Expr bcz = this.zeroExpr(con);
        IfExpr GB0 = new IfExpr(f1.eq((Expr)Expr.zero), bcz, bcz.div(f1));
        Expr GB1 = this.vx.sub(bcz.div(f2)).mult(this.coefD).simplify();
        IfExpr gamma = new IfExpr(f2.eq((Expr)Expr.zero), (Expr)GB0, GB1);
        this.toms731_Gamma[this.bcinx((boolean)left)] = gamma.simplify();
    }

    private Expr zeroExpr(DECon con) throws Xcept {
        TEqn eqn = con.eqn();
        if (eqn != null) {
            CompareExpr cexpr = (CompareExpr)eqn.expr().expr();
            return cexpr.arg(0).sub(cexpr.arg(1)).simplify();
        }
        Tool tool = con.tool();
        if (!(tool instanceof ExprTool)) {
            throw new AbortXcept("Can't factor PDE " + (con.isState() ? "state eqn" : "BC") + ": " + tool);
        }
        ExprTool etool = (ExprTool)tool;
        Var v = etool.vu.v();
        Expr expr = etool.expr.expr();
        return v.sub(expr).simplify();
    }

    private boolean hasXDependence(Expr expr) throws Xcept {
        Expr.List doms = new Expr.List();
        expr.addDomains(doms);
        return doms.containSame((Expr)this.x);
    }

    private boolean containsDerivs(Expr expr) throws Xcept {
        return this.containsDerivs(new Expr[]{expr});
    }

    private boolean containsDerivs(Expr[] exprs) throws Xcept {
        VarUsages vus = new VarUsages(this.model(), exprs);
        for (int i = 0; i < vus.size(); ++i) {
            if (!vus.get(i).v().isDeriv()) continue;
            return true;
        }
        return false;
    }

    private double realVal(Expr expr) throws Xcept {
        return expr.isConst() ? expr.constRealVal() : Double.NaN;
    }

    private boolean realValNonZero(Expr expr) throws Xcept {
        double d = this.realVal(expr);
        if (Double.isNaN(d)) {
            return false;
        }
        return d != 0.0;
    }

    private TModel model() {
        return this.detool.model;
    }

    private int bcinx(boolean left) {
        return left ? 0 : 1;
    }

    private DECon bc(boolean left) {
        return left ? this.lhbc : this.rhbc;
    }

    public Expr coefD() {
        return this.coefD;
    }

    public Expr coefDx() {
        return this.coefDx;
    }

    public Expr coefP() {
        return this.coefP;
    }

    public Expr coefB() {
        return this.coefB;
    }

    public Expr coefS() {
        return this.coefS;
    }

    public Expr coefF1(boolean left) {
        return this.coefF1[this.bcinx(left)];
    }

    public Expr coefF2(boolean left) {
        return this.coefF2[this.bcinx(left)];
    }

    public Expr coefF3(boolean left) {
        return this.coefF3[this.bcinx(left)];
    }

    public Expr toms731_C() {
        return this.toms731_C;
    }

    public Expr toms731_Q() {
        return this.toms731_Q;
    }

    public Expr toms731_R() {
        return this.toms731_R;
    }

    public Expr toms731_Beta(boolean left) {
        return this.toms731_Beta[this.bcinx(left)];
    }

    public Expr toms731_Gamma(boolean left) {
        return this.toms731_Gamma[this.bcinx(left)];
    }

    public boolean hasAdvection() {
        return this.coefB != null && !this.coefB.sameAs((Expr)Expr.zero);
    }

    @Override
    public String factorMsg() {
        return this.factorMsg;
    }

    @Override
    public String solverMsg(int id) throws Xcept {
        if (this.factorMsg != null) {
            return this.factorMsg;
        }
        if (id < 0 || id >= this.solverMsgs.length) {
            throw new Xcept("Unknown PDE 1D solver id=" + id);
        }
        return this.solverMsgs[id];
    }

    protected void log(String msg) {
        this.model().log(msg);
    }
}

