/*
 * Decompiled with CFR 0.152.
 */
package JSim.plan2;

import JSim.mml.Domain;
import JSim.mml.Var;
import JSim.plan2.AbortXcept;
import JSim.plan2.BCBlock;
import JSim.plan2.DECon;
import JSim.plan2.DETool;
import JSim.plan2.DomainSet;
import JSim.plan2.MuBlock;
import JSim.plan2.PDEFactors;
import JSim.plan2.SeqBlock;
import JSim.plan2.TSubDom;
import JSim.plan2.Tool;
import JSim.plan2.VarUsage;
import JSim.util.Xcept;
import java.util.Hashtable;
import java.util.LinkedHashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PDEBlock
extends MuBlock {
    protected Domain t;
    protected DomainSet xs;
    protected String[] solverMsgs;
    protected Hashtable<TSubDom, BCBlock> bcblocks;
    private static final String[] solverNames1D = new String[]{"LSFEA", "MacCormack", "Toms731"};

    public PDEBlock(SeqBlock parent, DETool detool, Hashtable<VarUsage, Tool> vuTools) throws Xcept {
        super(parent, vuTools);
        this.t = detool.t();
        this.xs = detool.xs;
        this.muDoms.add(this.t);
        this.muDoms.addAll(this.xs);
        this.specDoms.addAll(this.muDoms);
        this.title = "PDE Block-" + (Object)((Object)this.t) + this.xs;
    }

    @Override
    protected void addDE(DETool detool) throws Xcept {
        super.addDE(detool);
    }

    @Override
    protected void build() throws Xcept {
        this.log("Building " + this + " ...");
        this.buildVsols();
        this.setFactorVars();
        this.buildSolvers();
        this.buildMus();
        this.buildOrder();
        this.buildBCs();
    }

    private void buildVsols() throws Xcept {
        for (int i = 0; i < this.detools.size(); ++i) {
            DETool detool = (DETool)this.detools.get(i);
            DECon state = detool.state();
            for (int j = 0; j < state.vreqs().size(); ++j) {
                VarUsage vu = state.vreqs().get(j);
                if (this.box().isPDEFirstSpatialDeriv(vu)) {
                    Var v0 = vu.v().zeroDeriv();
                    if (this.vstate.contains((Object)v0)) continue;
                    throw new AbortXcept("Variable " + vu + " unsolved in PDE block");
                }
                this.vsols.add(vu);
            }
        }
    }

    private void setFactorVars() throws Xcept {
        LinkedHashSet<Var> vblock = new LinkedHashSet<Var>(this.vstate);
        for (int i = 0; i < this.detools.size(); ++i) {
            PDEFactors factors = this.factors(i);
            if (factors == null) continue;
            factors.setBlockVars(vblock);
            String msg = factors.factorMsg();
            if (msg == null) continue;
            throw new AbortXcept("Can't factor PDE " + (Object)((Object)((DETool)this.detools.get((int)i)).v) + ": " + msg);
        }
    }

    private void buildSolvers() throws Xcept {
        int n = this.xs.size() == 1 ? 3 : 0;
        this.solverMsgs = new String[n];
        if (n == 0) {
            return;
        }
        for (int id = 0; id < n; ++id) {
            String s;
            this.solverMsgs[id] = s = this.buildSolverMsg(id);
            if (s == null) {
                s = "supported";
            }
            this.log("PDE solver " + this.solverName(id) + ": " + s);
        }
    }

    private String buildSolverMsg(int id) throws Xcept {
        for (int j = 0; j < this.detools.size(); ++j) {
            String s = this.factors(j).solverMsg(id);
            if (s == null) continue;
            return s;
        }
        return null;
    }

    private void buildBCs() throws Xcept {
        this.bcblocks = new Hashtable();
        for (Domain x : this.xs) {
            this.buildBC(this.model().lhbcs.get((Object)x));
            this.buildBC(this.model().rhbcs.get((Object)x));
        }
    }

    private void buildBC(TSubDom bc) throws Xcept {
        BCBlock block = new BCBlock(this, bc);
        block.build();
        this.bcblocks.put(bc, block);
    }

    @Override
    public String toString() {
        return this.title() + " " + this.vstate;
    }

    @Override
    public boolean matches(DETool detool) {
        return this.t == detool.t() && this.xs.equals(detool.xs);
    }

    @Override
    public Domain t() {
        return this.t;
    }

    public DomainSet xs() {
        return this.xs;
    }

    public int nx() {
        return this.xs.size();
    }

    public int nsolvers() {
        return this.nx() == 1 ? solverNames1D.length : 0;
    }

    public String solverName(int id) {
        if (id < 0 || id >= this.nsolvers()) {
            return "Unknown PDE solver id=" + id;
        }
        return solverNames1D[id];
    }

    public String solverMsg(int id) {
        return this.solverMsgs[id];
    }

    public PDEFactors factors(int i) {
        return ((DETool)this.detools.get(i)).factors();
    }

    public BCBlock bcblock(Domain x, boolean left) {
        TSubDom sd = left ? this.model().lhbcs.get((Object)x) : this.model().rhbcs.get((Object)x);
        return this.bcblocks.get(sd);
    }
}

