/*
 * Decompiled with CFR 0.152.
 */
package JSim.plan2;

import JSim.data.NamedVal;
import JSim.mml.Model;
import JSim.plan2.Logger;
import JSim.plan2.MainBlock;
import JSim.plan2.PlanGraphML;
import JSim.plan2.TModel;
import JSim.plan2.ToolBox;
import JSim.util.Xcept;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.w3c.dom.Document;

public class Plan {
    public Logger logger = new Logger();
    private Model flatModel;
    private NamedVal.NList options;
    private TModel model;
    private ToolBox box;
    private MainBlock main;

    public Plan(Model model) {
        this.flatModel = model;
        this.options = new NamedVal.NList();
    }

    public void setVerbose(String vtags) {
        this.logger.setVerbose(vtags);
    }

    public void setOptions(NamedVal.NList options) {
        this.options = options;
        this.log("Plan options=" + options);
        this.logger.setTimeout(this.timeout());
        this.logger.setSaveGraphs(this.saveUntanglerGraphs());
    }

    public void process() throws Xcept {
        try {
            this.model = new TModel(this, this.flatModel);
        }
        catch (Exception e) {
            this.logger.log(e);
        }
        this.logPhase("Input     ");
        if (this.logger.nerrors() > 0) {
            return;
        }
        this.box = new ToolBox(this);
        try {
            this.box.build();
        }
        catch (Exception e) {
            this.logger.log(e);
        }
        this.logPhase("Toolbox   ");
        if (this.logger.nerrors() > 0) {
            return;
        }
        if (!this.makeSequence()) {
            return;
        }
        this.main = new MainBlock(this.box);
        try {
            this.main.build();
        }
        catch (Exception e) {
            this.logger.log(e);
        }
        this.logPhase("Sequencing");
    }

    public void log(String msg) {
        this.logger.log(msg);
    }

    public void log(int code, String msg) {
        this.logger.log(code, msg);
    }

    public void logPhase(String phase) {
        String s = this.logger.nerrors() > 0 ? "aborted  " : "completed";
        this.log(phase + " phase " + s + " with " + this.logger.nerrors() + " errors, " + this.logger.nwarnings() + " warnings.");
    }

    public TModel model() {
        return this.model;
    }

    public ToolBox box() {
        return this.box;
    }

    public MainBlock main() {
        return this.main;
    }

    public int timeout() {
        return this.options.intVal("timeout", 5);
    }

    public int maxImplicitBlock() {
        int i = this.options.intVal("maxImplicitBlock", 10);
        if (i < 10) {
            i = 10;
        }
        return i;
    }

    public double maxImplicitSearch() {
        return this.options.realVal("maxImplicitSearch", 1000000.0);
    }

    public boolean allowMissingDomainControls() {
        return this.options.boolVal("allowMissingDomainControls", true);
    }

    public boolean allowMissingICs() {
        return this.options.boolVal("allowMissingICs", false);
    }

    public boolean allowOrphanICs() {
        return this.options.boolVal("allowOrphanICs", false);
    }

    public boolean ignoreUnusedEquations() {
        return this.options.boolVal("ignoreUnusedEquations", false);
    }

    public boolean makeDEICParms() {
        return this.options.boolVal("makeDEICParms", true);
    }

    public boolean makeStateICParms() {
        return this.options.boolVal("makeStateICParms", false);
    }

    public boolean makeSequence() {
        return this.options.boolVal("makeSequence", true);
    }

    public int seqMaxPulls() {
        return this.options.intVal("seqMaxPulls", 10);
    }

    public boolean makeDerivTools() {
        return this.options.boolVal("makeDerivTools", true);
    }

    public boolean makeInputTools() {
        return this.options.boolVal("makeInputTools", true);
    }

    public boolean initNaN() {
        return this.options.boolVal("initNaN", true);
    }

    public boolean abortNaN() {
        return this.options.boolVal("abortNaN", false);
    }

    public boolean traceNaN() {
        return this.options.boolVal("traceNaN", false);
    }

    public String traceVars() {
        return this.options.stringVal("traceVars", "");
    }

    public int untanglerVersion() {
        return this.options.intVal("u", 3);
    }

    public boolean saveUntanglerGraphs() {
        return this.options.boolVal("usave", true);
    }

    public int hack() {
        return this.options.intVal("hack", 0);
    }

    public Document getGraphML() throws Xcept {
        PlanGraphML gml = new PlanGraphML(this);
        return gml.getXML();
    }

    public String getPlanText() throws Xcept {
        if (this.main == null) {
            return null;
        }
        StringWriter swrt = new StringWriter();
        PrintWriter pwrt = new PrintWriter(swrt);
        pwrt.println("==== Planner Log ====");
        for (int i = 0; i < this.logger.msgs.size(); ++i) {
            pwrt.println((String)this.logger.msgs.get(i));
        }
        if (this.main != null) {
            pwrt.println("");
            pwrt.println("==== Main Calculation Block ====");
            this.main.dump(pwrt);
        }
        return swrt.toString();
    }
}

