/*
 * Decompiled with CFR 0.152.
 */
package JSim.plan2;

import JSim.plan2.Plan;
import JSim.plan2.SeqGraphML;
import JSim.plan2.VarGraphML;
import JSim.util.UtilXML;
import JSim.util.Xcept;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class PlanGraphML {
    protected Plan plan;
    private VarGraphML varGraph;
    private SeqGraphML seqGraph;
    private Document doc;

    public PlanGraphML(Plan plan) throws Xcept {
        this.plan = plan;
        this.varGraph = new VarGraphML(this);
        this.seqGraph = new SeqGraphML(this);
    }

    public Document getXML() throws Xcept {
        if (this.doc != null) {
            return this.doc;
        }
        this.doc = UtilXML.createDoc((String)"graphml");
        this.varGraph.loadGraph(this.doc);
        this.seqGraph.loadGraphs(this.doc);
        return this.doc;
    }

    protected Element addGraph(Element p, String id) {
        Element g = this.doc.createElement("graph");
        g.setAttribute("edgedefault", "directed");
        g.setAttribute("id", id);
        p.appendChild(g);
        return g;
    }

    protected void addNodeKey(Element g, String key) {
        this.addNodeKey(g, key, "string");
    }

    protected void addNodeKey(Element g, String key, String type) {
        Element ek = this.doc.createElement("key");
        ek.setAttribute("id", key);
        ek.setAttribute("for", "node");
        ek.setAttribute("attr.name", key);
        ek.setAttribute("attr.type", type);
        g.appendChild(ek);
    }

    protected Element addNode(Element g, String id, String name) {
        Element e = this.doc.createElement("node");
        e.setAttribute("id", id);
        this.addData(e, "name", name);
        g.appendChild(e);
        return e;
    }

    protected Element addEdge(Element g, String src, String tar) {
        Element e = this.doc.createElement("edge");
        e.setAttribute("source", src);
        e.setAttribute("target", tar);
        g.appendChild(e);
        return e;
    }

    protected void addData(Element node, String key, String value) {
        if (value == null) {
            value = "";
        }
        Element e = this.doc.createElement("data");
        e.setAttribute("key", key);
        Text text = this.doc.createTextNode(value);
        e.appendChild(text);
        node.appendChild(e);
    }

    protected void addComment(Element e, String txt) {
        Element c = this.doc.createElement("comment");
        Text t = this.doc.createTextNode(txt);
        c.appendChild(t);
        e.appendChild(c);
    }
}

