/*
 * Decompiled with CFR 0.152.
 */
package JSim.plan2;

import JSim.data.NamedVal;
import JSim.data.XMLWriter;
import JSim.jcode2.JPlanWriter;
import JSim.mml.Model;
import JSim.mml.ModelReader;
import JSim.plan2.Plan;
import JSim.plan2.XMMLWriter;
import JSim.util.Named;
import JSim.util.Util;
import JSim.util.UtilXML;
import JSim.util.Xcept;
import java.io.OutputStream;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class PlanTest {
    boolean quiet = false;
    boolean lineFmt = false;
    boolean outXMML = false;
    String outGML = null;
    boolean outJava = false;
    String vtags;
    NamedVal.NList options;
    int exitStat = 0;
    String modFileName;
    Model mmlModel;
    Plan plan;
    String modStat;
    String boxStat;
    String seqStat;
    String msgStat;

    public PlanTest(String[] args) throws Exception {
        Util.v2 = true;
        int i = 0;
        this.vtags = null;
        while (i < args.length && args[i].startsWith("-")) {
            String arg;
            if ((arg = args[i++]).startsWith("-v")) {
                this.vtags = arg.substring(2);
                continue;
            }
            if (arg.equals("-q")) {
                this.quiet = true;
                continue;
            }
            if (arg.equals("-ox")) {
                this.outXMML = true;
                continue;
            }
            if (arg.startsWith("-og")) {
                this.outGML = arg.substring(3);
                continue;
            }
            if (arg.equals("-oj")) {
                this.outJava = true;
                continue;
            }
            if (arg.equals("-line")) {
                this.lineFmt = true;
                continue;
            }
            throw new Xcept("Unknown switch: " + arg);
        }
        this.options = new NamedVal.NList();
        while (i < args.length && args[i].indexOf(61) > 0) {
            int inx = args[i].indexOf(61);
            String name = args[i].substring(0, inx);
            String value = args[i].substring(inx + 1);
            NamedVal nval = NamedVal.guess((String)name, (String)value);
            this.options.add((Named)nval);
            ++i;
        }
        while (i < args.length) {
            Object wrt;
            boolean strictOut;
            this.modFileName = args[i];
            boolean bl = strictOut = this.outXMML || this.outGML != null || this.outJava;
            if (!strictOut && !this.lineFmt) {
                System.out.println("\n==== " + this.modFileName + " (errors)");
            }
            if (strictOut && args.length > 1) {
                System.err.println("\n==== " + this.modFileName);
            }
            this.mmlModel = null;
            this.modStat = "FAIL";
            this.boxStat = "SKIP";
            this.seqStat = "SKIP";
            this.msgStat = "";
            this.plan = null;
            try {
                this.mmlModel = new ModelReader(this.modFileName);
                this.mmlModel.flatten("testmodel.junk");
                this.modStat = "PASS";
            }
            catch (Exception e) {
                if (!this.lineFmt) {
                    System.out.println("ERROR: MML read failed");
                }
                this.exitStat = 1;
            }
            try {
                this.makePlan();
            }
            catch (Exception e) {
                this.process(e);
            }
            if (this.outXMML) {
                XMMLWriter xmml = new XMMLWriter(this.plan);
                xmml.write(System.out);
            }
            if (this.outGML != null) {
                try {
                    wrt = new XMLWriter();
                    Document doc = this.plan.getGraphML();
                    if (!Util.isBlank((String)this.outGML)) {
                        Element root = doc.getDocumentElement();
                        UtilXML.removeElementsExceptID((Element)root, (String)this.outGML);
                    }
                    wrt.write(doc, (OutputStream)System.out);
                }
                catch (Exception e) {
                    this.process(e);
                }
            }
            if (this.outJava) {
                try {
                    wrt = new JPlanWriter("JTest", this.plan);
                    ((JPlanWriter)wrt).setSourceLibs();
                    ((JPlanWriter)wrt).writePlan();
                }
                catch (Exception e) {
                    this.process(e);
                }
            }
            if (this.lineFmt) {
                if (this.plan != null) {
                    String stat;
                    String string = stat = this.plan.logger.nerrors() > 0 ? "FAIL" : "PASS";
                    if (this.plan.main() == null) {
                        this.boxStat = stat;
                    } else {
                        this.boxStat = "PASS";
                        this.seqStat = stat;
                    }
                    this.msgStat = this.plan.logger.errors.toString().replaceAll("\n", ";");
                }
                System.out.println(this.modFileName + " MOD=" + this.modStat + " BOX=" + this.boxStat + " SEQ=" + this.seqStat + " MSG=" + this.msgStat);
            }
            ++i;
        }
        System.exit(this.exitStat);
    }

    private void makePlan() throws Exception {
        if (this.mmlModel == null) {
            throw new Xcept("MML parsing failed");
        }
        this.plan = new Plan(this.mmlModel);
        this.plan.setVerbose(this.vtags);
        this.plan.setOptions(this.options);
        this.plan.logger.setSilent(this.lineFmt);
        this.plan.process();
    }

    private void process(Exception e) {
        if (!this.quiet) {
            e.printStackTrace();
        }
        this.exitStat = 1;
    }

    public static void main(String[] args) throws Exception {
        new PlanTest(args);
    }
}

