/*
 * Decompiled with CFR 0.152.
 */
package JSim.plan2;

import JSim.mml.Domain;
import JSim.mml.SubDom;
import JSim.mml.Var;
import JSim.mml.VarFuncCall;
import JSim.plan2.AbortXcept;
import JSim.plan2.DomainSet;
import JSim.plan2.TExpr;
import JSim.plan2.TModel;
import JSim.plan2.TSubDom;
import JSim.plan2.Tool;
import JSim.plan2.VarUsage;
import JSim.util.Expr;
import JSim.util.XFuncArg;
import JSim.util.XFuncCall;
import JSim.util.Xcept;
import java.util.Collection;

public class ProcTool
extends Tool {
    private XFuncCall fc;
    private TSubDom sdom;

    public ProcTool(TModel model, XFuncCall fc) throws Xcept {
        super(model);
        this.fc = fc;
        SubDom sd = new SubDom(fc.voidSD());
        this.sdom = new TSubDom(model, sd);
        for (int i = 0; i < fc.args().size(); ++i) {
            boolean isInput;
            XFuncArg arg = (XFuncArg)fc.args().get(i);
            boolean bl = isInput = i < fc.ninputs();
            if (isInput) {
                TExpr bexpr = new TExpr(model, arg.orig());
                this.vreqs.add(bexpr.usages());
                continue;
            }
            VarUsage vu = this.vsol(arg.base());
            if (vu == null) {
                throw new Xcept("Procedure call " + fc + ": illegal output argument #" + (i + 1));
            }
            this.vsols.add(vu);
        }
        if (!this.sdom.isEntire()) {
            this.vreqs = this.vreqs.restrict(this.sdom);
            this.vsols = this.vsols.restrict(this.sdom);
        }
    }

    private VarUsage vsol(Expr expr) throws Xcept {
        if (expr instanceof Var) {
            return new VarUsage(this.model, (Var)expr);
        }
        if (!(expr instanceof VarFuncCall)) {
            return null;
        }
        VarFuncCall vfc = (VarFuncCall)expr;
        Var v = vfc.v;
        Domain t = null;
        Var taux = null;
        for (int i = 0; i < v.ndim(); ++i) {
            Domain x;
            if (!(vfc.args.get(i) instanceof Var)) {
                return null;
            }
            Var vaux = (Var)((Object)vfc.args.get(i));
            if (vaux == (x = v.domain(i))) continue;
            if (vaux != x.vmin && vaux != x.vmax) {
                return null;
            }
            if (taux != null) {
                return null;
            }
            t = x;
            taux = vaux;
        }
        if (taux == null) {
            return null;
        }
        int stat = taux == t.vmin ? 2 : 3;
        return new VarUsage(this.model, v, stat, t);
    }

    protected void setSeqLoops() throws Xcept {
        XFuncArg arg0 = (XFuncArg)this.fc.args().get(this.fc.ninputs());
        this.seqLoops = this.seqLoops(arg0);
        for (int i = 0; i < this.fc.args().size(); ++i) {
            XFuncArg arg = (XFuncArg)this.fc.args().get(i);
            DomainSet loops = this.seqLoops(arg);
            boolean isInput = i < this.fc.ninputs();
            boolean ok = true;
            if (!isInput && !loops.equals(this.seqLoops)) {
                ok = false;
            }
            if (isInput && !this.seqLoops.containsAll(loops)) {
                ok = false;
            }
            if (ok) continue;
            throw new AbortXcept("Procedure call " + this.fc + " arguments " + arg0 + " and " + arg + " require incompatible domain loops");
        }
    }

    private DomainSet seqLoops(XFuncArg arg) throws Xcept {
        TExpr bexpr = new TExpr(this.model, arg.base());
        bexpr = bexpr.restrict(this.sdom);
        DomainSet loops = bexpr.usages().seqLoops();
        loops.removeAll((Collection<?>)arg.argDoms());
        return loops;
    }

    public String toString() {
        return "procedure " + this.fc;
    }

    public String toolType() {
        return "procedure";
    }

    public XFuncCall fc() {
        return this.fc;
    }

    public TSubDom sdom() {
        return this.sdom;
    }
}

