/*
 * Decompiled with CFR 0.152.
 */
package JSim.plan2;

import JSim.mml.Domain;
import JSim.mml.Var;
import JSim.plan2.DomainSet;
import JSim.plan2.Tool;
import JSim.plan2.VarUsage;
import JSim.plan2.VarUsages;
import JSim.util.Xcept;

public class QueryTool
extends Tool {
    protected VarUsage vu;

    public QueryTool(VarUsage vu) throws Xcept {
        super(vu.model());
        this.vsols.add(vu);
        this.vreqs.add(vu.v());
        this.vu = vu;
        this.setSeqLoops();
    }

    public QueryTool(VarUsage vu, VarUsage vreq) throws Xcept {
        this(vu);
        this.vreqs = new VarUsages(this.model);
        this.vreqs.add(vreq);
    }

    protected void setSeqLoops() throws Xcept {
        this.seqLoops = this.vu.seqLoops();
    }

    protected DomainSet safeSeqLoops() throws Xcept {
        DomainSet xs = new DomainSet();
        Var v = this.vu.v();
        for (int i = 0; i < v.ndim(); ++i) {
            Domain x = v.domain(i);
            switch (this.vu.qstat(x)) {
                case 1: 
                case 2: 
                case 4: {
                    xs.add(x);
                }
            }
        }
        return xs;
    }

    protected DomainSet delaySeqLoops() throws Xcept {
        DomainSet xs = new DomainSet();
        Var v = this.vu.v();
        for (int i = 0; i < v.ndim(); ++i) {
            Domain x = v.domain(i);
            switch (this.vu.qstat(x)) {
                case 1: 
                case 2: 
                case 4: 
                case 5: {
                    xs.add(x);
                }
            }
        }
        return xs;
    }

    protected boolean hasXexpr() throws Xcept {
        Var v = this.vu.v();
        for (int i = 0; i < v.ndim(); ++i) {
            Domain x = v.domain(i);
            if (this.vu.qstat(x) != 5) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return "query " + this.vsols;
    }

    public String toolType() {
        return "query";
    }
}

