/*
 * Decompiled with CFR 0.152.
 */
package JSim.plan2;

import JSim.mml.Domain;
import JSim.plan2.DomainSet;
import JSim.plan2.MuBlock;
import JSim.plan2.PDEBlock;
import JSim.plan2.SeqItem;
import JSim.plan2.TModel;
import JSim.plan2.VarUsages;
import JSim.util.Xcept;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SeqBlock
implements SeqItem {
    private TModel model;
    private ArrayList<SeqItem> items;
    protected DomainSet specDoms;

    public SeqBlock(TModel model) throws Xcept {
        this.model = model;
        this.items = new ArrayList();
        this.specDoms = new DomainSet();
    }

    public SeqBlock(SeqBlock parent) throws Xcept {
        this.model = parent.model;
        this.items = new ArrayList();
        this.specDoms = new DomainSet(parent.specDoms);
    }

    public void add(SeqItem item) {
        this.model.log("  adding " + item + " to " + this);
        this.items.add(item);
    }

    public void dump(PrintStream out) {
        PrintWriter wout = new PrintWriter(out, true);
        this.dump(wout);
    }

    public void dump(PrintWriter out) {
        this.dump(this, out, "");
    }

    public void dump(SeqBlock block, PrintWriter out, String indent) {
        String hdr = indent + block.title();
        if (block instanceof MuBlock) {
            hdr = hdr + " vmus=" + ((MuBlock)block).vmus;
        }
        out.println(hdr);
        indent = indent + "  ";
        if (indent.length() > 12) {
            out.println("DUMP ABORTED: TOO MANY INDENTS");
            return;
        }
        for (int i = 0; i < block.items.size(); ++i) {
            SeqItem item = block.items.get(i);
            if (item instanceof PDEBlock) {
                this.dumpPDE((PDEBlock)item, out, indent);
                continue;
            }
            if (item instanceof SeqBlock) {
                this.dump((SeqBlock)item, out, indent);
                continue;
            }
            out.println(indent + item);
        }
    }

    public void dumpPDE(PDEBlock block, PrintWriter out, String indent) {
        this.dump(block, out, indent);
        for (Domain x : block.xs) {
            this.dump(block.bcblock(x, true), out, indent + "  ");
            this.dump(block.bcblock(x, false), out, indent + "  ");
        }
    }

    public TModel model() {
        return this.model;
    }

    public String title() {
        return "untitled";
    }

    public String toString() {
        return this.title();
    }

    public ArrayList<SeqItem> items() {
        return this.items;
    }

    public int size() {
        return this.items.size();
    }

    @Override
    public Domain t() {
        return null;
    }

    @Override
    public VarUsages vreqs() {
        return null;
    }

    @Override
    public DomainSet seqLoops() {
        return null;
    }

    @Override
    public String nodeString() {
        return null;
    }

    public static class Loop
    extends SeqBlock {
        private Domain x;

        public Loop(SeqBlock parent, Domain x) throws Xcept {
            super(parent);
            this.x = x;
            this.specDoms.add(x);
        }

        public Domain x() {
            return this.x;
        }

        public String title() {
            return "loop-" + (Object)((Object)this.x);
        }
    }
}

