/*
 * Decompiled with CFR 0.152.
 */
package JSim.plan2;

import JSim.plan2.SeqEdge;
import JSim.plan2.SeqNode;
import JSim.plan2.SeqPhase;
import JSim.util.Xcept;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SeqGraph {
    private ArrayList<SeqPhase> phases = new ArrayList();
    private LinkedHashSet<SeqNode> nodes = new LinkedHashSet();
    private LinkedHashSet<SeqEdge> edges = new LinkedHashSet();
    private Hashtable<String, SeqNode> nodeNames = new Hashtable();
    private Hashtable<SeqNode, LinkedHashSet<SeqEdge>> edgesFromNode;
    private Hashtable<SeqNode, LinkedHashSet<SeqEdge>> edgesToNode;
    private Hashtable<SeqNode, SeqPhase> nodePhases = new Hashtable();
    private Hashtable<SeqPhase, LinkedHashSet<SeqNode>> phaseNodes = new Hashtable();
    private Hashtable<String, SeqPhase> phasesByName;
    private SeqPhase mainPhase;
    private String name;

    public SeqGraph() throws Xcept {
        this.edgesFromNode = new Hashtable();
        this.edgesToNode = new Hashtable();
        this.phasesByName = new Hashtable();
        this.mainPhase = new SeqPhase(this);
        this.add(this.mainPhase);
    }

    public SeqGraph(SeqGraph graph) throws Xcept {
        this();
        Hashtable<SeqPhase, SeqPhase> pmap = this.copyPhases(graph);
        Iterator<SeqNode> ns = graph.getNodes();
        while (ns.hasNext()) {
            SeqNode n = ns.next();
            SeqPhase p = graph.getPhase(n);
            SeqPhase np = pmap.get(p);
            this.add(n, np);
        }
        Iterator<SeqEdge> es = graph.getEdges();
        while (es.hasNext()) {
            this.add(es.next());
        }
    }

    protected Hashtable<SeqPhase, SeqPhase> copyPhases(SeqGraph g) throws Xcept {
        Hashtable<SeqPhase, SeqPhase> map = new Hashtable<SeqPhase, SeqPhase>();
        this.copyPhases(map, g.mainPhase(), this.mainPhase());
        return map;
    }

    private void copyPhases(Hashtable<SeqPhase, SeqPhase> map, SeqPhase ophase, SeqPhase nphase) throws Xcept {
        map.put(ophase, nphase);
        for (int i = 0; i < ophase.subphases.size(); ++i) {
            SeqPhase o1 = ophase.subphases.get(i);
            SeqPhase n1 = new SeqPhase(nphase, o1.x());
            this.add(n1);
            this.copyPhases(map, o1, n1);
        }
    }

    protected void setName(String name) {
        this.name = name;
    }

    protected void add(SeqPhase phase) {
        this.phases.add(phase);
        this.phasesByName.put(phase.name(), phase);
        if (this.phaseNodes.get(phase) == null) {
            this.phaseNodes.put(phase, new LinkedHashSet());
        }
    }

    protected void add(SeqNode node, SeqPhase phase) throws Xcept {
        String name = node.name();
        SeqNode onode = this.nodeNames.get(name);
        if (onode != null && onode != node) {
            throw new Xcept("Duplicate node name: " + name);
        }
        this.nodes.add(node);
        this.nodeNames.put(name, node);
        this.edgesFromNode.put(node, new LinkedHashSet());
        this.edgesToNode.put(node, new LinkedHashSet());
        this.setPhase(node, phase);
    }

    protected void add(SeqEdge edge) {
        this.edges.add(edge);
        this.edgesFromNode.get(edge.src()).add(edge);
        this.edgesToNode.get(edge.dest()).add(edge);
    }

    protected void remove(SeqEdge edge) {
        this.edges.remove(edge);
        this.edgesFromNode.get(edge.src()).remove(edge);
        this.edgesToNode.get(edge.dest()).remove(edge);
    }

    protected void remove(SeqNode node) {
        int i;
        ArrayList<SeqEdge> nedges = this.getEdgeArrayFrom(node);
        for (i = 0; i < nedges.size(); ++i) {
            this.remove(nedges.get(i));
        }
        nedges = this.getEdgeArrayTo(node);
        for (i = 0; i < nedges.size(); ++i) {
            this.remove(nedges.get(i));
        }
        this.nodes.remove(node);
        this.nodeNames.remove(node.name());
        this.edgesFromNode.remove(node);
        this.edgesToNode.remove(node);
        SeqPhase phase = this.nodePhases.get(node);
        this.nodePhases.remove(node);
        this.phaseNodes.get(phase).remove(node);
    }

    protected void setPhase(SeqNode node, SeqPhase phase) {
        SeqPhase ophase = this.nodePhases.get(node);
        if (ophase == phase) {
            return;
        }
        this.nodePhases.put(node, phase);
        if (ophase != null) {
            this.phaseNodes.get(ophase).remove(node);
        }
        this.phaseNodes.get(phase).add(node);
    }

    public String name() {
        return this.name;
    }

    public SeqPhase mainPhase() {
        return this.mainPhase;
    }

    public boolean contains(SeqNode node) {
        return this.nodes.contains(node);
    }

    public int nnodes() {
        return this.nodes.size();
    }

    public int nedges() {
        return this.edges.size();
    }

    public SeqNode getNode(String name) throws Xcept {
        SeqNode node;
        SeqNode seqNode = node = name == null ? null : this.nodeNames.get(name);
        if (node == null) {
            throw new Xcept("No node for name: " + name);
        }
        return node;
    }

    public Iterator<SeqNode> getNodes() {
        return this.nodes.iterator();
    }

    public boolean hasNode(SeqNode node) {
        return this.nodes.contains(node);
    }

    public Iterator<SeqEdge> getEdges() {
        return this.edges.iterator();
    }

    public boolean hasEdge(SeqEdge edge) {
        return this.edges.contains(edge);
    }

    public Iterator<SeqEdge> getEdgesFrom(SeqNode node) {
        LinkedHashSet<SeqEdge> es = this.edgesFromNode.get(node);
        if (es == null) {
            es = new LinkedHashSet();
        }
        return es.iterator();
    }

    public Iterator<SeqEdge> getEdgesTo(SeqNode node) {
        LinkedHashSet<SeqEdge> es = this.edgesToNode.get(node);
        if (es == null) {
            es = new LinkedHashSet();
        }
        return es.iterator();
    }

    public ArrayList<SeqNode> getNodeArray() {
        return new ArrayList<SeqNode>(this.nodes);
    }

    public ArrayList<SeqEdge> getEdgeArray() {
        return new ArrayList<SeqEdge>(this.edges);
    }

    public ArrayList<SeqEdge> getEdgeArrayFrom(SeqNode node) {
        return new ArrayList<SeqEdge>((Collection)this.edgesFromNode.get(node));
    }

    public ArrayList<SeqEdge> getEdgeArrayTo(SeqNode node) {
        return new ArrayList<SeqEdge>((Collection)this.edgesToNode.get(node));
    }

    public int nedgesFrom(SeqNode node) {
        return this.edgesFromNode.get(node).size();
    }

    public int nedgesTo(SeqNode node) {
        return this.edgesToNode.get(node).size();
    }

    public SeqEdge anyEdge() {
        return this.edges.size() > 0 ? this.getEdges().next() : null;
    }

    public SeqEdge anyEdgeFrom(SeqNode node) {
        Iterator<SeqEdge> edges = this.getEdgesFrom(node);
        return edges.hasNext() ? edges.next() : null;
    }

    public Iterator<SeqPhase> getPhases() {
        return this.phases.iterator();
    }

    public ArrayList<SeqPhase> getPhaseArray() {
        return new ArrayList<SeqPhase>(this.phases);
    }

    public boolean hasPhase(SeqPhase phase) {
        return this.phases.contains(phase);
    }

    public SeqPhase getPhase(SeqNode node) {
        return this.nodePhases.get(node);
    }

    public SeqPhase getPhase(String name) {
        return this.phasesByName.get(name);
    }

    public Iterator<SeqNode> getPhaseNodes(SeqPhase phase) {
        return this.phaseNodes.get(phase).iterator();
    }

    public ArrayList<SeqNode> getPhaseNodeArray(SeqPhase phase) {
        return new ArrayList<SeqNode>((Collection)this.phaseNodes.get(phase));
    }

    protected int phaseNodesSize() {
        return this.phaseNodes.size();
    }
}

