/*
 * Decompiled with CFR 0.152.
 */
package JSim.plan2;

import JSim.plan2.SeqEdge;
import JSim.plan2.SeqGraph;
import JSim.plan2.SeqNode;
import JSim.plan2.SeqPath;
import JSim.util.Xcept;
import java.util.ArrayList;
import java.util.Iterator;

public class SeqGraphCirc
extends SeqGraph {
    public SeqGraphCirc() throws Xcept {
    }

    public SeqGraphCirc(SeqGraph graph) throws Xcept {
        super(graph);
    }

    protected void removeFeedFwdNodes() {
        ArrayList<SeqNode> nodes = this.getNodeArray();
        for (int i = 0; i < nodes.size(); ++i) {
            SeqNode node = nodes.get(i);
            if (node.deT() == null) continue;
            this.remove(node);
        }
    }

    protected void removeDeadEnds() {
        boolean working = true;
        while (working) {
            working = false;
            ArrayList<SeqNode> nodes = this.getNodeArray();
            for (int i = 0; i < nodes.size(); ++i) {
                SeqNode node = nodes.get(i);
                if (this.nedgesFrom(node) > 0 && this.nedgesTo(node) > 0) continue;
                this.remove(node);
                working = true;
            }
        }
    }

    protected void minimize() throws Xcept {
        this.removeDeadEnds();
        SeqNode node;
        while ((node = this.maxSrcNode()) != null) {
            SeqEdge edge;
            int i;
            ArrayList<SeqEdge> edges = this.getEdgeArrayFrom(node);
            if (edges.size() < 2) {
                return;
            }
            SeqPath path = null;
            int inx = 0;
            for (i = 0; i < edges.size(); ++i) {
                edge = edges.get(i);
                SeqPath p = this.anyCircPath(edge);
                if (path != null && p.nedges() >= path.nedges()) continue;
                path = p;
                inx = i;
            }
            if (path == null) {
                return;
            }
            for (i = 0; i < edges.size(); ++i) {
                if (i == inx) continue;
                edge = edges.get(i);
                this.remove(edge);
            }
            this.removeDeadEnds();
        }
        return;
    }

    protected SeqPath anyCircPath() throws Xcept {
        this.removeDeadEnds();
        return this.anyCircPath(this.anyEdge());
    }

    protected SeqPath anyCircPath(SeqEdge edge) throws Xcept {
        SeqPath path = new SeqPath();
        while (edge != null && !path.hasCirc()) {
            path.add(edge);
            edge = this.anyEdgeFrom(edge.dest());
        }
        return path.minCirc();
    }

    private SeqNode maxSrcNode() {
        SeqNode node = null;
        int ct = 0;
        Iterator<SeqNode> nodes = this.getNodes();
        while (nodes.hasNext()) {
            SeqNode n = nodes.next();
            int nct = this.nedgesFrom(n);
            if (node != null && nct <= ct) continue;
            node = n;
            ct = nct;
        }
        return ct > 0 ? node : null;
    }
}

