/*
 * Decompiled with CFR 0.152.
 */
package JSim.plan2;

import JSim.plan2.ImplicitBound;
import JSim.plan2.MainBlock;
import JSim.plan2.Plan;
import JSim.plan2.PlanGraphML;
import JSim.plan2.SeqEdge;
import JSim.plan2.SeqGraph;
import JSim.plan2.SeqItem;
import JSim.plan2.SeqNode;
import JSim.plan2.SeqPhase;
import JSim.plan2.TEvent;
import JSim.plan2.TRelation;
import JSim.plan2.Tool;
import JSim.util.Util;
import JSim.util.Xcept;
import java.util.Iterator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SeqGraphMLNested {
    private PlanGraphML gml;
    private Plan plan;

    public SeqGraphMLNested(PlanGraphML gml) throws Xcept {
        this.gml = gml;
        this.plan = gml.plan;
    }

    protected void loadGraphs(Document doc) throws Xcept {
        if (this.main() == null) {
            return;
        }
        SeqGraph sgraph = this.main().untangledGraph();
        if (sgraph != null) {
            this.loadGraph(doc, sgraph, "sequence");
        }
    }

    protected void loadGraph(Document doc, SeqGraph seqGraph, String name) throws Xcept {
        Element g = this.gml.addGraph(doc.getDocumentElement(), name);
        this.addNodeKeys(g);
        this.loadNodes(g, seqGraph, seqGraph.mainPhase());
        Iterator<SeqEdge> edges = seqGraph.getEdges();
        while (edges.hasNext()) {
            SeqEdge edge = edges.next();
            SeqItem item1 = this.nodeItem(edge.src());
            SeqItem item2 = this.nodeItem(edge.dest());
            this.gml.addEdge(g, this.id(item1), this.id(item2));
        }
    }

    private void addNodeKeys(Element g) {
        this.gml.addNodeKey(g, "name");
        this.gml.addNodeKey(g, "itemType");
        this.gml.addNodeKey(g, "itemText");
        this.gml.addNodeKey(g, "deT");
    }

    private void loadNodes(Element g, SeqGraph graph, SeqPhase phase) throws Xcept {
        Iterator<SeqNode> nodes = graph.getPhaseNodes(phase);
        while (nodes.hasNext()) {
            SeqNode node = nodes.next();
            this.addItemNode(g, node);
        }
        for (int i = 0; i < phase.subphases.size(); ++i) {
            SeqPhase sphase = phase.subphases.get(i);
            Element pe = this.gml.addNode(g, this.id(sphase), sphase.name());
            this.gml.addData(pe, "itemType", "phase");
            this.gml.addData(pe, "deT", sphase.x());
            Element pge = this.gml.addGraph(pe, this.graphid(sphase));
            this.loadNodes(pge, graph, sphase);
        }
    }

    private Element addItemNode(Element g, SeqNode node) throws Xcept {
        SeqItem item = this.nodeItem(node);
        String id = this.id(item);
        Element e = this.gml.addNode(g, id, item.nodeString());
        String itemType = "unknown";
        if (item instanceof ImplicitBound) {
            itemType = "implicitBound";
        } else if (item instanceof TEvent) {
            itemType = "event";
        } else if (item instanceof TRelation) {
            itemType = "relation";
        } else if (item instanceof Tool) {
            itemType = ((Tool)item).toolType();
        }
        this.gml.addData(e, "itemType", itemType);
        this.gml.addData(e, "itemText", item.toString());
        String deT = node.deT();
        if (!Util.isBlank((String)deT)) {
            this.gml.addData(e, "deT", deT);
        }
        return e;
    }

    private String id(SeqPhase phase) {
        return "SID#PHASE#" + phase.name();
    }

    private String graphid(SeqPhase phase) {
        return "SID#GRAPH#" + phase.name();
    }

    private String id(SeqItem item) {
        return "SID#" + item.nodeString();
    }

    public MainBlock main() {
        return this.plan.main();
    }

    public SeqItem nodeItem(SeqNode node) throws Xcept {
        SeqItem item = this.main().nodeItems().get(node);
        if (item == null) {
            throw new Xcept("No item for node: " + node);
        }
        return item;
    }
}

