/*
 * Decompiled with CFR 0.152.
 */
package JSim.plan2;

import JSim.plan2.SeqEdge;
import JSim.plan2.SeqGraph;
import JSim.plan2.SeqNode;
import JSim.plan2.SeqPhase;
import JSim.util.Xcept;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SeqGraphXcons {
    private SeqGraph graph;
    private LinkedHashSet<SeqNode> startNodes;
    private LinkedHashSet<SeqNode> stopNodes;
    private boolean stopAtDeTs;
    private Hashtable<SeqNode, LinkedHashSet<SeqNode>> nodeDests;

    public SeqGraphXcons(SeqGraph graph, LinkedHashSet<SeqNode> startNodes, LinkedHashSet<SeqNode> stopNodes, boolean stopAtDeTs) throws Xcept {
        this.graph = graph;
        this.startNodes = startNodes;
        this.stopNodes = stopNodes;
        this.stopAtDeTs = stopAtDeTs;
        System.err.println("SeqGraphXCons stopAtDeTs=" + stopAtDeTs);
        this.nodeDests = new Hashtable();
        for (SeqNode n : startNodes) {
            SeqPhase p = graph.getPhase(n);
            this.initNodeDests(p, n);
        }
        System.err.println("  nodeDests=" + this.nodeDests);
    }

    private void initNodeDests(SeqPhase phase, SeqNode n) throws Xcept {
        if (this.nodeDests.get(n) != null) {
            return;
        }
        if (this.stopAtDeTs && n.deT() != null) {
            return;
        }
        LinkedHashSet<SeqNode> dests = new LinkedHashSet<SeqNode>();
        this.nodeDests.put(n, dests);
        Iterator<SeqEdge> es = this.graph.getEdgesFrom(n);
        while (es.hasNext()) {
            SeqEdge e = es.next();
            SeqNode n1 = e.dest();
            dests.add(n1);
            if (phase != this.graph.getPhase(n1) || this.stopAtDeTs && n1.deT() != null) continue;
            this.initNodeDests(phase, n1);
        }
    }
}

