/*
 * Decompiled with CFR 0.152.
 */
package JSim.plan2;

import JSim.plan2.SeqEdge;
import JSim.plan2.SeqGraph;
import JSim.plan2.SeqNode;
import JSim.plan2.SeqPhase;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.StringTokenizer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class SeqIO {
    public static SeqGraph read(File file) throws Exception {
        String line;
        SeqGraph graph = new SeqGraph();
        BufferedReader rdr = new BufferedReader(new FileReader(file));
        SeqPhase phase = graph.mainPhase();
        while ((line = rdr.readLine()) != null) {
            String tok;
            StringTokenizer stok = new StringTokenizer(line);
            if (!stok.hasMoreTokens() || (tok = stok.nextToken()) == null || tok.startsWith("//")) continue;
            if (tok.equals("phase")) {
                String x = stok.nextToken();
                phase = new SeqPhase(phase, x);
                continue;
            }
            if (tok.equals("endphase")) {
                phase = phase.parent();
                continue;
            }
            if (tok.equals("nodes")) {
                while (stok.hasMoreTokens()) {
                    SeqNode node = new SeqNode(stok.nextToken());
                    node.setLoops(phase.loopSet());
                    graph.add(node, phase);
                }
                continue;
            }
            if (tok.equals("feedfwd")) {
                String deT = stok.nextToken();
                while (stok.hasMoreTokens()) {
                    SeqNode node = graph.getNode(stok.nextToken());
                    node.setDeT(deT);
                }
                continue;
            }
            if (tok.equals("edge")) {
                SeqNode src = graph.getNode(stok.nextToken());
                SeqNode dest = graph.getNode(stok.nextToken());
                SeqEdge edge = new SeqEdge(src, dest);
                graph.add(edge);
                continue;
            }
            throw new Exception("Unrecognized graph keyword: " + tok);
        }
        return graph;
    }

    public static void write(SeqGraph graph, PrintStream out) {
        PrintWriter wout = new PrintWriter(out, true);
        SeqIO.write(graph, wout);
    }

    public static void write(SeqGraph graph, PrintWriter out) {
        LinkedHashSet<SeqNode> tnodes;
        String t;
        SeqIO.write(graph, graph.mainPhase(), out);
        Hashtable<String, LinkedHashSet<SeqNode>> deTs = new Hashtable<String, LinkedHashSet<SeqNode>>();
        Iterator<SeqNode> nodes = graph.getNodes();
        while (nodes.hasNext()) {
            SeqNode node = nodes.next();
            t = node.deT();
            if (t == null) continue;
            tnodes = (LinkedHashSet<SeqNode>)deTs.get(t);
            if (tnodes == null) {
                tnodes = new LinkedHashSet<SeqNode>();
                deTs.put(t, tnodes);
            }
            tnodes.add(node);
        }
        Enumeration ts = deTs.keys();
        while (ts.hasMoreElements()) {
            t = (String)ts.nextElement();
            out.print("feedfwd " + t);
            tnodes = ((LinkedHashSet)deTs.get(t)).iterator();
            while (tnodes.hasNext()) {
                out.print(" " + tnodes.next());
            }
            out.println("");
        }
        Iterator<SeqEdge> edges = graph.getEdges();
        while (edges.hasNext()) {
            SeqEdge edge = edges.next();
            out.println("edge " + edge.src() + " " + edge.dest());
        }
    }

    public static void write(SeqGraph graph, SeqPhase phase, PrintWriter out) {
        if (phase.x() != null) {
            out.println("phase " + phase.x());
        }
        Iterator<SeqNode> nodes = graph.getPhaseNodes(phase);
        out.print("nodes");
        while (nodes.hasNext()) {
            out.print(" " + nodes.next());
        }
        out.println("");
        for (int i = 0; i < phase.subphases.size(); ++i) {
            SeqIO.write(graph, phase.subphases.get(i), out);
        }
        if (phase.x() != null) {
            out.println("endphase");
        }
    }

    public static void writeNodes(SeqGraph graph, PrintWriter out) {
        SeqIO.write(graph, graph.mainPhase(), out);
    }

    public static void writeNodes(SeqGraph graph, PrintStream out) {
        PrintWriter wout = new PrintWriter(out, true);
        SeqIO.write(graph, graph.mainPhase(), wout);
    }

    private static void addData(Document doc, Element node, String key, String value) {
        if (value == null) {
            value = "";
        }
        Element e = doc.createElement("data");
        e.setAttribute("key", key);
        Text text = doc.createTextNode(value);
        e.appendChild(text);
        node.appendChild(e);
    }

    public static void dumpEdges(SeqGraph graph, PrintStream out) {
        Iterator<SeqEdge> edges = graph.getEdges();
        while (edges.hasNext()) {
            SeqEdge edge = edges.next();
            out.println("  " + edge);
        }
    }

    public static void dumpEdgesByNode(SeqGraph graph, PrintStream out) {
        Iterator<SeqNode> nodes = graph.getNodes();
        while (nodes.hasNext()) {
            SeqNode node = nodes.next();
            out.println("node " + node.name() + " #from=" + graph.nedgesFrom(node) + " #to=" + graph.nedgesTo(node));
            Iterator<SeqEdge> edges = graph.getEdgesFrom(node);
            while (edges.hasNext()) {
                out.println("  " + edges.next());
            }
            edges = graph.getEdgesTo(node);
            while (edges.hasNext()) {
                out.println("  " + edges.next());
            }
        }
    }
}

