/*
 * Decompiled with CFR 0.152.
 */
package JSim.plan2;

import JSim.plan2.SeqEdge;
import JSim.plan2.SeqNode;
import JSim.plan2.SeqPhase;
import JSim.util.Xcept;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SeqPath {
    private ArrayList<SeqEdge> edges;
    private LinkedHashSet<SeqNode> nodeSet;
    private LinkedHashSet<String> nodeDeTs;
    private LinkedHashSet<String> phaseCrosses;
    private boolean hasCirc;
    private LinkedHashSet<SeqPhase> phaseSet;

    public SeqPath() {
        this.edges = new ArrayList();
        this.nodeSet = new LinkedHashSet();
        this.nodeDeTs = new LinkedHashSet();
        this.phaseCrosses = new LinkedHashSet();
    }

    public SeqPath(SeqPath path, SeqEdge edge) throws Xcept {
        this.edges = new ArrayList<SeqEdge>(path.edges);
        this.nodeSet = new LinkedHashSet<SeqNode>(path.nodeSet);
        this.nodeDeTs = new LinkedHashSet<String>(path.nodeDeTs);
        this.phaseCrosses = new LinkedHashSet<String>(path.phaseCrosses);
        if (path.phaseSet != null) {
            this.phaseSet = new LinkedHashSet<SeqPhase>(path.phaseSet);
        }
        this.hasCirc = path.hasCirc;
        this.add(edge);
    }

    protected void addPhase(SeqPhase phase) {
        if (this.phaseSet == null) {
            this.phaseSet = new LinkedHashSet();
        }
        this.phaseSet.add(phase);
    }

    protected boolean contains(SeqPhase phase) {
        return this.phaseSet.contains(phase);
    }

    protected void addDeTs(Collection<String> dets) {
        this.nodeDeTs.addAll(dets);
    }

    protected String ustring() {
        return this.toString() + " deTs=" + this.nodeDeTs + " xphases=" + this.phaseCrosses;
    }

    public void add(SeqEdge edge) throws Xcept {
        SeqNode node = edge.src();
        if (this.edges.size() == 0) {
            this.addNode(node);
        } else if (this.lastNode() != node) {
            throw new Xcept("Edge " + edge + " discontinuous with path " + this);
        }
        node = edge.dest();
        if (this.nodeSet.contains(node)) {
            this.hasCirc = true;
        }
        this.edges.add(edge);
        this.addNode(node);
    }

    private void addNode(SeqNode node) {
        this.nodeSet.add(node);
        if (node.deT() != null) {
            this.nodeDeTs.add(node.deT());
        }
    }

    protected void addPhaseCross(String x) {
        this.phaseCrosses.add(x);
    }

    protected void addPhaseCrosses(Collection<String> xs) {
        this.phaseCrosses.addAll(xs);
    }

    public SeqPath minCirc() throws Xcept {
        int i;
        if (!this.hasCirc) {
            return null;
        }
        SeqNode lnode = this.lastNode();
        if (this.firstNode() == lnode) {
            return this;
        }
        for (i = 0; i < this.edges.size() && this.edges.get(i).src() != lnode; ++i) {
        }
        if (i >= this.edges.size()) {
            throw new Xcept("minCirc: Path " + this + " does not contain node " + lnode);
        }
        SeqPath path = new SeqPath();
        while (i < this.edges.size()) {
            path.add(this.edges.get(i++));
        }
        return path;
    }

    public boolean phaseCrossesDeT() {
        for (String deT : this.nodeDeTs) {
            if (!this.phaseCrosses.contains(deT)) continue;
            return true;
        }
        return false;
    }

    public boolean hasDeTWithoutPhaseCross() {
        for (String deT : this.nodeDeTs) {
            if (this.phaseCrosses.contains(deT)) continue;
            return true;
        }
        return false;
    }

    public boolean hasDeTWithoutPhaseCross2() {
        return !this.phaseCrosses.containsAll(this.nodeDeTs);
    }

    public int nedges() {
        return this.edges.size();
    }

    public SeqEdge edge(int i) {
        return this.edges.get(i);
    }

    public boolean contains(SeqNode node) {
        return this.nodeSet.contains(node);
    }

    public boolean hasCirc() {
        return this.hasCirc;
    }

    public boolean crosses(String x) {
        if (this.phaseCrosses == null) {
            return false;
        }
        return this.phaseCrosses.contains(x);
    }

    public LinkedHashSet<String> phaseCrosses() {
        return this.phaseCrosses;
    }

    public LinkedHashSet<String> nodeDeTs() {
        return this.nodeDeTs;
    }

    public Iterator<SeqNode> getNodes() {
        return this.nodeSet.iterator();
    }

    public SeqNode firstNode() {
        if (this.edges.size() == 0) {
            return null;
        }
        return this.edges.get(0).src();
    }

    public SeqNode lastNode() {
        if (this.edges.size() == 0) {
            return null;
        }
        return this.edges.get(this.edges.size() - 1).dest();
    }

    public SeqEdge lastEdge() {
        if (this.edges.size() == 0) {
            return null;
        }
        return this.edges.get(this.edges.size() - 1);
    }

    public SeqNode nextToLastNode() {
        if (this.edges.size() == 0) {
            return null;
        }
        return this.edges.get(this.edges.size() - 1).src();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("[");
        for (int i = 0; i < this.edges.size(); ++i) {
            SeqEdge edge = this.edges.get(i);
            if (i == 0) {
                this.appendNode(buf, edge.src());
            }
            buf.append(",");
            this.appendNode(buf, edge.dest());
        }
        buf.append("]");
        return buf.toString();
    }

    private void appendNode(StringBuffer buf, SeqNode node) {
        String name = node.toString();
        if (name.indexOf(44) >= 0) {
            name = '(' + name + ")";
        }
        buf.append(name);
    }
}

