/*
 * Decompiled with CFR 0.152.
 */
package JSim.plan2;

import JSim.plan2.SeqGraph;
import JSim.util.Xcept;
import java.util.ArrayList;
import java.util.LinkedHashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SeqPhase {
    private SeqGraph graph;
    private SeqPhase parent;
    private String x;
    private int sfx;
    private ArrayList<String> loops;
    protected ArrayList<SeqPhase> subphases;
    private int ginx;

    public SeqPhase(SeqGraph graph) throws Xcept {
        this.graph = graph;
        this.common();
    }

    public SeqPhase(SeqPhase parent, String x) throws Xcept {
        this.graph = parent.graph;
        this.parent = parent;
        this.x = x;
        if (x == null) {
            throw new Xcept("SeqPhase constructor: x=null");
        }
        this.common();
    }

    public SeqPhase(SeqGraph graph, SeqPhase parent, String x) throws Xcept {
        this.graph = graph;
        this.parent = parent;
        this.x = x;
        this.common();
    }

    private void common() throws Xcept {
        this.loops = new ArrayList();
        this.subphases = new ArrayList();
        this.ginx = this.graph.phaseNodesSize();
        if (this.x != null) {
            if (this.parent.loops.contains(this.x)) {
                throw new Xcept("Phase " + this.parent + " already contains loop " + this.x);
            }
            this.loops.addAll(this.parent.loops());
            this.loops.add(this.x);
            this.parent.subphases.add(this);
            this.sfx = this.parent.newChildSfx(this.x);
        }
        this.graph.add(this);
    }

    private int newChildSfx(String x) {
        int newSfx = -1;
        for (int i = 0; i < this.subphases.size(); ++i) {
            SeqPhase p = this.subphases.get(i);
            if (!x.equals(p.x) || p.sfx <= newSfx) continue;
            newSfx = p.sfx;
        }
        return newSfx + 1;
    }

    public SeqGraph graph() {
        return this.graph;
    }

    public boolean isMain() {
        return this.parent == null;
    }

    public SeqPhase parent() {
        return this.parent;
    }

    public SeqPhase main() {
        return this.isMain() ? this : this.parent().main();
    }

    public String x() {
        return this.x;
    }

    public ArrayList<String> loops() {
        return this.loops;
    }

    public LinkedHashSet<String> loopSet() {
        return new LinkedHashSet<String>(this.loops);
    }

    public boolean contains(SeqPhase phase) {
        if (phase == this) {
            return true;
        }
        for (int i = 0; i < this.subphases.size(); ++i) {
            if (!this.subphases.get(i).contains(phase)) continue;
            return true;
        }
        return false;
    }

    public String name() {
        if (this.isMain()) {
            return "main";
        }
        if (this.parent.parent == null) {
            return this.localName();
        }
        return this.parent.name() + '+' + this.localName();
    }

    public String localName() {
        if (this.sfx == 0) {
            return this.x;
        }
        return this.x + "#" + this.sfx;
    }

    public String toString() {
        return this.name();
    }

    public int ginx() {
        return this.ginx;
    }

    public SeqPhase commonAncestor(SeqPhase phase) throws Xcept {
        if (this.graph != phase.graph()) {
            throw new Xcept("SeqPhase.commonAncestor: phases have different graphs");
        }
        if (this.contains(phase)) {
            return this;
        }
        return this.parent.commonAncestor(phase);
    }

    protected SeqPhase anySubphase(String x) throws Xcept {
        for (int i = 0; i < this.subphases.size(); ++i) {
            SeqPhase s = this.subphases.get(i);
            if (!s.x.equals(x)) continue;
            return s;
        }
        throw new Xcept("No subphase " + x + " of " + this);
    }
}

