/*
 * Decompiled with CFR 0.152.
 */
package JSim.plan2;

import JSim.plan2.SeqEdge;
import JSim.plan2.SeqGraph;
import JSim.plan2.SeqGraphCirc;
import JSim.plan2.SeqNode;
import JSim.plan2.SeqPhase;
import JSim.util.Xcept;
import java.util.Hashtable;
import java.util.Iterator;

public class SeqPhaseReducer
extends SeqGraphCirc {
    private SeqGraph parent;
    private String t;
    private Hashtable<SeqPhase, SeqPhase> localPhases;
    private Hashtable<SeqPhase, SeqNode> localNodes;
    private Hashtable<SeqNode, SeqPhase> parentPhases;

    public SeqPhaseReducer(SeqGraph parent, String t) throws Xcept {
        this.parent = parent;
        this.t = t;
        this.localPhases = new Hashtable();
        this.localNodes = new Hashtable();
        this.parentPhases = new Hashtable();
        this.localPhases.put(parent.mainPhase(), this.mainPhase());
        this.addSubPhases(parent.mainPhase());
        Iterator<SeqNode> ns = parent.getNodes();
        while (ns.hasNext()) {
            SeqNode node = ns.next();
            String deT = node.deT();
            if (deT != null && !deT.equals(t)) continue;
            SeqPhase phase = parent.getPhase(node);
            if ((phase = this.localPhases.get(phase)) == null) continue;
            this.add(node, phase);
        }
        Iterator<SeqEdge> es = parent.getEdges();
        while (es.hasNext()) {
            SeqEdge edge = es.next();
            SeqNode nsrc = this.localNode(edge.src());
            SeqNode ndest = this.localNode(edge.dest());
            if (nsrc == null || ndest == null || nsrc == ndest) continue;
            if (nsrc == edge.src() && ndest == edge.dest()) {
                this.add(edge);
                continue;
            }
            this.add(new SeqEdge(nsrc, ndest));
        }
    }

    private void addSubPhases(SeqPhase phase) throws Xcept {
        for (int i = 0; i < phase.subphases.size(); ++i) {
            SeqPhase subphase = phase.subphases.get(i);
            if (subphase.x().equals(this.t)) {
                SeqNode node = new SeqNode("#" + subphase.name());
                this.add(node, this.localPhases.get(phase));
                this.addPhaseNode(subphase, node);
                continue;
            }
            SeqPhase nphase = new SeqPhase(this.localPhases.get(phase), subphase.x());
            this.localPhases.put(subphase, nphase);
            this.addSubPhases(subphase);
        }
    }

    private void addPhaseNode(SeqPhase phase, SeqNode node) throws Xcept {
        this.localNodes.put(phase, node);
        this.parentPhases.put(node, phase);
        for (int i = 0; i < phase.subphases.size(); ++i) {
            this.addPhaseNode(phase.subphases.get(i), node);
        }
    }

    private SeqNode localNode(SeqNode node) {
        if (node.deT() != null && !node.deT().equals(this.t)) {
            return null;
        }
        SeqPhase phase = this.parent.getPhase(node);
        SeqPhase nphase = this.localPhases.get(phase);
        if (nphase == null) {
            return this.localNodes.get(phase);
        }
        if (this.hasNode(node)) {
            return node;
        }
        return null;
    }

    public SeqGraph parent() {
        return this.parent;
    }

    public String t() {
        return this.t;
    }

    public boolean hasReducedNode(SeqPhase phase) throws Xcept {
        if (phase == null) {
            return false;
        }
        SeqNode n = this.localNodes.get(phase);
        if (n == null) {
            return false;
        }
        return this.hasNode(n);
    }
}

