/*
 * Decompiled with CFR 0.152.
 */
package JSim.plan2;

import JSim.plan2.SeqEdge;
import JSim.plan2.SeqGraph;
import JSim.plan2.SeqNode;
import JSim.plan2.SeqPhase;
import JSim.plan2.SeqPhaseReducer;
import JSim.util.Xcept;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SeqPullFinder
extends SeqGraph {
    private SeqPhaseReducer reducer;
    private SeqGraph orig;
    private String t;
    private Hashtable<SeqPhase, SeqPhase> phaseMap;
    private LinkedHashSet<SeqNode> entryNodes;
    private LinkedHashSet<SeqNode> exitNodes;
    private Hashtable<SeqNode, SeqPhase> entryTargetPhases;
    private Hashtable<SeqNode, LinkedHashSet<SeqNode>> nodePulls;
    private ArrayList<LinkedHashSet<SeqNode>> pullLists;
    private Hashtable<SeqNode, SeqPhase> pullMap;

    public SeqPullFinder(SeqPhaseReducer r) throws Xcept {
        this.reducer = r;
        this.orig = this.reducer.parent();
        this.t = this.reducer.t();
        this.phaseMap = this.copyPhases(this.orig);
        this.entryNodes = new LinkedHashSet();
        this.exitNodes = new LinkedHashSet();
        this.entryTargetPhases = new Hashtable();
        Iterator<SeqEdge> oedges = this.orig.getEdges();
        while (oedges.hasNext()) {
            SeqPhase t2;
            SeqEdge oedge = oedges.next();
            SeqNode n1 = oedge.src();
            SeqNode n2 = oedge.dest();
            SeqPhase p1 = this.orig.getPhase(n1);
            SeqPhase p2 = this.orig.getPhase(n2);
            SeqPhase t1 = this.tphase(p1);
            if (t1 == (t2 = this.tphase(p2)) && t1 != null || !this.reducerContains(n1, t1) || !this.reducerContains(n2, t2)) continue;
            if (!this.hasNode(n1)) {
                this.add(n1, this.phaseMap.get(p1));
            }
            if (!this.hasNode(n2)) {
                this.add(n2, this.phaseMap.get(p2));
            }
            this.add(oedge);
            if (t1 != null) {
                this.exitNodes.add(n1);
            }
            if (t2 == null) continue;
            this.entryNodes.add(n2);
            SeqPhase pt0 = this.entryTargetPhases.get(n2);
            SeqPhase pt1 = pt0 == null ? p1 : p1.commonAncestor(pt0);
            if (pt1 == pt0) continue;
            this.entryTargetPhases.put(n2, pt1);
        }
        this.createNodePulls();
        for (SeqNode enode : this.entryNodes) {
            LinkedHashSet<SeqNode> pnodes = this.nodePulls.get(enode);
            if (pnodes == null) continue;
            for (SeqNode pnode : pnodes) {
                if (!this.exitNodes.contains(pnode) || enode == pnode) continue;
                SeqEdge edge = new SeqEdge(enode, pnode);
                this.add(edge);
            }
        }
    }

    private void createNodePulls() throws Xcept {
        this.nodePulls = new Hashtable();
        this.pullLists = new ArrayList();
        for (SeqNode n : this.entryNodes) {
            if (this.isNonTIntegrator(n)) continue;
            this.initNodePulls(n, this.tphase(n));
        }
        boolean working = true;
        while (working) {
            working = false;
            for (int i = this.pullLists.size() - 1; i >= 0; --i) {
                LinkedHashSet<SeqNode> set = this.pullLists.get(i);
                LinkedHashSet<SeqNode> setadd = new LinkedHashSet<SeqNode>();
                for (SeqNode n : set) {
                    LinkedHashSet<SeqNode> nset = this.nodePulls.get(n);
                    if (set.containsAll(nset)) continue;
                    setadd.addAll(nset);
                    working = true;
                }
                set.addAll(setadd);
            }
        }
    }

    private void initNodePulls(SeqNode n, SeqPhase tphase) throws Xcept {
        if (this.nodePulls.get(n) != null) {
            return;
        }
        LinkedHashSet<SeqNode> pulls = new LinkedHashSet<SeqNode>();
        this.nodePulls.put(n, pulls);
        this.pullLists.add(pulls);
        Iterator<SeqEdge> nedges = this.orig.getEdgesFrom(n);
        while (nedges.hasNext()) {
            SeqNode n1 = nedges.next().dest();
            if (this.isNonTIntegrator(n1) || this.tphase(n1) != tphase) continue;
            pulls.add(n1);
            this.initNodePulls(n1, tphase);
        }
    }

    protected Hashtable<SeqNode, SeqPhase> getPullMap() throws Xcept {
        if (this.nodePulls == null) {
            throw new Xcept("nodePulls not available");
        }
        if (this.pullMap != null) {
            return this.pullMap;
        }
        this.pullMap = new Hashtable<SeqNode, SeqPhase>(this.entryTargetPhases);
        for (SeqNode en : this.entryNodes) {
            SeqPhase ephase = this.entryTargetPhases.get(en);
            if (this.nodePulls.get(en) == null) continue;
            for (SeqNode pn : this.nodePulls.get(en)) {
                SeqPhase p0 = this.pullMap.get(pn);
                SeqPhase p1 = p0 == null ? ephase : ephase.commonAncestor(p0);
                if (p1 == p0) continue;
                this.pullMap.put(pn, p1);
            }
        }
        return this.pullMap;
    }

    private SeqPhase tphase(SeqNode node) throws Xcept {
        return this.tphase(this.orig.getPhase(node));
    }

    private SeqPhase tphase(SeqPhase phase) throws Xcept {
        while (!(phase == null || phase.x() != null && phase.x().equals(this.t))) {
            phase = phase.parent();
        }
        return phase;
    }

    private boolean reducerContains(SeqNode n, SeqPhase phase) throws Xcept {
        return this.reducer.hasNode(n) || this.reducer.hasReducedNode(phase);
    }

    private boolean isNonTIntegrator(SeqNode n) {
        String deT = n.deT();
        return deT != null && !deT.equals(this.t);
    }
}

