/*
 * Decompiled with CFR 0.152.
 */
package JSim.plan2;

import JSim.plan2.Plan;
import JSim.plan2.SeqEdge;
import JSim.plan2.SeqGraph;
import JSim.plan2.SeqNode;
import JSim.plan2.SeqPath;
import JSim.plan2.SeqPhase;
import JSim.util.StringList;
import JSim.util.Xcept;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SeqPullFinder3
extends SeqGraph {
    private Plan plan;
    private LinkedHashSet<SeqNode> entryNodes;
    private LinkedHashSet<SeqNode> exitNodes;
    private LinkedHashSet<SeqEdge> exitEdges;
    private LinkedHashSet<SeqNode> deTNodes;
    private LinkedHashSet<String> deTs;
    private Hashtable<SeqNode, LinkedHashSet<SeqNode>> deTEntries;
    private Hashtable<SeqNode, LinkedHashSet<XEdge>> entryXEdges;
    private Hashtable<SeqNode, LinkedHashSet<XEdge>> entry2Exits;
    private ArrayList<SeqPath> pullPaths;
    private ArrayList<SeqPath> circPaths;
    private Hashtable<SeqNode, SeqPhase> pullMap;
    private Hashtable<SeqNode, String> pullMapTs;

    public SeqPullFinder3(SeqGraph graph, Plan plan) throws Xcept {
        super(graph);
        this.plan = plan;
        this.removeMainPhaseDeadEnds();
        this.buildNodeTables();
        this.buildXEdges1();
        Iterator xs = this.deTs.iterator();
        while (xs.hasNext()) {
            this.buildXEdges2((String)xs.next());
        }
        if (plan.hack() == 1) {
            this.buildXEdges3();
        }
        this.buildPullPaths();
        this.buildPullMap();
    }

    private void removeMainPhaseDeadEnds() throws Xcept {
        int ict = this.nnodes();
        boolean working = true;
        while (working) {
            working = false;
            ArrayList<SeqNode> ns = this.getPhaseNodeArray(this.mainPhase());
            for (int i = 0; i < ns.size(); ++i) {
                SeqNode n = ns.get(i);
                if (this.nedgesFrom(n) > 0 && this.nedgesTo(n) > 0) continue;
                this.remove(n);
                working = true;
            }
        }
    }

    private void buildNodeTables() throws Xcept {
        this.entryNodes = new LinkedHashSet();
        this.exitNodes = new LinkedHashSet();
        this.exitEdges = new LinkedHashSet();
        Iterator<SeqEdge> es = this.getEdges();
        while (es.hasNext()) {
            SeqEdge e = es.next();
            if (this.getPhase(e.src()) == this.getPhase(e.dest())) continue;
            this.exitNodes.add(e.src());
            this.entryNodes.add(e.dest());
            this.exitEdges.add(e);
        }
    }

    private void buildXEdges1() throws Xcept {
        this.entryXEdges = new Hashtable();
        this.entry2Exits = new Hashtable();
        this.deTs = new LinkedHashSet();
        this.deTNodes = new LinkedHashSet();
        this.deTEntries = new Hashtable();
        Hashtable nodeEntries = new Hashtable();
        for (SeqNode en : this.entryNodes) {
            LinkedHashSet<SeqNode> entries = new LinkedHashSet<SeqNode>();
            entries.add(en);
            nodeEntries.put(en, entries);
        }
        LinkedHashSet<SeqNode> dirtyNodes = new LinkedHashSet<SeqNode>(this.entryNodes);
        while (dirtyNodes.size() > 0) {
            Iterator dns = dirtyNodes.iterator();
            dirtyNodes = new LinkedHashSet();
            while (dns.hasNext()) {
                SeqNode dn = (SeqNode)dns.next();
                LinkedHashSet dnentries = (LinkedHashSet)nodeEntries.get(dn);
                if (dn.deT() != null) {
                    if (!this.deTNodes.add(dn)) continue;
                    this.deTs.add(dn.deT());
                    this.deTEntries.put(dn, dnentries);
                    continue;
                }
                SeqPhase dp = this.getPhase(dn);
                Iterator<SeqEdge> es = this.getEdgesFrom(dn);
                while (es.hasNext()) {
                    LinkedHashSet nentries;
                    SeqNode n = es.next().dest();
                    SeqPhase p = this.getPhase(n);
                    if (p != dp) {
                        this.addXEdges(this.entryXEdges, dnentries, n, null);
                        continue;
                    }
                    if (this.exitNodes.contains(n)) {
                        this.addXEdges(this.entry2Exits, dnentries, n, null);
                    }
                    if ((nentries = (LinkedHashSet)nodeEntries.get(n)) == null) {
                        nentries = new LinkedHashSet();
                        nodeEntries.put(n, nentries);
                    }
                    if (!nentries.addAll(dnentries)) continue;
                    dirtyNodes.add(n);
                }
            }
        }
    }

    private void buildXEdges2(String x) throws Xcept {
        Hashtable nodeEntries = new Hashtable();
        LinkedHashSet<SeqNode> dirtyNodes = new LinkedHashSet<SeqNode>();
        for (SeqNode en : this.deTNodes) {
            if (!en.deT().equals(x)) continue;
            dirtyNodes.add(en);
            LinkedHashSet<SeqNode> entries = this.deTEntries.get(en);
            entries.add(en);
            nodeEntries.put(en, entries);
        }
        while (dirtyNodes.size() > 0) {
            Iterator dns = dirtyNodes.iterator();
            dirtyNodes = new LinkedHashSet();
            while (dns.hasNext()) {
                SeqNode dn = (SeqNode)dns.next();
                String dnx = dn.deT();
                if (dnx != null && !dnx.equals(x)) continue;
                SeqPhase dp = this.getPhase(dn);
                LinkedHashSet dnentries = (LinkedHashSet)nodeEntries.get(dn);
                Iterator<SeqEdge> es = this.getEdgesFrom(dn);
                while (es.hasNext()) {
                    LinkedHashSet nentries;
                    SeqNode n = es.next().dest();
                    SeqPhase p = this.getPhase(n);
                    if (p != dp) {
                        this.addXEdges(this.entryXEdges, dnentries, n, x);
                        continue;
                    }
                    if (this.exitNodes.contains(n)) {
                        this.addXEdges(this.entry2Exits, dnentries, n, x);
                    }
                    if ((nentries = (LinkedHashSet)nodeEntries.get(n)) == null) {
                        nentries = new LinkedHashSet();
                        nodeEntries.put(n, nentries);
                    }
                    if (!nentries.addAll(dnentries)) continue;
                    dirtyNodes.add(n);
                }
            }
        }
    }

    private void buildXEdges3() throws Xcept {
        Hashtable<SeqPhase, LinkedHashSet<SeqNode>> phaseDests = new Hashtable<SeqPhase, LinkedHashSet<SeqNode>>();
        for (SeqEdge e : this.exitEdges) {
            SeqPhase pdest;
            SeqPhase psrc = this.getPhase(e.src());
            if (psrc.contains(pdest = this.getPhase(e.dest()))) continue;
            LinkedHashSet<SeqNode> pdests = (LinkedHashSet<SeqNode>)phaseDests.get(psrc);
            if (pdests == null) {
                pdests = new LinkedHashSet<SeqNode>();
                phaseDests.put(psrc, pdests);
            }
            pdests.add(e.dest());
        }
        for (SeqNode n1 : this.entryNodes) {
            LinkedHashSet n2s;
            SeqPhase p = this.getPhase(n1);
            if (this.hasXEdge(p) || (n2s = (LinkedHashSet)phaseDests.get(p)) == null) continue;
            ArrayList<SeqNode> ln1 = new ArrayList<SeqNode>();
            ln1.add(n1);
            for (SeqNode n2 : n2s) {
                String deT = n1.deT();
                if (deT == null) {
                    deT = n2.deT();
                }
                this.addXEdges(this.entryXEdges, ln1, n2, deT);
            }
        }
    }

    private boolean hasXEdge(SeqPhase p) throws Xcept {
        Iterator<SeqNode> ns = this.getPhaseNodes(p);
        while (ns.hasNext()) {
            SeqNode n = ns.next();
            if (this.entryXEdges.get(n) == null) continue;
            return true;
        }
        return false;
    }

    private void addXEdges(Hashtable<SeqNode, LinkedHashSet<XEdge>> map, Collection<SeqNode> n1s, SeqNode n2, String x) throws Xcept {
        for (SeqNode n1 : n1s) {
            if (!this.entryNodes.contains(n1) || n1 == n2) continue;
            XEdge xedge = new XEdge(n1, n2, x);
            LinkedHashSet<XEdge> xedges = map.get(n1);
            if (xedges == null) {
                xedges = new LinkedHashSet();
                map.put(n1, xedges);
            }
            xedges.add(xedge);
        }
    }

    private void buildPullPaths() throws Xcept {
        this.pullPaths = new ArrayList();
        for (SeqNode n : this.exitNodes) {
            SeqPhase p = this.getPhase(n);
            if (p == this.mainPhase()) continue;
            Iterator<SeqEdge> es = this.getEdgesFrom(n);
            while (es.hasNext()) {
                SeqEdge e = es.next();
                SeqPhase p1 = this.getPhase(e.dest());
                if (p == p1 || p.contains(p1)) continue;
                SeqPhase pr = this.reentryPhase(e);
                SeqPath path = new SeqPath();
                path.add(e);
                path.addPhase(p1);
                this.growReentryPath(pr, path);
            }
        }
    }

    private SeqPhase reentryPhase(SeqEdge e) throws Xcept {
        SeqPhase p1 = this.getPhase(e.src());
        SeqPhase p2 = this.getPhase(e.dest());
        SeqPhase pca = p1.commonAncestor(p2);
        while (p1.parent() != pca) {
            p1 = p1.parent();
        }
        return p1;
    }

    private void growReentryPath(SeqPhase phase, SeqPath path) throws Xcept {
        Collection cxes = this.entryXEdges.get(path.lastNode());
        if (cxes == null) {
            return;
        }
        for (XEdge xe : cxes) {
            SeqNode n1 = xe.dest();
            SeqPhase phase1 = this.getPhase(n1);
            if (phase1 != this.mainPhase() && phase1 != phase && path.contains(phase1)) continue;
            SeqPath path1 = new SeqPath(path, xe);
            path1.addPhase(phase1);
            path1.addDeTs(xe.deTs);
            path1.addPhaseCrosses(xe.phaseCrosses);
            if (phase.contains(phase1)) {
                if (path1.hasDeTWithoutPhaseCross()) continue;
                this.pullPaths.add(path1);
                continue;
            }
            this.growReentryPath(phase, path1);
        }
    }

    private void buildPullMap() throws Xcept {
        this.pullMap = new Hashtable();
        this.pullMapTs = new Hashtable();
        this.circPaths = new ArrayList();
        if (this.pullPaths.size() == 0) {
            return;
        }
        for (int i = 0; i < this.pullPaths.size(); ++i) {
            SeqPath path = this.pullPaths.get(i);
            this.buildPullMap(path);
        }
    }

    private void buildPullMap(SeqPath path) throws Xcept {
        SeqPhase ephase;
        SeqNode xnode = path.firstNode();
        SeqNode enode = path.lastNode();
        SeqPhase xphase = this.getPhase(xnode);
        SeqPhase phase = xphase.commonAncestor(ephase = this.getPhase(enode));
        String t = phase.x();
        if (t == null) {
            throw new Xcept("Reentry path missing deT: " + path);
        }
        LinkedHashSet<SeqNode> pnodes = new LinkedHashSet<SeqNode>();
        LinkedHashSet<SeqNode> dirtys = new LinkedHashSet<SeqNode>();
        pnodes.add(enode);
        dirtys.add(enode);
        while (dirtys.size() > 0) {
            Iterator dns = dirtys.iterator();
            dirtys = new LinkedHashSet();
            while (dns.hasNext()) {
                SeqNode dn = (SeqNode)dns.next();
                Iterator<SeqEdge> es = this.getEdgesFrom(dn);
                while (es.hasNext()) {
                    SeqNode n = es.next().dest();
                    if (pnodes.contains(n) || !phase.contains(this.getPhase(n)) && n.deT() != null && !n.deT().equals(t)) continue;
                    if (n == xnode) {
                        SeqPath cpath = this.extendPath(path, xnode);
                        if (cpath.hasDeTWithoutPhaseCross()) continue;
                        this.circPaths.add(cpath);
                        continue;
                    }
                    pnodes.add(n);
                    dirtys.add(n);
                }
            }
        }
        LinkedHashSet<SeqNode> conflicts = new LinkedHashSet<SeqNode>();
        SeqPhase pullPhase = this.getPhase(path.nextToLastNode());
        for (SeqNode n : pnodes) {
            SeqPhase p = this.pullMap.get(n);
            if (p == null) {
                p = pullPhase;
            }
            if (p != pullPhase) {
                p = p.commonAncestor(pullPhase);
            }
            this.pullMap.put(n, p);
            String nt = this.pullMapTs.get(n);
            if (nt == null) {
                nt = t;
            }
            if (!nt.equals(t)) {
                this.plan.logger.warn("pullMapT conflict: node=" + n + " deTs=" + t + "," + nt);
                conflicts.add(n);
            }
            this.pullMapTs.put(n, nt);
        }
        if (conflicts.size() > 0 && this.plan.hack() != 1) {
            throw new Xcept("pullMapT conflicts for " + conflicts);
        }
    }

    private SeqPath extendPath(SeqPath path, SeqNode xnode) throws Xcept {
        SeqNode enode = path.lastNode();
        if (enode == xnode) {
            return path;
        }
        XEdge xeadd = null;
        if (this.entry2Exits.get(enode) != null) {
            for (XEdge xe : this.entry2Exits.get(enode)) {
                if (xe.dest() != xnode) continue;
                xeadd = xe;
                break;
            }
        }
        if (xeadd == null) {
            xeadd = new XEdge(enode, xnode, null);
        }
        SeqPath cpath = new SeqPath(path, xeadd);
        cpath.addDeTs(xeadd.deTs);
        return cpath;
    }

    private SeqPath extendPath2Circ(SeqPath path) throws Xcept {
        SeqPhase p2;
        SeqNode n2;
        SeqNode n1 = path.firstNode();
        if (n1 == (n2 = path.lastNode())) {
            return path;
        }
        SeqPhase p1 = this.getPhase(n1);
        if (p1 != (p2 = this.getPhase(n2))) {
            return null;
        }
        Iterator<SeqEdge> es = this.getEdgesFrom(n2);
        while (es.hasNext()) {
            SeqEdge e = es.next();
            SeqNode n3 = e.dest();
            if (this.getPhase(n3) != p1) continue;
            SeqPath cpath = new SeqPath(path, e);
            if (n3.deT() != null) {
                cpath.addDeTs((Collection<String>)new StringList(n3.deT()));
            }
            if ((cpath = this.extendPath2Circ(cpath)) == null) continue;
            return cpath;
        }
        return null;
    }

    protected Hashtable<SeqNode, SeqPhase> getPullMap() {
        return this.pullMap;
    }

    protected Hashtable<SeqNode, String> getPullMapTs() {
        return this.pullMapTs;
    }

    protected SeqPath getCircPath() {
        if (this.circPaths.size() == 0) {
            return null;
        }
        return this.circPaths.get(0);
    }

    private LinkedHashSet<String> domainCrosses(SeqPhase p1, SeqPhase p2) throws Xcept {
        LinkedHashSet<String> xs = new LinkedHashSet<String>();
        SeqPhase p0 = p1.commonAncestor(p2);
        while (p1 != p0) {
            xs.add(p1.x());
            p1 = p1.parent();
        }
        while (p2 != p0) {
            xs.add(p2.x());
            p2 = p2.parent();
        }
        return xs;
    }

    public class XEdge
    extends SeqEdge {
        private LinkedHashSet<String> phaseCrosses;
        private LinkedHashSet<String> deTs;

        public XEdge(SeqNode src, SeqNode dest, String deT) throws Xcept {
            super(src, dest);
            this.deTs = new LinkedHashSet();
            if (deT != null) {
                this.deTs.add(deT);
            }
            this.phaseCrosses = SeqPullFinder3.this.domainCrosses(SeqPullFinder3.this.getPhase(src), SeqPullFinder3.this.getPhase(this.dest()));
        }

        public String toString() {
            return super.toString() + this.deTs + "-" + this.phaseCrosses;
        }

        public boolean equals(Object o) {
            if (!(o instanceof XEdge)) {
                return false;
            }
            XEdge xe = (XEdge)o;
            if (!this.src().equals(xe.src())) {
                return false;
            }
            if (!this.dest().equals(xe.dest())) {
                return false;
            }
            return this.deTs.equals(xe.deTs);
        }

        public int hashCode() {
            return super.hashCode() + this.deTs.hashCode();
        }
    }
}

