/*
 * Decompiled with CFR 0.152.
 */
package JSim.plan2;

import JSim.plan2.AbortXcept;
import JSim.plan2.Logger;
import JSim.plan2.SeqEdge;
import JSim.plan2.SeqGraph;
import JSim.plan2.SeqGraphCirc;
import JSim.plan2.SeqIO;
import JSim.plan2.SeqNode;
import JSim.plan2.SeqPath;
import JSim.plan2.SeqPhase;
import JSim.util.Xcept;
import java.io.File;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashSet;

public class SeqUntangler
extends SeqGraph {
    private Logger logger;
    private int maxPulls;
    private int npulls;
    private SeqPhase startPhase;
    private LinkedHashSet<SeqNode> pullNodes;
    private SeqPath circPath;
    private SeqPhase targetPhase;
    private Hashtable<LinkedHashSet<String>, SeqPhase> targetPhases;
    private ArrayList<PrevPullTargets> prevPullTargets;

    public SeqUntangler(SeqGraph graph, Logger logger) throws Xcept {
        super(graph);
        this.logger = logger;
        this.maxPulls = 2;
        this.prevPullTargets = new ArrayList();
    }

    public void setMaxPulls(int ct) {
        this.maxPulls = ct;
    }

    public void untangle() throws Xcept {
        SeqPath path;
        while ((path = this.findReturnPath()) != null) {
            if (this.npulls >= this.maxPulls) {
                throw new Xcept("Untangler exceeded seqMaxPulls=" + this.maxPulls);
            }
            this.log("Collecting pull nodes for " + path);
            this.pullNodes = new LinkedHashSet();
            this.collectPullNodes(path);
            if (this.circPath != null) {
                return;
            }
            this.targetPhase = this.getPhase(path.nextToLastNode());
            this.doPull();
            ++this.npulls;
            if (!this.logger.isVerbose("u")) continue;
            SeqIO.writeNodes((SeqGraph)this, System.out);
        }
    }

    private SeqPath findReturnPath() throws Xcept {
        Iterator<SeqNode> nodes = this.getNodes();
        while (nodes.hasNext()) {
            SeqNode node1 = nodes.next();
            this.startPhase = this.getPhase(node1);
            if (this.startPhase.isMain()) continue;
            Iterator<SeqEdge> edges = this.getEdgesFrom(node1);
            while (edges.hasNext()) {
                this.logger.checkTimeout();
                SeqEdge edge = edges.next();
                SeqNode node2 = edge.dest();
                SeqPhase phase2 = this.getPhase(node2);
                if (this.startPhase.contains(phase2)) continue;
                SeqPath path = new SeqPath();
                path.add(edge);
                this.updatePhaseCrosses(path);
                if ((path = this.traceReturnPath(path)) == null) continue;
                return path;
            }
        }
        return null;
    }

    private SeqPath traceReturnPath(SeqPath path) throws Xcept {
        SeqNode node = path.lastNode();
        SeqPhase phase = this.getPhase(node);
        if (this.startPhase.contains(phase)) {
            return path;
        }
        if (path.hasCirc()) {
            return null;
        }
        this.log("  tracing " + path);
        this.logger.checkTimeout();
        if (path.hasDeTWithoutPhaseCross()) {
            return null;
        }
        Iterator<SeqEdge> edges = this.getEdgesFrom(node);
        while (edges.hasNext()) {
            SeqEdge nedge = edges.next();
            SeqPath npath = new SeqPath(path, nedge);
            this.updatePhaseCrosses(npath);
            if ((npath = this.traceReturnPath(npath)) == null) continue;
            return npath;
        }
        return null;
    }

    private void updatePhaseCrosses(SeqPath path) {
        SeqPhase p2;
        SeqEdge edge = path.lastEdge();
        SeqPhase p1 = this.getPhase(edge.src());
        if (p1 == (p2 = this.getPhase(edge.dest()))) {
            return;
        }
        while (!p1.contains(p2)) {
            path.addPhaseCross(p1.x());
            p1 = p1.parent();
        }
        while (p2 != p1) {
            path.addPhaseCross(p2.x());
            p2 = p2.parent();
        }
    }

    private void collectPullNodes(SeqPath path) throws Xcept {
        SeqNode node = path.lastNode();
        if (this.pullNodes.contains(node)) {
            return;
        }
        if (node == path.firstNode()) {
            this.log("\tfound circ dep: " + path);
            if (this.circPath == null || path.nedges() < this.circPath.nedges()) {
                this.circPath = path;
            }
            return;
        }
        this.log("  add pull node: " + node);
        this.pullNodes.add(node);
        if (path.hasDeTWithoutPhaseCross()) {
            return;
        }
        Iterator<SeqEdge> edges = this.getEdgesFrom(node);
        while (edges.hasNext()) {
            SeqEdge nedge = edges.next();
            SeqPhase nphase = this.getPhase(nedge.dest());
            if (!this.startPhase.contains(nphase)) continue;
            SeqPath npath = new SeqPath(path, nedge);
            this.updatePhaseCrosses(npath);
            this.collectPullNodes(npath);
        }
    }

    private void doPull() throws Xcept {
        this.logger.log("p", "Pulling startPhase=" + this.startPhase + " targetPhase=" + this.targetPhase + " nodes=" + this.pullNodes);
        this.targetPhases = null;
        boolean newTargets = true;
        for (int i = 0; i < this.prevPullTargets.size(); ++i) {
            PrevPullTargets pp = this.prevPullTargets.get(i);
            if (this.startPhase != pp.startPhase || this.targetPhase != pp.targetPhase) continue;
            this.targetPhases = pp.targetPhases;
            newTargets = false;
            break;
        }
        if (this.targetPhases == null) {
            this.targetPhases = new Hashtable();
            this.targetPhases.put(this.targetPhase.loopSet(), this.targetPhase);
        }
        for (SeqNode node : this.pullNodes) {
            SeqPhase ophase = this.getPhase(node);
            SeqPhase nphase = this.getTargetPhase(ophase);
            this.setPhase(node, nphase);
        }
        if (newTargets) {
            this.prevPullTargets.add(new PrevPullTargets(this));
        }
    }

    private SeqPhase getTargetPhase(SeqPhase ophase) throws Xcept {
        SeqPhase nphase = this.targetPhases.get(ophase.loops());
        if (nphase != null) {
            return nphase;
        }
        LinkedHashSet<String> nloops = new LinkedHashSet<String>(this.targetPhase.loops());
        nphase = this.targetPhase;
        for (String x : ophase.loops()) {
            nloops.add(x);
            SeqPhase xphase = this.targetPhases.get(nloops);
            if (xphase == null) {
                nphase = new SeqPhase(this, nphase, x);
                this.log("  creating new pull phase " + nphase);
                this.targetPhases.put(nloops, nphase);
                continue;
            }
            nphase = xphase;
        }
        return nphase;
    }

    public int npulls() {
        return this.npulls;
    }

    public SeqPath circPath() {
        return this.circPath;
    }

    public void log(String msg) {
        this.logger.log(msg);
    }

    public static void main(String[] args) throws Exception {
        File f = new File(args[0]);
        SeqGraph graph = SeqIO.read(f);
        System.out.println("Searching for circdeps ...");
        SeqGraphCirc cgraph = new SeqGraphCirc(graph);
        cgraph.removeFeedFwdNodes();
        SeqPath cpath = cgraph.anyCircPath();
        if (cpath != null) {
            throw new AbortXcept("Circular variable dependency(1): " + cpath);
        }
        System.out.println("Untangling phase loops ...");
        SeqUntangler sgraph = new SeqUntangler(graph, new Logger());
        sgraph.untangle();
        System.out.println("\nUntangling completed with " + sgraph.npulls() + " successful pulls");
        if (sgraph.npulls() > 0) {
            System.out.println("Untangled graph:");
            SeqIO.write((SeqGraph)sgraph, System.out);
        }
    }

    private static class PrevPullTargets {
        public SeqPhase startPhase;
        public SeqPhase targetPhase;
        public Hashtable<LinkedHashSet<String>, SeqPhase> targetPhases;

        public PrevPullTargets(SeqUntangler u) {
            this.startPhase = u.startPhase;
            this.targetPhase = u.targetPhase;
            this.targetPhases = u.targetPhases;
        }

        public String toString() {
            return "[" + this.startPhase + ", " + this.targetPhase + "] " + this.targetPhases;
        }
    }
}

