/*
 * Decompiled with CFR 0.152.
 */
package JSim.plan2;

import JSim.plan2.Logger;
import JSim.plan2.SeqGraph;
import JSim.plan2.SeqGraphCirc;
import JSim.plan2.SeqNode;
import JSim.plan2.SeqPath;
import JSim.plan2.SeqPhase;
import JSim.plan2.SeqPhaseReducer;
import JSim.plan2.SeqPullFinder;
import JSim.util.Xcept;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedHashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SeqUntangler2
extends SeqGraph {
    private Logger logger;
    private int maxNPulls;
    private HashSet<String> xs;
    private int npulls;
    private SeqGraphCirc cgraph;
    private Hashtable<PhasePair, SeqPhase> destPhaseMap;
    private LinkedHashSet<SeqPhase> newDestPhases;
    protected static final int OK = 1;
    protected static final int CIRCDEP = 2;
    protected static final int PULL = 3;

    public SeqUntangler2(SeqGraph graph, Logger logger) throws Xcept {
        super(graph);
        this.logger = logger;
        this.maxNPulls = 2;
        this.xs = new HashSet();
        this.addPhaseDomains(graph.mainPhase());
    }

    private void addPhaseDomains(SeqPhase phase) {
        for (int i = 0; i < phase.subphases.size(); ++i) {
            SeqPhase sphase = phase.subphases.get(i);
            this.xs.add(sphase.x());
            this.addPhaseDomains(sphase);
        }
    }

    public void setMaxPulls(int ct) {
        this.maxNPulls = ct;
    }

    protected void untangle() throws Xcept {
        this.cgraph = new SeqGraphCirc(this);
        this.cgraph.removeFeedFwdNodes();
        this.cgraph.minimize();
        if (this.cgraph.nnodes() > 0) {
            return;
        }
        this.cgraph = null;
        this.npulls = 0;
        boolean working = true;
        while (working) {
            working = false;
            if (this.npulls >= this.maxNPulls) {
                throw new Xcept("Untangler2 exceeded seqMaxPulls=" + this.maxNPulls);
            }
            for (String x : this.xs) {
                int stat = this.untangle(x);
                if (stat == 2) {
                    return;
                }
                if (stat != 3) continue;
                working = true;
            }
        }
    }

    private int untangle(String x) throws Xcept {
        SeqPhaseReducer reducer = new SeqPhaseReducer(this, x);
        reducer.removeDeadEnds();
        if (reducer.nnodes() == 0) {
            return 1;
        }
        SeqPullFinder pf2 = new SeqPullFinder(reducer);
        this.cgraph = new SeqGraphCirc(pf2);
        this.cgraph.removeDeadEnds();
        if (this.cgraph.nnodes() > 0) {
            return 2;
        }
        this.cgraph = null;
        this.doPull(x, pf2.getPullMap());
        ++this.npulls;
        return 3;
    }

    protected SeqPath getCircPath() throws Xcept {
        if (this.cgraph == null) {
            return null;
        }
        return this.cgraph.anyCircPath();
    }

    protected int npulls() {
        return this.npulls;
    }

    private void doPull(String t, Hashtable<SeqNode, SeqPhase> nodePullPhases) throws Xcept {
        this.logger.log("p", "Pulling nodes: " + nodePullPhases);
        this.newDestPhases = new LinkedHashSet();
        this.destPhaseMap = new Hashtable();
        Enumeration<SeqNode> ns = nodePullPhases.keys();
        while (ns.hasMoreElements()) {
            SeqNode n = ns.nextElement();
            SeqPhase origPhase = this.getPhase(n);
            SeqPhase pullPhase = nodePullPhases.get(n);
            SeqPhase destPhase = this.destPhase(origPhase, pullPhase, t);
            this.setPhase(n, destPhase);
        }
    }

    private SeqPhase destPhase(SeqPhase origPhase, SeqPhase pullPhase, String t) throws Xcept {
        PhasePair pp = new PhasePair(origPhase, pullPhase);
        SeqPhase destPhase = this.destPhaseMap.get(pp);
        if (destPhase != null) {
            return destPhase;
        }
        destPhase = pullPhase;
        ArrayList<String> oloops = origPhase.loops();
        while (!oloops.containsAll(destPhase.loops())) {
            destPhase = destPhase.parent();
        }
        for (int i = 0; i < oloops.size(); ++i) {
            String x = oloops.get(i);
            if (destPhase.loops().contains(x)) continue;
            destPhase = this.destSubPhase(destPhase, x, t);
        }
        this.destPhaseMap.put(pp, destPhase);
        this.logger.log("p", "  Phase map: orig=" + origPhase + " pull=" + pullPhase + " dest=" + destPhase);
        return destPhase;
    }

    private SeqPhase destSubPhase(SeqPhase destPhase, String x, String t) throws Xcept {
        SeqPhase sphase = null;
        for (int i = 0; i < destPhase.subphases.size(); ++i) {
            SeqPhase sp = destPhase.subphases.get(i);
            if (!sp.x().equals(x)) continue;
            if (this.newDestPhases.contains(sp)) {
                return sp;
            }
            if (sphase != null && sp.ginx() <= sphase.ginx()) continue;
            sphase = sp;
        }
        if (x.equals(t)) {
            sphase = null;
        }
        if (sphase == null) {
            sphase = new SeqPhase(destPhase, x);
            this.newDestPhases.add(sphase);
            this.logger.log("p", "  Creating new phase: " + sphase);
        }
        return sphase;
    }

    public static class PhasePair {
        public SeqPhase p1;
        public SeqPhase p2;

        public PhasePair(SeqPhase p1, SeqPhase p2) {
            this.p1 = p1;
            this.p2 = p2;
        }

        public int hashCode() {
            return this.p1.hashCode() - 2 * this.p2.hashCode();
        }

        public boolean equals(Object o) {
            if (!(o instanceof PhasePair)) {
                return false;
            }
            PhasePair pp = (PhasePair)o;
            return pp.p1 == this.p1 && pp.p2 == this.p2;
        }
    }
}

