/*
 * Decompiled with CFR 0.152.
 */
package JSim.plan2;

import JSim.plan2.Logger;
import JSim.plan2.Plan;
import JSim.plan2.SeqGraph;
import JSim.plan2.SeqGraphCirc;
import JSim.plan2.SeqNode;
import JSim.plan2.SeqPath;
import JSim.plan2.SeqPhase;
import JSim.plan2.SeqPullFinder3;
import JSim.util.Xcept;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.LinkedHashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SeqUntangler3
extends SeqGraph {
    private Plan plan;
    private int maxNPulls;
    private LinkedHashSet<String> xs;
    private int npulls;
    private SeqPath circPath;
    private Hashtable<PullParms, SeqPhase> destPhaseMap;
    private LinkedHashSet<SeqPhase> newDestPhases;

    public SeqUntangler3(SeqGraph graph, Plan plan) throws Xcept {
        super(graph);
        this.plan = plan;
        this.maxNPulls = 2;
        this.xs = new LinkedHashSet();
        this.addPhaseDomains(graph.mainPhase());
    }

    private void addPhaseDomains(SeqPhase phase) {
        for (int i = 0; i < phase.subphases.size(); ++i) {
            SeqPhase sphase = phase.subphases.get(i);
            this.xs.add(sphase.x());
            this.addPhaseDomains(sphase);
        }
    }

    public void setMaxPulls(int ct) {
        this.maxNPulls = ct;
    }

    protected void untangle() throws Xcept {
        SeqGraphCirc cgraph = new SeqGraphCirc(this);
        cgraph.removeFeedFwdNodes();
        cgraph.minimize();
        if (cgraph.nnodes() > 0) {
            this.circPath = cgraph.anyCircPath();
            return;
        }
        this.npulls = 0;
        boolean working = true;
        while (working) {
            working = false;
            if (this.npulls >= this.maxNPulls) {
                throw new Xcept("Untangler3 exceeded seqMaxPulls=" + this.maxNPulls);
            }
            SeqPullFinder3 pf3 = new SeqPullFinder3(this, this.plan);
            this.circPath = pf3.getCircPath();
            if (this.circPath != null) break;
            this.logger().saveGraph("pullfinder", pf3);
            if (pf3.getPullMap().size() == 0) break;
            this.doPull(pf3.getPullMap(), pf3.getPullMapTs());
            ++this.npulls;
            working = true;
        }
    }

    protected Logger logger() {
        return this.plan.logger;
    }

    protected SeqPath getCircPath() {
        return this.circPath;
    }

    protected int npulls() {
        return this.npulls;
    }

    private void doPull(Hashtable<SeqNode, SeqPhase> nodePullPhases, Hashtable<SeqNode, String> nodePullTs) throws Xcept {
        SeqPhase destPhase;
        PullParms pp;
        this.logger().log("p", "Pulling nodes: " + nodePullPhases + " :: " + nodePullTs);
        Hashtable<SeqNode, PullParms> nodePullParms = new Hashtable<SeqNode, PullParms>();
        Enumeration<SeqNode> ns = nodePullPhases.keys();
        while (ns.hasMoreElements()) {
            SeqNode n = ns.nextElement();
            SeqPhase origPhase = this.getPhase(n);
            SeqPhase pullPhase = nodePullPhases.get(n);
            pullPhase = this.getPhase(pullPhase.name());
            String t = nodePullTs.get(n);
            PullParms pp2 = new PullParms(origPhase, pullPhase, t);
            nodePullParms.put(n, pp2);
        }
        ArrayList pullParms = new ArrayList(new LinkedHashSet(nodePullParms.values()));
        Collections.sort(pullParms);
        this.logger().log("p", "  pullParms=" + pullParms);
        this.newDestPhases = new LinkedHashSet();
        this.destPhaseMap = new Hashtable();
        for (int i = 0; i < pullParms.size(); ++i) {
            pp = (PullParms)pullParms.get(i);
            destPhase = this.destPhase(pp);
            this.logger().log("p", "  mapping " + pp + " -> " + destPhase);
            this.destPhaseMap.put(pp, destPhase);
        }
        this.logger().log("p", "  destPhaseMap=" + this.destPhaseMap);
        ns = nodePullParms.keys();
        while (ns.hasMoreElements()) {
            SeqNode n = ns.nextElement();
            pp = (PullParms)nodePullParms.get(n);
            destPhase = this.destPhaseMap.get(pp);
            this.logger().log("p", "  " + n + ": " + pp + " -> " + destPhase);
            this.setPhase(n, destPhase);
        }
    }

    private SeqPhase destPhase(PullParms pp) throws Xcept {
        SeqPhase destPhase = pp.pullPhase;
        ArrayList<String> oloops = pp.origPhase.loops();
        while (!oloops.containsAll(destPhase.loops())) {
            destPhase = destPhase.parent();
        }
        if (this.parentDestPhase(pp) != null) {
            destPhase = this.parentDestPhase(pp);
        }
        for (int i = 0; i < oloops.size(); ++i) {
            String x = oloops.get(i);
            if (destPhase.loops().contains(x)) continue;
            destPhase = this.destSubPhase(destPhase, x, pp.t);
        }
        return destPhase;
    }

    private SeqPhase parentDestPhase(PullParms pp) throws Xcept {
        while (pp.origPhase.parent() != null) {
            pp = new PullParms(pp.origPhase.parent(), pp.pullPhase, pp.t);
            if (pp.origPhase.x() == null) {
                return null;
            }
            SeqPhase destPhase = this.destPhaseMap.get(pp);
            if (destPhase == null) continue;
            return destPhase;
        }
        return null;
    }

    private SeqPhase destSubPhase(SeqPhase destPhase, String x, String t) throws Xcept {
        SeqPhase sphase = null;
        for (int i = 0; i < destPhase.subphases.size(); ++i) {
            SeqPhase sp = destPhase.subphases.get(i);
            if (!sp.x().equals(x)) continue;
            if (this.newDestPhases.contains(sp)) {
                return sp;
            }
            if (sphase != null && sp.ginx() <= sphase.ginx()) continue;
            sphase = sp;
        }
        if (x.equals(t)) {
            sphase = null;
        }
        if (sphase == null) {
            sphase = new SeqPhase(destPhase, x);
            this.newDestPhases.add(sphase);
            this.logger().log("p", "  Creating new phase: " + sphase);
        }
        return sphase;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PullParms
    implements Comparable<PullParms> {
        public SeqPhase origPhase;
        public SeqPhase pullPhase;
        public String t;

        public PullParms(SeqPhase origPhase, SeqPhase pullPhase, String t) {
            this.origPhase = origPhase;
            this.pullPhase = pullPhase;
            this.t = t;
        }

        public int hashCode() {
            return this.origPhase.hashCode() - 2 * this.pullPhase.hashCode() + 157 * this.t.hashCode();
        }

        public boolean equals(Object o) {
            if (!(o instanceof PullParms)) {
                return false;
            }
            PullParms pp = (PullParms)o;
            return pp.origPhase == this.origPhase && pp.pullPhase == this.pullPhase && pp.t.equals(this.t);
        }

        public String toString() {
            return "" + this.origPhase + "[" + this.t + "]->" + this.pullPhase;
        }

        @Override
        public int compareTo(PullParms pp) {
            SeqPhase p1 = this.origPhase;
            SeqPhase p2 = pp.origPhase;
            if (p1 == p2) {
                return 0;
            }
            try {
                SeqPhase p0 = p1.commonAncestor(p2);
                if (p0 == p1) {
                    return -1;
                }
                if (p0 == p2) {
                    return 1;
                }
                return 0;
            }
            catch (Xcept e) {
                return 0;
            }
        }
    }
}

