/*
 * Decompiled with CFR 0.152.
 */
package JSim.plan2;

import JSim.mml.Domain;
import JSim.mml.Var;
import JSim.plan2.ExprTool;
import JSim.plan2.TExpr;
import JSim.plan2.TModel;
import JSim.plan2.Tool;
import JSim.plan2.VarUsage;
import JSim.plan2.VarUsages;
import JSim.util.Expr;
import JSim.util.Xcept;
import java.util.LinkedHashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StateTool
extends Tool {
    public Var v;
    public Domain t;

    public StateTool(TModel model, Var v) throws Xcept {
        super(model);
        this.v = v;
        this.vsols.add(v);
        if (v.ndim() == 1) {
            this.setT(v.domain(0));
        }
        this.icTools = new LinkedHashSet();
    }

    public void setIC(Tool tool) throws Xcept {
        if (this.icTools.contains(tool)) {
            return;
        }
        if (this.icTools.size() > 0) {
            throw new Xcept("Extern variable " + (Object)((Object)this.v) + " has conflicting ICs: " + tool + " and " + this.icTools);
        }
        this.icTools.add(tool);
        VarUsages vus = tool.vsols;
        for (int i = 0; i < vus.size(); ++i) {
            VarUsage vu = vus.get(i);
            if (vu.v() != this.v || vu.stat() != 2) continue;
            this.setT(vu.domain());
        }
    }

    public void setT(Domain t) throws Xcept {
        if (this.t == null) {
            this.t = t;
        }
        if (this.t != t) {
            throw new Xcept("Ambiguous time domain for state variable " + (Object)((Object)this.v) + " (" + (Object)((Object)t) + ", " + (Object)((Object)this.t) + ")");
        }
        this.vreqs.add(new VarUsage(this.model, this.v, 2, t));
    }

    @Override
    public Tool derivTool(Domain x) throws Xcept {
        Var vx = this.v.deriv(x);
        VarUsage vux = new VarUsage(this.model, vx);
        TExpr zerox = new TExpr(this.model, (Expr)Expr.zero);
        return new ExprTool(vux, zerox);
    }

    public Var v() {
        return this.v;
    }

    @Override
    public Domain t() {
        return this.t;
    }

    public String toString() {
        return "state " + (Object)((Object)this.v);
    }

    @Override
    protected boolean needsICs() {
        return true;
    }

    @Override
    protected boolean isComplete() {
        return this.icTools.size() > 0;
    }

    protected LinkedHashSet<Tool> icTools() {
        return this.icTools;
    }

    @Override
    public String toolType() {
        return "state";
    }
}

