/*
 * Decompiled with CFR 0.152.
 */
package JSim.plan2;

import JSim.mml.Domain;
import JSim.mml.IntegralIF;
import JSim.mml.Var;
import JSim.mml.VarFuncCall;
import JSim.plan2.TModel;
import JSim.plan2.TSubDom;
import JSim.plan2.VarUsage;
import JSim.plan2.VarUsages;
import JSim.util.Algebra;
import JSim.util.CompareExpr;
import JSim.util.ConstExpr;
import JSim.util.DiagInfo;
import JSim.util.Expr;
import JSim.util.IExpr;
import JSim.util.NamedExpr;
import JSim.util.NamedQueryExpr;
import JSim.util.XFuncCall;
import JSim.util.Xcept;
import java.util.ArrayList;
import java.util.Hashtable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TExpr {
    private TModel model;
    private TSubDom subdom;
    private Expr expr;
    private VarUsages usages;
    public static final int QUERY = 0;
    public static final int CURR = 1;
    public static final int MIN = 2;
    public static final int MAX = 3;
    public static final int DELAY = 4;
    public static final int XEXPR = 5;
    public static final int EXPR = 6;

    public TExpr(TModel model, Expr expr) throws Xcept {
        this.model = model;
        this.subdom = model.entire;
        this.expr = expr;
        this.usages = new VarUsages(model);
        this.loadExpr(new Map(), expr);
    }

    private TExpr(TModel model) {
        this.model = model;
    }

    protected TExpr restrict(TSubDom subdom) throws Xcept {
        if (subdom.isEntire()) {
            return this;
        }
        if (!this.variesWith(subdom.domain(), this.expr)) {
            return this;
        }
        TExpr texpr = new TExpr(this.model);
        texpr.subdom = subdom;
        texpr.expr = this.expr;
        texpr.usages = this.usages.restrict(subdom);
        return texpr;
    }

    private void loadExpr(Map map, Expr expr) throws Xcept {
        if (expr instanceof ConstExpr) {
            return;
        }
        if (expr instanceof IExpr) {
            this.loadIExpr(map, (IExpr)expr);
        } else if (expr instanceof Var) {
            this.loadVar(map, (Var)expr);
        } else if (expr instanceof VarFuncCall) {
            this.loadVarFuncCall(map, (VarFuncCall)expr);
        } else if (expr instanceof XFuncCall) {
            this.loadXFuncCall(map, (XFuncCall)expr);
        } else if (expr instanceof IntegralIF) {
            this.loadIntegral(map, (IntegralIF)expr);
        } else {
            throw new Xcept((DiagInfo)expr, "Unsupported TExpr class: " + expr.getClass());
        }
    }

    private void loadExpr(Map map, Expr expr, Domain x, Expr xsub) throws Xcept {
        map = new Map(map);
        map.put(x, xsub);
        map.setUnsolvable();
        this.loadExpr(map, expr);
    }

    private void loadIExpr(Map map, IExpr expr) throws Xcept {
        if (expr.op() == 64) {
            Expr arg = expr.arg(0);
            Domain x = (Domain)expr.arg(1);
            this.loadExpr(map, arg, x, (Expr)x.vmin);
            this.loadExpr(map, arg, x, (Expr)x.vmax);
        } else {
            for (int i = 0; i < expr.nargs(); ++i) {
                this.loadExpr(map, expr.arg(i));
            }
        }
    }

    private void loadVar(Map map, Var v) throws Xcept {
        int[] qstat = new int[v.ndim()];
        for (int i = 0; i < qstat.length; ++i) {
            Domain x = v.domain(i);
            Object expr = (Expr)map.get((Object)x);
            if (expr == null) {
                expr = x;
            }
            qstat[i] = this.qstat(v, x, (Expr)expr);
        }
        VarUsage vu = new VarUsage(this.model, v, qstat);
        if (!map.isSolvable()) {
            vu.setUnsolvable();
        }
        this.usages.add(vu);
    }

    private void loadVarFuncCall(Map map, VarFuncCall vfc) throws Xcept {
        Var v = vfc.v;
        Map nmap = new Map(map);
        for (int i = 0; i < v.ndim(); ++i) {
            Domain x = v.domain(i);
            Expr argx = (Expr)vfc.args.get(i);
            Expr xexpr = (Expr)map.get((Object)x);
            if (xexpr != null) {
                Expr.List list1 = new Expr.List(1);
                list1.add((Object)x);
                Expr.List list2 = new Expr.List(1);
                list2.add((Object)xexpr);
                argx = argx.replace(list1, list2);
            }
            this.loadExpr(map, argx);
            if (argx == x) continue;
            nmap.put(x, argx);
        }
        this.loadVar(nmap, v);
    }

    private int qstat(Var v, Domain x, Expr expr) throws Xcept {
        if (expr == x) {
            return 1;
        }
        if (expr == x.vmin) {
            return 2;
        }
        if (expr == x.vmax) {
            return 3;
        }
        if (this.isDelay(x, expr)) {
            return 4;
        }
        return this.variesWith(x, expr) ? 5 : 6;
    }

    private boolean isDelay(Domain x, Expr expr) throws Xcept {
        if (expr == x) {
            return true;
        }
        if (expr == x.vmin) {
            return true;
        }
        if (!(expr instanceof IExpr)) {
            return false;
        }
        IExpr iexpr = (IExpr)expr;
        if (iexpr.op() == 36) {
            return iexpr.arg(0) == x;
        }
        if (iexpr.op() == 66) {
            return this.isDelay(x, iexpr.arg(1)) && this.isDelay(x, iexpr.arg(2));
        }
        return false;
    }

    public boolean variesWith(Domain x, Expr expr) throws Xcept {
        Expr.List doms = new Expr.List();
        expr.addDomains(doms);
        return doms.containSame((Expr)x);
    }

    private void loadXFuncCall(Map map, XFuncCall fc) throws Xcept {
        for (int i = 0; i < fc.ninputs(); ++i) {
            Expr expr = fc.args().arg(i).orig();
            this.loadExpr(map, expr);
        }
    }

    public void loadIntegral(Map map, IntegralIF summ) throws Xcept {
        this.loadExpr(map, summ.evalExpr());
    }

    public void loadIntegralNEW(Map map, IntegralIF summ) throws Xcept {
        this.loadIntegral(map, summ.u(), summ.t(), summ.min());
        this.loadIntegral(map, summ.u(), summ.t(), summ.max());
    }

    private void loadIntegral(Map map, Expr base, Domain t, Expr bound) throws Xcept {
        Expr.List tList = new Expr.List(1);
        tList.add((Object)t);
        Expr.List boundList = new Expr.List(1);
        boundList.add((Object)bound);
        Expr expr = base.replace(tList, boundList);
        this.loadExpr(map, expr);
    }

    protected TExpr solveFor(Var tv) throws Xcept {
        Var v = tv;
        if (!(this.expr instanceof CompareExpr)) {
            return null;
        }
        CompareExpr bexpr = (CompareExpr)this.expr;
        try {
            Expr nexpr = Algebra.solve((NamedExpr)v, (Expr)bexpr.arg(0), (Expr)bexpr.arg(1));
            TExpr rexpr = new TExpr(this.model, nexpr);
            return rexpr.restrict(this.subdom);
        }
        catch (Xcept e) {
            return null;
        }
    }

    protected TExpr deriv(Domain x) throws Xcept {
        Expr xexpr = this.expr.takeDomDeriv((NamedExpr)x);
        xexpr = xexpr.expandDeriv();
        xexpr = xexpr.simplify();
        this.model.updateVarMaps();
        return new TExpr(this.model, xexpr);
    }

    protected TExpr linearFactor(VarUsage vu, boolean keep) throws Xcept {
        Var qexpr = this.factorUsingV(vu) ? vu.v() : vu.qexpr();
        Expr lexpr = this.expr.linearFactor((NamedQueryExpr)qexpr, keep).simplify();
        TExpr rexpr = new TExpr(this.model, lexpr);
        rexpr = rexpr.restrict(this.subdom);
        return rexpr;
    }

    private boolean factorUsingV(VarUsage vu) {
        if (this.subdom.isEntire()) {
            return false;
        }
        if (this.subdom.isLH() && vu.stat() == 2 && this.subdom.domain() == vu.domain()) {
            return true;
        }
        return this.subdom.isRH() && vu.stat() == 3 && this.subdom.domain() == vu.domain();
    }

    public TExpr zeroExpr() throws Xcept {
        if (!(this.expr instanceof CompareExpr)) {
            return this;
        }
        CompareExpr cexpr = (CompareExpr)this.expr;
        Expr zexpr = cexpr.arg(0).sub(cexpr.arg(1));
        TExpr texpr = new TExpr(this.model, zexpr);
        texpr = texpr.restrict(this.subdom);
        return texpr;
    }

    public VarUsage soleVU() throws Xcept {
        if (this.expr instanceof Var) {
            return new VarUsage(this.subdom, (Var)this.expr);
        }
        if (!(this.expr instanceof VarFuncCall)) {
            return null;
        }
        VarFuncCall vfc = (VarFuncCall)this.expr;
        Var v = vfc.v;
        int[] qstat = new int[v.ndim()];
        for (int i = 0; i < qstat.length; ++i) {
            Domain x = v.domain(i);
            qstat[i] = this.qstat(v, x, vfc.args.expr(i));
        }
        return new VarUsage(this.model, v, qstat);
    }

    protected TExpr div(Expr d) throws Xcept {
        TExpr r = new TExpr(this.model, this.expr.div(d));
        return r.restrict(this.subdom);
    }

    public String toString() {
        String s = "";
        if (!this.subdom.isEntire()) {
            s = "when (" + this.subdom.toString() + ") ";
        }
        return s + this.expr;
    }

    public TModel model() {
        return this.model;
    }

    public Expr expr() {
        return this.expr;
    }

    public TSubDom subdom() {
        return this.subdom;
    }

    public VarUsages usages() {
        return this.usages;
    }

    public boolean isEquals() {
        return this.expr instanceof IExpr && ((IExpr)this.expr).op() == 48;
    }

    public ArrayList<TExpr> arrayList() {
        ArrayList<TExpr> list = new ArrayList<TExpr>();
        list.add(this);
        return list;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Map
    extends Hashtable<Domain, Expr> {
        private boolean solvable;

        protected Map() {
            this.solvable = true;
        }

        protected Map(Map map) {
            super(map);
            this.solvable = map.solvable;
        }

        protected void setUnsolvable() {
            this.solvable = false;
        }

        protected boolean isSolvable() {
            return this.solvable;
        }
    }
}

