/*
 * Decompiled with CFR 0.152.
 */
package JSim.plan2;

import JSim.mml.Domain;
import JSim.mml.Eqn;
import JSim.mml.MathSys;
import JSim.mml.Model;
import JSim.mml.Var;
import JSim.plan2.DomainSet;
import JSim.plan2.Logger;
import JSim.plan2.Plan;
import JSim.plan2.TEqn;
import JSim.plan2.TEvent;
import JSim.plan2.TRelation;
import JSim.plan2.TSubDom;
import JSim.plan2.VarUsage;
import JSim.util.UnitNList;
import JSim.util.XFuncCall;
import JSim.util.Xcept;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.LinkedHashSet;
import java.util.StringTokenizer;

public class TModel {
    protected Plan plan;
    protected Model mmlModel;
    protected MathSys math;
    protected ArrayList<Var> vars;
    protected ArrayList<Domain> doms;
    protected ArrayList<TEqn> eqns;
    protected ArrayList<TRelation> relations;
    protected ArrayList<TEvent> events;
    protected ArrayList<XFuncCall> procs;
    private int nVarsMapped;
    protected Hashtable<Var, DomainSet> domSets;
    protected Hashtable<Var, DomainSet> derivDoms;
    protected Hashtable<Var, DomainSet> pureChildDerivDoms;
    protected LinkedHashSet<VarUsage> vus;
    protected Hashtable<String, Var> varMap;
    protected TSubDom entire;
    protected Hashtable<Domain, TSubDom> lhbcs;
    protected Hashtable<Domain, TSubDom> rhbcs;
    protected Hashtable<VarUsage, LinkedHashSet<TEvent>> vuEvents;

    public TModel(Plan plan, Model model) throws Xcept {
        int i;
        this.plan = plan;
        this.mmlModel = model;
        this.math = this.mmlModel.getFlatMath();
        this.vars = new ArrayList();
        this.varMap = new Hashtable();
        this.doms = new ArrayList();
        this.entire = new TSubDom(this, 1, null);
        this.lhbcs = new Hashtable();
        this.rhbcs = new Hashtable();
        this.eqns = new ArrayList();
        this.relations = new ArrayList();
        this.domSets = new Hashtable();
        this.derivDoms = new Hashtable();
        this.pureChildDerivDoms = new Hashtable();
        this.vus = new LinkedHashSet();
        this.nVarsMapped = 0;
        this.log("Loading Variables");
        this.updateVarMaps();
        this.log("Loading Constraints");
        for (i = 0; i < this.math.eqn.size(); ++i) {
            Eqn eqn = this.math.eqn.eqn(i);
            if (eqn.op == 48) {
                TEqn teqn = new TEqn(this, eqn);
                this.log(teqn);
                this.eqns.add(teqn);
                continue;
            }
            TRelation trel = new TRelation(this, eqn);
            this.log(trel);
            this.relations.add(trel);
        }
        this.procs = new ArrayList();
        for (i = 0; i < this.math.voidFuncCalls.size(); ++i) {
            XFuncCall xfc = (XFuncCall)this.math.voidFuncCalls.get(i);
            this.log(xfc);
            this.procs.add(xfc);
        }
        this.events = new ArrayList();
        for (i = 0; i < this.math.events.size(); ++i) {
            TEvent tev = new TEvent(this, this.math.events.event(i));
            this.log(tev);
            this.events.add(tev);
        }
        this.buildVuEvents();
    }

    protected void updateVarMaps() throws Xcept {
        int i;
        for (i = this.nVarsMapped; i < this.math.nVar(); ++i) {
            Var v = this.math.var(i);
            this.log(v);
            this.vars.add(v);
            this.varMap.put(v.toString(), v);
            if (!(v instanceof Domain)) continue;
            Domain x = (Domain)v;
            this.doms.add(x);
            this.lhbcs.put(x, new TSubDom(this, 2, x));
            this.rhbcs.put(x, new TSubDom(this, 3, x));
        }
        for (i = this.nVarsMapped; i < this.math.nVar(); ++i) {
            this.updateVarMaps(this.math.var(i));
        }
        this.nVarsMapped = this.math.nVar();
    }

    private void updateVarMaps(Var v) throws Xcept {
        this.domSets.put(v, new DomainSet(this, v.domainList()));
        DomainSet vddoms = new DomainSet();
        StringTokenizer stok = new StringTokenizer(v.toString(), ":");
        String tok = stok.nextToken();
        while (stok.hasMoreTokens()) {
            tok = stok.nextToken();
            Domain x = this.domain(tok);
            vddoms.add(x);
        }
        this.derivDoms.put(v, vddoms);
        if (vddoms.size() == 1) {
            Var v0 = v.zeroDeriv();
            if (this.pureChildDerivDoms.get((Object)v0) == null) {
                this.pureChildDerivDoms.put(v0, new DomainSet());
            }
            this.pureChildDerivDoms.get((Object)v0).addAll(vddoms);
        }
    }

    private void buildVuEvents() throws Xcept {
        this.vuEvents = new Hashtable();
        for (int i = 0; i < this.events.size(); ++i) {
            TEvent event = this.events.get(i);
            for (int j = 0; j < event.vacts.size(); ++j) {
                VarUsage vu = event.vacts.get(j);
                LinkedHashSet<TEvent> vevs = this.vuEvents.get(vu);
                if (vevs == null) {
                    vevs = new LinkedHashSet();
                    this.vuEvents.put(vu, vevs);
                }
                vevs.add(event);
            }
        }
    }

    public Var var(Var mmlVar) throws Xcept {
        String vname = mmlVar.toString();
        Var v = this.var(vname);
        if (v == null) {
            throw new Xcept("No Var for variable " + vname);
        }
        return v;
    }

    public Var var(String name) {
        return this.varMap.get(name);
    }

    public Domain domain(Var mmlVar) throws Xcept {
        Var v = this.var(mmlVar);
        if (!(v instanceof Domain)) {
            throw new Xcept("Variable " + (Object)((Object)v) + " is not a domain");
        }
        return (Domain)v;
    }

    public Domain domain(String name) throws Xcept {
        Var v = this.var(name);
        if (!(v instanceof Domain)) {
            throw new Xcept("Variable " + (Object)((Object)v) + " is not a domain");
        }
        return (Domain)v;
    }

    public int ndomains() {
        return this.doms.size();
    }

    public boolean hasDeriv(Var v) {
        DomainSet xs = this.pureChildDerivDoms.get((Object)v);
        return xs != null && xs.size() != 0;
    }

    public boolean isPureDeriv(Var vx) {
        return this.pureDerivDom(vx) != null;
    }

    public Domain pureDerivDom(Var vx) {
        DomainSet xs = this.derivDoms.get((Object)vx);
        if (xs == null) {
            return null;
        }
        if (xs.size() != 1) {
            return null;
        }
        return xs.first();
    }

    protected TSubDom subdom(VarUsage vu) throws Xcept {
        switch (vu.stat()) {
            case 1: {
                return this.entire;
            }
            case 2: {
                return this.lhbcs.get((Object)vu.domain());
            }
            case 3: {
                return this.rhbcs.get((Object)vu.domain());
            }
        }
        throw new Xcept("No subdom for " + vu);
    }

    public Logger logger() {
        return this.plan.logger;
    }

    public void log(String msg) {
        this.logger().log(msg);
    }

    public UnitNList units() {
        return this.mmlModel.units;
    }

    public MathSys math() {
        return this.math;
    }

    public Model mmlModel() {
        return this.mmlModel;
    }

    public void log(Var v) {
        String s = "  add var: ";
        if (v.isPrivate()) {
            s = s + "private ";
        }
        if (v.isExtern()) {
            s = s + "extern ";
        }
        s = s + (v.isInt() ? "int" : "real");
        if (v.isState()) {
            s = s + "State";
        }
        if (v.isDomain()) {
            s = s + "Domain";
        }
        s = s + " " + (Object)((Object)v);
        if (v.ndim() > 0 && !v.isDomain()) {
            s = s + (Object)((Object)v.domainList());
        }
        if (v.unit() != null) {
            s = s + " " + v.unit().name;
        }
        this.log(s);
    }

    public void log(TEqn eqn) {
        this.log("  " + eqn + " :: " + eqn.usages());
    }

    public void log(XFuncCall xfc) {
        this.log("  " + xfc);
    }

    public void log(TEvent event) {
        this.log("  " + event);
    }
}

